/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.interceptors.tests.contract.invocationContext;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.Priority;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.lang.annotation.Annotation;
import java.util.Set;
import org.jboss.cdi.tck.interceptors.tests.contract.invocationContext.SimplePCBinding;

@Interceptor
@SimplePCBinding
@Priority(value=100)
public class PostConstructInterceptor {
    private static boolean getMethodReturnsNull = false;
    private static boolean ctxProceedReturnsNull = false;
    private static Set<Annotation> allBindings = null;

    @PostConstruct
    public void postConstruct(InvocationContext ctx) {
        getMethodReturnsNull = ctx.getMethod() == null;
        try {
            ctxProceedReturnsNull = ctx.proceed() == null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        allBindings = ctx.getInterceptorBindings();
    }

    public static boolean isGetMethodReturnsNull() {
        return getMethodReturnsNull;
    }

    public static boolean isCtxProceedReturnsNull() {
        return ctxProceedReturnsNull;
    }

    public static Set<Annotation> getAllBindings() {
        return allBindings;
    }
}

