/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.beanContainer.assignability;

import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.literal.NamedLiteral;
import jakarta.enterprise.util.TypeLiteral;
import java.util.List;
import java.util.Set;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.beanContainer.assignability.MyBean;
import org.jboss.cdi.tck.tests.beanContainer.assignability.MyBeanInterface;
import org.jboss.cdi.tck.tests.beanContainer.assignability.MyEvent;
import org.jboss.cdi.tck.tests.beanContainer.assignability.MyEventInterface;
import org.jboss.cdi.tck.tests.beanContainer.assignability.MyQualifiedBean;
import org.jboss.cdi.tck.tests.beanContainer.assignability.NonQualifier;
import org.jboss.cdi.tck.tests.beanContainer.assignability.Qualifier1;
import org.jboss.cdi.tck.tests.beanContainer.assignability.Qualifier2;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="4.1")
public class BeanEventAssignabilityTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(BeanEventAssignabilityTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="bm_bean_event_assignability", id="aa"), @SpecAssertion(section="bm_bean_event_assignability", id="af")})
    public void testBeanMatching() {
        Set<Class<Object>> beanTypes = Set.of(MyBean.class, MyBeanInterface.class, Object.class);
        Assert.assertTrue((boolean)this.getCurrentBeanContainer().isMatchingBean(beanTypes, Set.of(), MyBean.class, Set.of()), (String)"Bean did not match its own type");
        Assert.assertFalse((boolean)this.getCurrentBeanContainer().isMatchingBean(beanTypes, Set.of(), MyBean.class, Set.of(Qualifier1.Literal.INSTANCE)), (String)"Bean matched despite not having required qualifier");
        Assert.assertTrue((boolean)this.getCurrentBeanContainer().isMatchingBean(beanTypes, Set.of(Qualifier1.Literal.INSTANCE), MyBean.class, Set.of(Qualifier1.Literal.INSTANCE)), (String)"Bean did not match despite having required qualifier");
        Assert.assertTrue((boolean)this.getCurrentBeanContainer().isMatchingBean(beanTypes, Set.of(Qualifier1.Literal.INSTANCE, Qualifier2.Literal.INSTANCE), MyBean.class, Set.of(Qualifier1.Literal.INSTANCE)), (String)"Bean did not match despite having a superset of the required qualifiers");
        Set<Class<MyBean>> reducedBeanTypes = Set.of(MyBean.class);
        Assert.assertTrue((boolean)this.getCurrentBeanContainer().isMatchingBean(reducedBeanTypes, Set.of(), MyBean.class, Set.of()), (String)"Bean did not match its own type");
        Assert.assertFalse((boolean)this.getCurrentBeanContainer().isMatchingBean(reducedBeanTypes, Set.of(), MyBeanInterface.class, Set.of()), (String)"Bean matched MyBeanInterface despite it not being in bean types");
        Assert.assertTrue((boolean)this.getCurrentBeanContainer().isMatchingBean(reducedBeanTypes, Set.of(), Object.class, Set.of()), (String)"Bean did not match when Object requested");
        Assert.assertTrue((boolean)this.getCurrentBeanContainer().isMatchingBean(Set.of(MyQualifiedBean.class), Set.of(), MyQualifiedBean.class, Set.of()), (String)"MyQualifiedBean should match, qualifier on bean class should be ignored");
        Assert.assertFalse((boolean)this.getCurrentBeanContainer().isMatchingBean(Set.of(MyQualifiedBean.class), Set.of(), MyQualifiedBean.class, Set.of(Qualifier1.Literal.INSTANCE)), (String)"MyQualifiedBean should not match, qualifier on bean class should be ignored");
    }

    @Test
    @SpecAssertion(section="bm_bean_event_assignability", id="ab")
    public void testBeanMatchingDefaultQualifiers() {
        Set<Class<Object>> beanTypes = Set.of(MyBean.class, MyBeanInterface.class, Object.class);
        Assert.assertTrue((boolean)this.getCurrentBeanContainer().isMatchingBean(beanTypes, Set.of(Default.Literal.INSTANCE), MyBean.class, Set.of()), (String)"Bean with @Default should match when no qualifiers required");
        Assert.assertTrue((boolean)this.getCurrentBeanContainer().isMatchingBean(beanTypes, Set.of(), MyBean.class, Set.of(Default.Literal.INSTANCE)), (String)"Bean with no qualifiers should match when @Default required");
        Assert.assertTrue((boolean)this.getCurrentBeanContainer().isMatchingBean(beanTypes, Set.of(Any.Literal.INSTANCE), MyBean.class, Set.of()), (String)"Bean with explicit @Any should match when no qualifiers required");
        Assert.assertTrue((boolean)this.getCurrentBeanContainer().isMatchingBean(beanTypes, Set.of(NamedLiteral.of((String)"foo")), MyBean.class, Set.of()), (String)"Bean with @Named should match when no qualifiers required");
        Assert.assertFalse((boolean)this.getCurrentBeanContainer().isMatchingBean(beanTypes, Set.of(Qualifier1.Literal.INSTANCE), MyBean.class, Set.of()), (String)"Bean with @Qualifier1 should not match when no qualifiers required (@Default implied required)");
        Assert.assertTrue((boolean)this.getCurrentBeanContainer().isMatchingBean(beanTypes, Set.of(), MyBean.class, Set.of(Any.Literal.INSTANCE)), (String)"Bean with no qualifiers should match when @Any required");
        Assert.assertTrue((boolean)this.getCurrentBeanContainer().isMatchingBean(beanTypes, Set.of(Qualifier1.Literal.INSTANCE), MyBean.class, Set.of(Any.Literal.INSTANCE)), (String)"Bean with @Qualifier1 should match when @Any required");
    }

    @Test
    @SpecAssertion(section="bm_bean_event_assignability", id="ac")
    public void testBeanMatchingNullException() {
        Set<Class<Object>> beanTypes = Set.of(MyBean.class, MyBeanInterface.class, Object.class);
        Assert.assertThrows((String)"Null bean type", IllegalArgumentException.class, () -> this.getCurrentBeanContainer().isMatchingBean(null, Set.of(), MyBean.class, Set.of()));
        Assert.assertThrows((String)"Null bean qualifiers", IllegalArgumentException.class, () -> this.getCurrentBeanContainer().isMatchingBean(beanTypes, null, MyBean.class, Set.of()));
        Assert.assertThrows((String)"Null required type", IllegalArgumentException.class, () -> this.getCurrentBeanContainer().isMatchingBean(beanTypes, Set.of(), null, Set.of()));
        Assert.assertThrows((String)"Null required qualifiers", IllegalArgumentException.class, () -> this.getCurrentBeanContainer().isMatchingBean(beanTypes, Set.of(), MyBean.class, null));
    }

    @Test
    @SpecAssertion(section="bm_bean_event_assignability", id="ad")
    public void testBeanMatchingNonQualifiersException() {
        Set<Class<Object>> beanTypes = Set.of(MyBean.class, MyBeanInterface.class, Object.class);
        Assert.assertThrows((String)"beanQualifiers annotation not a qualifier", IllegalArgumentException.class, () -> this.getCurrentBeanContainer().isMatchingBean(beanTypes, Set.of(Qualifier1.Literal.INSTANCE, NonQualifier.Literal.INSTANCE), MyBean.class, Set.of()));
        Assert.assertThrows((String)"requiredQualifiers annotation not a qualifier", IllegalArgumentException.class, () -> this.getCurrentBeanContainer().isMatchingBean(beanTypes, Set.of(), MyBean.class, Set.of(Qualifier1.Literal.INSTANCE, NonQualifier.Literal.INSTANCE)));
    }

    @Test
    @SpecAssertion(section="bm_bean_event_assignability", id="ae")
    public void testNonLegalBeanTypesIgnored() {
        TypeLiteral listOfWildcard = new TypeLiteral<List<?>>(){};
        Set<Class<Object>> beanTypes = Set.of(MyBean.class, MyBeanInterface.class, listOfWildcard.getType(), Object.class);
        Assert.assertTrue((boolean)this.getCurrentBeanContainer().isMatchingBean(beanTypes, Set.of(), MyBean.class, Set.of()), (String)"Non-legal bean type should be ignored, allowing match");
        Assert.assertFalse((boolean)this.getCurrentBeanContainer().isMatchingBean(beanTypes, Set.of(), listOfWildcard.getType(), Set.of()), (String)"Non-legal bean type should be ignored, preventing match");
    }

    @Test
    @SpecAssertion(section="bm_bean_event_assignability", id="ba")
    public void testEventMatching() {
        Assert.assertTrue((boolean)this.getCurrentBeanContainer().isMatchingEvent(MyEvent.class, Set.of(), MyEvent.class, Set.of()), (String)"Event did not match its own type");
        Assert.assertFalse((boolean)this.getCurrentBeanContainer().isMatchingEvent(MyEvent.class, Set.of(), MyEvent.class, Set.of(Qualifier1.Literal.INSTANCE)), (String)"Event matched despite not having required qualifier");
        Assert.assertTrue((boolean)this.getCurrentBeanContainer().isMatchingEvent(MyEvent.class, Set.of(Qualifier1.Literal.INSTANCE), MyEvent.class, Set.of(Qualifier1.Literal.INSTANCE)), (String)"Event did not match despite having required qualifier");
        Assert.assertTrue((boolean)this.getCurrentBeanContainer().isMatchingEvent(MyEvent.class, Set.of(Qualifier1.Literal.INSTANCE, Qualifier2.Literal.INSTANCE), MyEvent.class, Set.of(Qualifier1.Literal.INSTANCE)), (String)"Event did not match despite having a superset of the required qualifiers");
        Assert.assertTrue((boolean)this.getCurrentBeanContainer().isMatchingEvent(MyEvent.class, Set.of(), MyEventInterface.class, Set.of()), (String)"Event should match when a supertype is required");
        Assert.assertTrue((boolean)this.getCurrentBeanContainer().isMatchingEvent(MyEvent.class, Set.of(), Object.class, Set.of()), (String)"Event should match when Object is required");
        Assert.assertTrue((boolean)this.getCurrentBeanContainer().isMatchingEvent(MyEvent.class, Set.of(Default.Literal.INSTANCE), MyEvent.class, Set.of()), (String)"Event with @Default should match when no qualifiers required");
        Assert.assertTrue((boolean)this.getCurrentBeanContainer().isMatchingEvent(MyEvent.class, Set.of(Any.Literal.INSTANCE), MyEvent.class, Set.of()), (String)"Event with explicit @Any should match when no qualifiers required");
        Assert.assertTrue((boolean)this.getCurrentBeanContainer().isMatchingEvent(MyEvent.class, Set.of(Qualifier1.Literal.INSTANCE), MyEvent.class, Set.of()), (String)"Event with @Qualifier1 should match when no qualifiers required");
        Assert.assertTrue((boolean)this.getCurrentBeanContainer().isMatchingEvent(MyEvent.class, Set.of(NamedLiteral.of((String)"foo")), MyEvent.class, Set.of()), (String)"Event with @Named should match when no qualifiers required");
    }

    @Test
    @SpecAssertion(section="bm_bean_event_assignability", id="bf")
    public void testEventMatchingDefaultQualifier() {
        Assert.assertTrue((boolean)this.getCurrentBeanContainer().isMatchingEvent(MyEvent.class, Set.of(), MyEvent.class, Set.of(Default.Literal.INSTANCE)), (String)"Event with no qualifiers should match when @Default required");
        Assert.assertTrue((boolean)this.getCurrentBeanContainer().isMatchingEvent(MyEvent.class, Set.of(Default.Literal.INSTANCE), MyEvent.class, Set.of(Default.Literal.INSTANCE)), (String)"Event with @Default should match when @Default required");
        Assert.assertFalse((boolean)this.getCurrentBeanContainer().isMatchingEvent(MyEvent.class, Set.of(Qualifier1.Literal.INSTANCE), MyEvent.class, Set.of(Default.Literal.INSTANCE)), (String)"Event with @Qualifier1 should not match when @Default required");
    }

    @Test
    @SpecAssertion(section="bm_bean_event_assignability", id="ba")
    public void testEventMatchingParameterized() {
        TypeLiteral<List<String>> listOfString = new TypeLiteral<List<String>>(){};
        TypeLiteral listOfWildcard = new TypeLiteral<List<?>>(){};
        TypeLiteral<List<Integer>> listOfInteger = new TypeLiteral<List<Integer>>(){};
        Assert.assertTrue((boolean)this.getCurrentBeanContainer().isMatchingEvent(listOfString.getType(), Set.of(), listOfString.getType(), Set.of()), (String)"Event with Parameterized type should match when same Parameterized type is requested");
        Assert.assertTrue((boolean)this.getCurrentBeanContainer().isMatchingEvent(listOfString.getType(), Set.of(), listOfWildcard.getType(), Set.of()), (String)"Event with Parameterized type should match when Parameterized type with wildcard is requested");
        Assert.assertFalse((boolean)this.getCurrentBeanContainer().isMatchingEvent(listOfString.getType(), Set.of(), listOfInteger.getType(), Set.of()), (String)"Event with Parameterized type should not match when a different Parameterized type is requested");
    }

    @Test
    @SpecAssertion(section="bm_bean_event_assignability", id="bb")
    public void testEventMatchingAnyQualifier() {
        Assert.assertTrue((boolean)this.getCurrentBeanContainer().isMatchingEvent(MyEvent.class, Set.of(), MyEvent.class, Set.of(Any.Literal.INSTANCE)), (String)"Event with no qualifiers should match when @Any required");
        Assert.assertTrue((boolean)this.getCurrentBeanContainer().isMatchingEvent(MyEvent.class, Set.of(Qualifier1.Literal.INSTANCE), MyEvent.class, Set.of(Any.Literal.INSTANCE)), (String)"Event with @Qualifier1 should match when @Any required");
    }

    @Test
    @SpecAssertion(section="bm_bean_event_assignability", id="bc")
    public void testEventMatchingNullException() {
        Assert.assertThrows((String)"Null event type", IllegalArgumentException.class, () -> this.getCurrentBeanContainer().isMatchingEvent(null, Set.of(), MyBean.class, Set.of()));
        Assert.assertThrows((String)"Null event qualifiers", IllegalArgumentException.class, () -> this.getCurrentBeanContainer().isMatchingEvent(MyEvent.class, null, MyEvent.class, Set.of()));
        Assert.assertThrows((String)"Null required type", IllegalArgumentException.class, () -> this.getCurrentBeanContainer().isMatchingEvent(MyEvent.class, Set.of(), null, Set.of()));
        Assert.assertThrows((String)"Null required qualifiers", IllegalArgumentException.class, () -> this.getCurrentBeanContainer().isMatchingEvent(MyEvent.class, Set.of(), MyEvent.class, null));
    }

    @Test
    @SpecAssertion(section="bm_bean_event_assignability", id="bd")
    public <X> void testEventMatchingTypeVarException() {
        TypeLiteral varEventType = new TypeLiteral<List<X>>(){};
        Assert.assertThrows((String)"Type variable in event type", IllegalArgumentException.class, () -> this.lambda$testEventMatchingTypeVarException$10((TypeLiteral)varEventType));
    }

    @Test
    @SpecAssertion(section="bm_bean_event_assignability", id="be")
    public void testEventMatchingNonQualifiersException() {
        Assert.assertThrows((String)"A specifiedQualifiers annotation not a qualifier", IllegalArgumentException.class, () -> this.getCurrentBeanContainer().isMatchingEvent(MyEvent.class, Set.of(Qualifier1.Literal.INSTANCE, NonQualifier.Literal.INSTANCE), MyEvent.class, Set.of()));
        Assert.assertThrows((String)"An observedEventQualfiers annotation not a qualifier", IllegalArgumentException.class, () -> this.getCurrentBeanContainer().isMatchingEvent(MyEvent.class, Set.of(), MyEvent.class, Set.of(Qualifier1.Literal.INSTANCE, NonQualifier.Literal.INSTANCE)));
    }

    private /* synthetic */ void lambda$testEventMatchingTypeVarException$10(TypeLiteral varEventType) throws Throwable {
        this.getCurrentBeanContainer().isMatchingEvent(varEventType.getType(), Set.of(), MyBean.class, Set.of());
    }
}

