/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.fires;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.Any;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import org.jboss.cdi.tck.tests.event.fires.Item;
import org.jboss.cdi.tck.tests.event.fires.Lifted;
import org.jboss.cdi.tck.tests.event.fires.Restored;

@Dependent
public class MiniBar {
    private Set<Item> items = new HashSet<Item>();
    @Inject
    @Any
    Event<MiniBar> miniBarEvent;
    @Inject
    @Lifted
    Event<Item> itemLiftedEvent;
    @Inject
    @Any
    Event<Item> itemEvent;

    Event<Item> getItemEvent() {
        return this.itemEvent;
    }

    public Set<Item> getItems() {
        return this.items;
    }

    public Item getItemByName(String name) {
        for (Item item : this.items) {
            if (!item.getName().equals(name)) continue;
            return item;
        }
        return null;
    }

    public Item liftItemByName(String name) {
        Item item = this.getItemByName(name);
        if (item != null) {
            this.liftItem(item);
        }
        return item;
    }

    public void liftItem(Item item) {
        if (!this.items.contains(item)) {
            throw new IllegalArgumentException("No such item");
        }
        this.itemLiftedEvent.fire((Object)item);
        this.items.remove(item);
    }

    public void restoreItem(Item item) {
        if (this.items.contains(item)) {
            throw new IllegalArgumentException("Item already restored");
        }
        this.itemEvent.select(new Annotation[]{new Restored.Literal()}).fire((Object)item);
    }

    public void stock() {
        this.stockNoNotify();
        this.miniBarEvent.fire((Object)this);
    }

    public void stockNoNotify() {
        this.items.add(new Item("Chocolate", 5));
        this.items.add(new Item("16 oz Water", 1));
        this.items.add(new Item("Disposable Camera", 10));
    }
}

