/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.invokers.basic;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.build.compatible.spi.BeanInfo;
import jakarta.enterprise.inject.build.compatible.spi.BuildCompatibleExtension;
import jakarta.enterprise.inject.build.compatible.spi.InvokerFactory;
import jakarta.enterprise.inject.build.compatible.spi.Registration;
import jakarta.enterprise.inject.build.compatible.spi.Synthesis;
import jakarta.enterprise.inject.build.compatible.spi.SyntheticComponents;
import jakarta.enterprise.invoke.Invoker;
import java.util.Set;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.invokers.InvokerHolder;
import org.jboss.cdi.tck.tests.invokers.InvokerHolderCreator;
import org.jboss.cdi.tck.tests.invokers.InvokerHolderExtensionBase;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="4.1")
public class VoidMethodInvokerTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(VoidMethodInvokerTest.class)).withClasses(MyService.class)).withBuildCompatibleExtension(TestExtension.class)).withClasses(InvokerHolder.class, InvokerHolderCreator.class, InvokerHolderExtensionBase.class)).build();
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertion(section="behavior_of_invoke", id="m")
    public void test(MyService service, InvokerHolder invokers) throws Exception {
        Invoker hello = invokers.get("hello");
        Assert.assertNull((Object)hello.invoke((Object)service, new Object[]{1}));
        Assert.assertNull((Object)hello.invoke((Object)new MyService(), new Object[]{2}));
        Invoker helloStatic = invokers.get("helloStatic");
        Assert.assertNull((Object)helloStatic.invoke(null, new Object[]{3}));
    }

    @ApplicationScoped
    public static class MyService {
        public void hello(int param) {
        }

        public static void helloStatic(int param) {
        }
    }

    public static class TestExtension
    extends InvokerHolderExtensionBase
    implements BuildCompatibleExtension {
        @Registration(types={MyService.class})
        public void myServiceRegistration(BeanInfo bean, InvokerFactory invokers) {
            this.registerInvokers(bean, invokers, Set.of("hello", "helloStatic"));
        }

        @Synthesis
        public void synthesis(SyntheticComponents syn) {
            this.synthesizeInvokerHolder(syn);
        }
    }
}

