/*
 * Decompiled with CFR 0.152.
 */
package jakarta.enterprise.lang.model;

import jakarta.enterprise.lang.model.AnnotationInfo;
import jakarta.enterprise.lang.model.declarations.ClassInfo;
import jakarta.enterprise.lang.model.types.Type;
import java.util.List;

public interface AnnotationAttributeValue {
    public Kind kind();

    default public boolean isBoolean() {
        return this.kind() == Kind.BOOLEAN;
    }

    default public boolean isByte() {
        return this.kind() == Kind.BYTE;
    }

    default public boolean isShort() {
        return this.kind() == Kind.SHORT;
    }

    default public boolean isInt() {
        return this.kind() == Kind.INT;
    }

    default public boolean isLong() {
        return this.kind() == Kind.LONG;
    }

    default public boolean isFloat() {
        return this.kind() == Kind.FLOAT;
    }

    default public boolean isDouble() {
        return this.kind() == Kind.DOUBLE;
    }

    default public boolean isChar() {
        return this.kind() == Kind.CHAR;
    }

    default public boolean isString() {
        return this.kind() == Kind.STRING;
    }

    default public boolean isEnum() {
        return this.kind() == Kind.ENUM;
    }

    default public boolean isClass() {
        return this.kind() == Kind.CLASS;
    }

    default public boolean isArray() {
        return this.kind() == Kind.ARRAY;
    }

    default public boolean isNestedAnnotation() {
        return this.kind() == Kind.NESTED_ANNOTATION;
    }

    public boolean asBoolean();

    public byte asByte();

    public short asShort();

    public int asInt();

    public long asLong();

    public float asFloat();

    public double asDouble();

    public char asChar();

    public String asString();

    public <E extends Enum<E>> E asEnum();

    public ClassInfo<?> asEnumClass();

    public String asEnumValue();

    public Type asClass();

    public List<AnnotationAttributeValue> asArray();

    public AnnotationInfo asNestedAnnotation();

    public static enum Kind {
        BOOLEAN,
        BYTE,
        SHORT,
        INT,
        LONG,
        FLOAT,
        DOUBLE,
        CHAR,
        STRING,
        ENUM,
        CLASS,
        ARRAY,
        NESTED_ANNOTATION;

    }
}

