/*
 * Decompiled with CFR 0.152.
 */
package jakarta.enterprise.inject.build.compatible.spi;

import jakarta.enterprise.inject.build.compatible.spi.BuildServices;
import jakarta.enterprise.inject.build.compatible.spi.SecurityActions;
import jakarta.enterprise.inject.spi.Prioritized;
import java.util.Collections;
import java.util.Comparator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;

public final class BuildServicesResolver {
    private static final Object lock = new Object();
    private static volatile Set<BuildServices> discoveredBuildServices;
    private static volatile BuildServices configuredBuildServices;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static BuildServices get() {
        if (configuredBuildServices != null) {
            return configuredBuildServices;
        }
        if (discoveredBuildServices == null) {
            Object object = lock;
            synchronized (object) {
                if (discoveredBuildServices == null) {
                    BuildServicesResolver.discoverFactories();
                }
            }
        }
        configuredBuildServices = discoveredBuildServices.iterator().next();
        return configuredBuildServices;
    }

    private static void discoverFactories() {
        TreeSet<BuildServices> factories = new TreeSet<BuildServices>(Comparator.comparingInt(Prioritized::getPriority).reversed());
        ServiceLoader<BuildServices> loader = SecurityActions.loadService(BuildServices.class, BuildServicesResolver.class.getClassLoader());
        if (!loader.iterator().hasNext()) {
            throw new IllegalStateException("Unable to locate BuildServices implementation");
        }
        try {
            for (BuildServices buildServicies : loader) {
                factories.add(buildServicies);
            }
        }
        catch (ServiceConfigurationError e) {
            throw new IllegalStateException(e);
        }
        discoveredBuildServices = Collections.unmodifiableSet(factories);
    }

    public static void setBuildServices(BuildServices instance) {
        if (instance == null) {
            throw new IllegalArgumentException("BuildServices instance must not be null");
        }
        if (configuredBuildServices != null) {
            throw new IllegalStateException("BuildServices cannot be set repeatedly. Existing BuildServices are " + configuredBuildServices);
        }
        configuredBuildServices = instance;
    }
}

