/*
 * Decompiled with CFR 0.152.
 */
package jakarta.enterprise.inject.spi;

import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.AnnotatedCallable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Member;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;

public interface AnnotatedParameter<X>
extends Annotated {
    public int getPosition();

    public AnnotatedCallable<X> getDeclaringCallable();

    default public Parameter getJavaParameter() {
        Member member = this.getDeclaringCallable().getJavaMember();
        if (!(member instanceof Executable)) {
            throw new IllegalStateException("Parameter does not belong to an executable: " + String.valueOf(member));
        }
        Executable executable = (Executable)member;
        return executable.getParameters()[this.getPosition()];
    }

    @Override
    default public <T extends Annotation> Set<T> getAnnotations(Class<T> annotationType) {
        Annotation[] annotationsByType = this.getJavaParameter().getAnnotationsByType(annotationType);
        return new LinkedHashSet<Annotation>(Arrays.asList(annotationsByType));
    }
}

