/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.json.bind.defaultmapping.specifictypes;

import ee.jakarta.tck.json.bind.MappingTester;
import ee.jakarta.tck.json.bind.SimpleMappingTester;
import ee.jakarta.tck.json.bind.TypeContainer;
import ee.jakarta.tck.json.bind.defaultmapping.specifictypes.model.BigDecimalContainer;
import ee.jakarta.tck.json.bind.defaultmapping.specifictypes.model.BigIntegerContainer;
import ee.jakarta.tck.json.bind.defaultmapping.specifictypes.model.OptionalArrayContainer;
import ee.jakarta.tck.json.bind.defaultmapping.specifictypes.model.OptionalContainer;
import ee.jakarta.tck.json.bind.defaultmapping.specifictypes.model.OptionalDoubleContainer;
import ee.jakarta.tck.json.bind.defaultmapping.specifictypes.model.OptionalIntContainer;
import ee.jakarta.tck.json.bind.defaultmapping.specifictypes.model.OptionalLongContainer;
import ee.jakarta.tck.json.bind.defaultmapping.specifictypes.model.OptionalTypeContainer;
import ee.jakarta.tck.json.bind.defaultmapping.specifictypes.model.SimpleContainer;
import ee.jakarta.tck.json.bind.defaultmapping.specifictypes.model.URIContainer;
import ee.jakarta.tck.json.bind.defaultmapping.specifictypes.model.URLContainer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.junit.jupiter.api.Test;

public class SpecificTypesMappingTest {
    @Test
    public void testBigIntegerMapping() {
        new MappingTester<BigInteger>(BigIntegerContainer.class).test(new BigInteger("0"), "0");
    }

    @Test
    public void testBigDecimalMapping() {
        new MappingTester<BigDecimal>(BigDecimalContainer.class).test(new BigDecimal("0.0"), "0.0");
    }

    @Test
    public void testURLMapping() throws Exception {
        new MappingTester<URL>(URLContainer.class).test(new URL("http://www.host.com:80"), "\"http://www.host.com:80\"");
    }

    @Test
    public void testURIMapping() throws URISyntaxException {
        new MappingTester<URI>(URIContainer.class).test(new URI("http://www.host.com:80"), "\"http://www.host.com:80\"");
    }

    @Test
    public void testOptionalMapping() {
        new MappingTester<Optional<String>>(OptionalContainer.class).test(Optional.of("String Value"), "\"String Value\"");
    }

    @Test
    public void testOptionalObjectMapping() {
        OptionalTypeContainer container = new OptionalTypeContainer();
        SimpleContainer simpleContainer = new SimpleContainer();
        simpleContainer.setStringInstance("String Value");
        container.setInstance(Optional.of(simpleContainer));
        new SimpleMappingTester<TypeContainer>(OptionalTypeContainer.class, TypeContainer.class).test(container, "\\{\\s*\"instance\"\\s*:\\s*\\{\\s*\"stringInstance\"\\s*:\\s*\"String Value\"\\s*}\\s*}", "{ \"instance\" : { \"stringInstance\" : \"String Value\" } }", container);
    }

    @Test
    public void testEmptyOptionalMapping() {
        OptionalContainer optionalContainer = new OptionalContainer();
        optionalContainer.setInstance(Optional.empty());
        new SimpleMappingTester<TypeContainer>(OptionalContainer.class, TypeContainer.class).test(optionalContainer, "\\{\\s*}", "{ \"instance\" : null }", optionalContainer);
    }

    @Test
    public void testEmptyOptionalArrayMapping() {
        OptionalArrayContainer optionalContainer = new OptionalArrayContainer();
        optionalContainer.setInstance(new Optional[]{Optional.empty()});
        new SimpleMappingTester<TypeContainer>(OptionalArrayContainer.class, TypeContainer.class).test(optionalContainer, "\\{\\s*\"instance\"\\s*:\\s*\\[\\s*null\\s*]\\s*}", "{ \"instance\" : [ null ] }", optionalContainer);
    }

    @Test
    public void testOptionalIntMapping() {
        new MappingTester<OptionalInt>(OptionalIntContainer.class).test(OptionalInt.of(0), "0");
    }

    @Test
    public void testEmptyOptionalIntMapping() {
        OptionalIntContainer optionalContainer = new OptionalIntContainer();
        optionalContainer.setInstance(OptionalInt.empty());
        new SimpleMappingTester<TypeContainer>(OptionalIntContainer.class, TypeContainer.class).test(optionalContainer, "\\{\\s*}", "{ \"instance\" : null }", optionalContainer);
    }

    @Test
    public void testOptionalLongMapping() {
        new MappingTester<OptionalLong>(OptionalLongContainer.class).test(OptionalLong.of(0L), "0");
    }

    @Test
    public void testEmptyOptionalLongMapping() {
        OptionalLongContainer optionalContainer = new OptionalLongContainer();
        optionalContainer.setInstance(OptionalLong.empty());
        new SimpleMappingTester<TypeContainer>(OptionalLongContainer.class, TypeContainer.class).test(optionalContainer, "\\{\\s*}", "{ \"instance\" : null }", optionalContainer);
    }

    @Test
    public void testOptionalDoubleMapping() {
        new MappingTester<OptionalDouble>(OptionalDoubleContainer.class).test(OptionalDouble.of(0.0), "0.0");
    }

    @Test
    public void testEmptyOptionalDoubleMapping() {
        OptionalDoubleContainer optionalContainer = new OptionalDoubleContainer();
        optionalContainer.setInstance(OptionalDouble.empty());
        new SimpleMappingTester<TypeContainer>(OptionalDoubleContainer.class, TypeContainer.class).test(optionalContainer, "\\{\\s*}", "{ \"instance\" : null }", optionalContainer);
    }
}

