/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.jsonp.api.jsonvaluetests;

import ee.jakarta.tck.jsonp.api.common.TestResult;
import ee.jakarta.tck.jsonp.api.jsonvaluetests.Structure;
import ee.jakarta.tck.jsonp.api.jsonvaluetests.Value;
import ee.jakarta.tck.jsonp.common.JSONP_Util;
import jakarta.json.Json;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClientTests {
    private static final Logger LOGGER = Logger.getLogger(ClientTests.class.getName());

    @Test
    public void jsonValueTypesTest() {
        boolean pass = true;
        try {
            LOGGER.info("Testing getValueType for JsonValue.FALSE value");
            JsonValue.ValueType valueType = JsonValue.FALSE.getValueType();
            if (valueType != JsonValue.ValueType.FALSE) {
                LOGGER.warning("Expected JSON FALSE value type but got instead " + valueType);
                pass = false;
            } else {
                LOGGER.info("Got expected value type for JSON FALSE value");
            }
            LOGGER.info("Testing getValueType for JsonValue.TRUE value");
            valueType = JsonValue.TRUE.getValueType();
            if (valueType != JsonValue.ValueType.TRUE) {
                LOGGER.warning("Expected JSON TRUE value type but got instead " + valueType);
                pass = false;
            } else {
                LOGGER.info("Got expected value type for JSON TRUE value");
            }
            LOGGER.info("Testing getValueType for JsonValue.NULL value");
            valueType = JsonValue.NULL.getValueType();
            if (valueType != JsonValue.ValueType.NULL) {
                LOGGER.warning("Expected JSON NULL value type but got instead " + valueType);
                pass = false;
            } else {
                LOGGER.info("Got expected value type for JSON NULL value");
            }
            LOGGER.info("Testing getValueType for JsonValue.String value");
            valueType = JSONP_Util.createJsonString((String)"string").getValueType();
            if (valueType != JsonValue.ValueType.STRING) {
                LOGGER.warning("Expected JSON STRING value type but got instead " + valueType);
                pass = false;
            } else {
                LOGGER.info("Got expected value type for JSON STRING value");
            }
            LOGGER.info("Testing getValueType for JsonValue.Number value");
            valueType = JSONP_Util.createJsonNumber((int)Integer.MAX_VALUE).getValueType();
            if (valueType != JsonValue.ValueType.NUMBER) {
                LOGGER.warning("Expected JSON NUMBER value type but got instead " + valueType);
                pass = false;
            } else {
                LOGGER.info("Got expected value type for JSON NUMBER value");
            }
            LOGGER.info("Testing getValueType for JsonValue.Array value");
            valueType = JSONP_Util.createJsonArrayFromString((String)"[]").getValueType();
            if (valueType != JsonValue.ValueType.ARRAY) {
                LOGGER.warning("Expected JSON ARRAY value type but got instead " + valueType);
                pass = false;
            } else {
                LOGGER.info("Got expected value type for JSON ARRAY value");
            }
            LOGGER.info("Testing getValueType for JsonValue.Object value");
            valueType = JSONP_Util.createJsonObjectFromString((String)"{}").getValueType();
            if (valueType != JsonValue.ValueType.OBJECT) {
                LOGGER.warning("Expected JSON OBJECT value type but got instead " + valueType);
                pass = false;
            } else {
                LOGGER.info("Got expected value type for JSON OBJECT value");
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonValueTypesTest Failed: ", (Throwable)e);
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonValueTypesTest Failed");
    }

    @Test
    public void jsonValueOfTest() {
        String[] valueTypeStrings;
        boolean pass = true;
        for (String valueTypeString : valueTypeStrings = new String[]{"ARRAY", "FALSE", "NULL", "NUMBER", "OBJECT", "STRING", "TRUE"}) {
            try {
                LOGGER.info("Testing enum value for string constant name " + valueTypeString);
                JsonValue.ValueType valueType = JsonValue.ValueType.valueOf((String)valueTypeString);
                LOGGER.info("Got enum type " + valueType + " for enum string constant named " + valueTypeString);
            }
            catch (Exception e) {
                LOGGER.warning("Caught unexpected exception: " + e);
                pass = false;
            }
        }
        LOGGER.info("Testing negative test case for NullPointerException");
        try {
            JsonValue.ValueType.valueOf(null);
            LOGGER.warning("did not get expected NullPointerException");
            pass = false;
        }
        catch (NullPointerException e) {
            LOGGER.info("Got expected NullPointerException");
        }
        catch (Exception e) {
            LOGGER.warning("Got unexpected exception " + e);
            pass = false;
        }
        LOGGER.info("Testing negative test case for IllegalArgumentException");
        try {
            JsonValue.ValueType.valueOf((String)"INVALID");
            LOGGER.warning("did not get expected IllegalArgumentException");
            pass = false;
        }
        catch (IllegalArgumentException e) {
            LOGGER.info("Got expected IllegalArgumentException");
        }
        catch (Exception e) {
            LOGGER.warning("Got unexpected exception " + e);
            pass = false;
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonValueOfTest Failed");
    }

    @Test
    public void jsonValuesTest() {
        JsonValue.ValueType[] values;
        LOGGER.info("Testing API method JsonValue.ValueType.values() to return array of enums.");
        for (JsonValue.ValueType valueType : values = JsonValue.ValueType.values()) {
            String valueString = JSONP_Util.getValueTypeString((JsonValue.ValueType)valueType);
            if (valueString == null) {
                Assertions.fail((String)("jsonValuesTest Failed. Got no value for enum " + valueType));
                continue;
            }
            LOGGER.info("Got " + valueString + " for enum " + valueType);
        }
    }

    @Test
    public void jsonValueToStringTest() {
        boolean pass = true;
        try {
            LOGGER.info("Testing JsonValue.toString() for JsonValue.FALSE value");
            String stringValue = JsonValue.FALSE.toString();
            LOGGER.info("stringValue=" + stringValue);
            if (!stringValue.equals("false")) {
                LOGGER.warning("Expected false");
                pass = false;
            } else {
                LOGGER.info("Got " + stringValue);
            }
            LOGGER.info("Testing JsonValue.toString() for JsonValue.TRUE value");
            stringValue = JsonValue.TRUE.toString();
            LOGGER.info("stringValue=" + stringValue);
            if (!stringValue.equals("true")) {
                LOGGER.warning("Expected true");
                pass = false;
            } else {
                LOGGER.info("Got " + stringValue);
            }
            LOGGER.info("Testing JsonValue.toString() for JsonValue.NULL value");
            stringValue = JsonValue.NULL.toString();
            LOGGER.info("stringValue=" + stringValue);
            if (!stringValue.equals("null")) {
                LOGGER.warning("Expected null");
                pass = false;
            } else {
                LOGGER.info("Got " + stringValue);
            }
            LOGGER.info("Testing JsonValue.toString() for JsonString value");
            JsonString jsonValue = JSONP_Util.createJsonString((String)"string");
            stringValue = jsonValue.toString();
            LOGGER.info("stringValue=" + stringValue);
            if (!stringValue.equals("\"string\"")) {
                LOGGER.warning("Expected \"string\"");
                pass = false;
            } else {
                LOGGER.info("Got " + stringValue);
            }
            LOGGER.info("Testing JsonValue.toString() for JsonNumber value");
            jsonValue = JSONP_Util.createJsonNumber((int)10);
            stringValue = jsonValue.toString();
            LOGGER.info("stringValue=" + stringValue);
            if (!stringValue.equals("10")) {
                LOGGER.warning("Expected 10");
                pass = false;
            } else {
                LOGGER.info("Got " + stringValue);
            }
            LOGGER.info("Testing JsonValue.toString() for JsonArray value");
            jsonValue = JSONP_Util.createJsonArrayFromString((String)"[]");
            stringValue = jsonValue.toString();
            LOGGER.info("stringValue=" + stringValue);
            if (!stringValue.equals("[]")) {
                LOGGER.warning("Expected []");
                pass = false;
            } else {
                LOGGER.info("Got " + stringValue);
            }
            LOGGER.info("Testing JsonValue.toString() for JsonObject value");
            jsonValue = JSONP_Util.createJsonObjectFromString((String)"{}");
            stringValue = jsonValue.toString();
            LOGGER.info("stringValue=" + stringValue);
            if (!stringValue.equals("{}")) {
                LOGGER.warning("Expected {}");
                pass = false;
            } else {
                LOGGER.info("Got " + stringValue);
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonValueToStringTest Failed: ", (Throwable)e);
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonValueToStringTest Failed");
    }

    @Test
    public void jsonValue11Test() {
        Value valueTest = new Value();
        TestResult result = valueTest.test();
        result.eval();
    }

    @Test
    public void jsonStructure11Test() {
        Structure structTest = new Structure();
        TestResult result = structTest.test();
        result.eval();
    }

    @Test
    public void jsonNumber21Test() {
        Assertions.assertEquals((Object)Json.createValue((int)1), (Object)Json.createValue((Number)1));
        Assertions.assertEquals((Object)Json.createValue((int)1).toString(), (Object)Json.createValue((Number)1).toString());
        Assertions.assertEquals((Object)Json.createValue((int)1), (Object)Json.createValue((Number)1));
        Assertions.assertEquals((Object)Json.createValue((int)1).toString(), (Object)Json.createValue((Number)1).toString());
        Assertions.assertEquals((Object)Json.createValue((int)1), (Object)Json.createValue((Number)1));
        Assertions.assertEquals((Object)Json.createValue((int)1).toString(), (Object)Json.createValue((Number)1).toString());
        Assertions.assertEquals((Object)Json.createValue((long)1L), (Object)Json.createValue((Number)1L));
        Assertions.assertEquals((Object)Json.createValue((long)1L).toString(), (Object)Json.createValue((Number)1L).toString());
        Assertions.assertEquals((Object)Json.createValue((double)1.0), (Object)Json.createValue((Number)Float.valueOf(1.0f)));
        Assertions.assertEquals((Object)Json.createValue((double)1.0).toString(), (Object)Json.createValue((Number)Float.valueOf(1.0f)).toString());
        Assertions.assertEquals((Object)Json.createValue((double)1.0), (Object)Json.createValue((Number)1.0));
        Assertions.assertEquals((Object)Json.createValue((double)1.0).toString(), (Object)Json.createValue((Number)1.0).toString());
        Assertions.assertEquals((Object)Json.createValue((int)1), (Object)Json.createValue((Number)new CustomNumber(1)));
        Assertions.assertEquals((Object)Json.createValue((int)1).toString(), (Object)Json.createValue((Number)new CustomNumber(1)).toString());
    }

    private static class CustomNumber
    extends Number {
        private static final long serialVersionUID = 1L;
        private final int num;

        private CustomNumber(int num) {
            this.num = num;
        }

        @Override
        public int intValue() {
            return this.num;
        }

        @Override
        public long longValue() {
            return this.num;
        }

        @Override
        public float floatValue() {
            return this.num;
        }

        @Override
        public double doubleValue() {
            return this.num;
        }

        public String toString() {
            return Integer.toString(this.num);
        }
    }
}

