/*
 * Decompiled with CFR 0.152.
 */
package jakarta.mail.util;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.ServiceLoader;

class FactoryFinder {
    FactoryFinder() {
    }

    static <T> T find(Class<T> factoryClass) throws RuntimeException {
        T result;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null && (result = FactoryFinder.find(factoryClass, loader)) != null) {
            return result;
        }
        loader = factoryClass.getClassLoader();
        if (loader != null && (result = FactoryFinder.find(factoryClass, loader)) != null) {
            return result;
        }
        result = FactoryFinder.find(factoryClass, ClassLoader.getSystemClassLoader());
        if (result != null) {
            return result;
        }
        throw new IllegalStateException("No provider of " + factoryClass.getName() + " was found");
    }

    private static <T> T find(Class<T> factoryClass, ClassLoader loader) throws RuntimeException {
        T result;
        String className = FactoryFinder.fromSystemProperty(factoryClass.getName());
        if (className != null && (result = FactoryFinder.newInstance(className, factoryClass, loader)) != null) {
            return result;
        }
        T factory = FactoryFinder.factoryFromServiceLoader(factoryClass, loader);
        if (factory != null) {
            return factory;
        }
        T result2 = FactoryFinder.lookupUsingHk2ServiceLoader(factoryClass, loader);
        if (result2 != null) {
            return result2;
        }
        return null;
    }

    private static <T> T newInstance(String className, Class<T> factoryClass, ClassLoader classLoader) throws RuntimeException {
        try {
            if (classLoader == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            Class<?> clazz = Class.forName(className, false, classLoader);
            return clazz.asSubclass(factoryClass).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassCastException wrongLoader) {
            return null;
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("Cannot instance " + className, e);
        }
    }

    private static String fromSystemProperty(String factoryId) {
        String systemProp = System.getProperty(factoryId);
        return systemProp;
    }

    private static Class<?>[] getHk2ServiceLoaderTargets(Class<?> factoryClass) {
        ClassLoader[] loaders = new ClassLoader[]{Thread.currentThread().getContextClassLoader(), factoryClass.getClassLoader(), ClassLoader.getSystemClassLoader()};
        Class[] classes = new Class[loaders.length];
        int w = 0;
        for (ClassLoader loader : loaders) {
            if (loader == null) continue;
            try {
                classes[w++] = Class.forName("org.glassfish.hk2.osgiresourcelocator.ServiceLoader", false, loader);
            }
            catch (Exception | LinkageError throwable) {
                // empty catch block
            }
        }
        if (classes.length != w) {
            classes = Arrays.copyOf(classes, w);
        }
        return classes;
    }

    private static <T> T lookupUsingHk2ServiceLoader(Class<T> factoryClass, ClassLoader loader) {
        for (Class<?> target : FactoryFinder.getHk2ServiceLoaderTargets(factoryClass)) {
            try {
                Iterator iter;
                Class<?> serviceClass = Class.forName(factoryClass.getName(), false, loader);
                Class[] args = new Class[]{serviceClass};
                Method m = target.getMethod("lookupProviderInstances", Class.class);
                Iterable iterable = (Iterable)m.invoke(null, (Object[])args);
                if (iterable == null || !(iter = iterable.iterator()).hasNext()) continue;
                return factoryClass.cast(iter.next());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static <T> T factoryFromServiceLoader(Class<T> factory, ClassLoader loader) {
        try {
            ServiceLoader<T> sl = ServiceLoader.load(factory, loader);
            Iterator<T> iter = sl.iterator();
            if (iter.hasNext()) {
                return factory.cast(iter.next());
            }
            return null;
        }
        catch (ClassCastException wrongLoader) {
            return null;
        }
        catch (Throwable t) {
            throw new IllegalStateException("Cannot load " + factory + " as ServiceLoader", t);
        }
    }
}

