/*
 * Decompiled with CFR 0.152.
 */
package jakarta.nosql.column;

import jakarta.nosql.ServiceLoaderProvider;
import jakarta.nosql.Sort;
import jakarta.nosql.column.ColumnCondition;
import jakarta.nosql.column.ColumnEntity;
import jakarta.nosql.column.ColumnManager;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public interface ColumnQuery {
    public long getLimit();

    public long getSkip();

    public String getColumnFamily();

    public Optional<ColumnCondition> getCondition();

    public List<String> getColumns();

    public List<Sort> getSorts();

    public static ColumnSelect select(String ... columns) {
        return (ColumnSelect)((ColumnSelectProvider)ServiceLoaderProvider.get(ColumnSelectProvider.class, () -> ServiceLoader.load(ColumnSelectProvider.class))).apply(columns);
    }

    public static ColumnSelect select() {
        return (ColumnSelect)((ColumnSelectProvider)ServiceLoaderProvider.get(ColumnSelectProvider.class, () -> ServiceLoader.load(ColumnSelectProvider.class))).get();
    }

    public static ColumnQueryBuilder builder() {
        return (ColumnQueryBuilder)((ColumnQueryBuilderProvider)ServiceLoaderProvider.get(ColumnQueryBuilderProvider.class, () -> ServiceLoader.load(ColumnQueryBuilderProvider.class))).get();
    }

    public static ColumnQueryBuilder builder(String ... documents) {
        return (ColumnQueryBuilder)((ColumnQueryBuilderProvider)ServiceLoaderProvider.get(ColumnQueryBuilderProvider.class, () -> ServiceLoader.load(ColumnQueryBuilderProvider.class))).apply(documents);
    }

    public static interface ColumnQueryBuilder {
        public ColumnQueryBuilder select(String var1);

        public ColumnQueryBuilder select(String ... var1);

        public ColumnQueryBuilder sort(Sort var1);

        public ColumnQueryBuilder sort(Sort ... var1);

        public ColumnQueryBuilder from(String var1);

        public ColumnQueryBuilder where(ColumnCondition var1);

        public ColumnQueryBuilder skip(long var1);

        public ColumnQueryBuilder limit(long var1);

        public ColumnQuery build();

        public Stream<ColumnEntity> getResult(ColumnManager var1);

        public Optional<ColumnEntity> getSingleResult(ColumnManager var1);
    }

    public static interface ColumnNotCondition
    extends ColumnNameCondition {
    }

    public static interface ColumnNameCondition {
        public <T> ColumnWhere eq(T var1);

        public ColumnWhere like(String var1);

        public <T> ColumnWhere gt(T var1);

        public <T> ColumnWhere gte(T var1);

        public <T> ColumnWhere lt(T var1);

        public <T> ColumnWhere lte(T var1);

        public <T> ColumnWhere between(T var1, T var2);

        public <T> ColumnWhere in(Iterable<T> var1);

        public ColumnNotCondition not();
    }

    public static interface ColumnWhere
    extends ColumnQueryBuild {
        public ColumnNameCondition and(String var1);

        public ColumnNameCondition or(String var1);

        public ColumnSkip skip(long var1);

        public ColumnLimit limit(long var1);

        public ColumnOrder orderBy(String var1);
    }

    public static interface ColumnSkip
    extends ColumnQueryBuild {
        public ColumnLimit limit(long var1);
    }

    public static interface ColumnQueryBuilderProvider
    extends Function<String[], ColumnQueryBuilder>,
    Supplier<ColumnQueryBuilder> {
    }

    public static interface ColumnSelectProvider
    extends Function<String[], ColumnSelect>,
    Supplier<ColumnSelect> {
    }

    public static interface ColumnSelect {
        public ColumnFrom from(String var1);
    }

    public static interface ColumnQueryBuild {
        public ColumnQuery build();

        public Stream<ColumnEntity> getResult(ColumnManager var1);

        public Optional<ColumnEntity> getSingleResult(ColumnManager var1);
    }

    public static interface ColumnOrder {
        public ColumnNameOrder asc();

        public ColumnNameOrder desc();
    }

    public static interface ColumnNameOrder
    extends ColumnQueryBuild {
        public ColumnOrder orderBy(String var1);

        public ColumnSkip skip(long var1);

        public ColumnLimit limit(long var1);
    }

    public static interface ColumnLimit
    extends ColumnQueryBuild {
        public ColumnSkip skip(long var1);
    }

    public static interface ColumnFrom
    extends ColumnQueryBuild {
        public ColumnNameCondition where(String var1);

        public ColumnSkip skip(long var1);

        public ColumnLimit limit(long var1);

        public ColumnOrder orderBy(String var1);
    }
}

