/*
 * Decompiled with CFR 0.152.
 */
package jakarta.nosql.column;

import jakarta.nosql.Value;
import jakarta.nosql.column.Column;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public final class Columns {
    private static final Predicate<Map.Entry<String, ?>> IS_VALUE_NULL = e -> Objects.nonNull(e.getValue());

    private Columns() {
    }

    public static Column of(String name, Object value) {
        return Column.of(name, Value.of((Object)value));
    }

    public static List<Column> of(Map<String, ?> values) {
        Objects.requireNonNull(values, "values is required");
        return values.entrySet().stream().filter(IS_VALUE_NULL).map(e -> Column.of((String)e.getKey(), Columns.getValue(e.getValue()))).collect(Collectors.toList());
    }

    private static Object getValue(Object value) {
        if (value instanceof Map) {
            List<Column> list = Columns.of((Map)Map.class.cast(value));
            if (list.size() == 1) {
                return list.get(0);
            }
            return list;
        }
        if (value instanceof Iterable) {
            return StreamSupport.stream(((Iterable)Iterable.class.cast(value)).spliterator(), false).map(Columns::getValue).collect(Collectors.toList());
        }
        return value;
    }
}

