/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.component;

import jakarta.el.ELException;
import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.application.Application;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.AttachedObjectListHolder;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.MessageFactory;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIOutput;
import jakarta.faces.component.UIViewParameter;
import jakarta.faces.component.UpdateModelException;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.ConverterException;
import jakarta.faces.event.ExceptionQueuedEvent;
import jakarta.faces.event.ExceptionQueuedEventContext;
import jakarta.faces.event.PhaseId;
import jakarta.faces.event.PostValidateEvent;
import jakarta.faces.event.PreValidateEvent;
import jakarta.faces.event.ValueChangeEvent;
import jakarta.faces.event.ValueChangeListener;
import jakarta.faces.render.Renderer;
import jakarta.faces.validator.BeanValidator;
import jakarta.faces.validator.Validator;
import jakarta.faces.validator.ValidatorException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class UIInput
extends UIOutput
implements EditableValueHolder {
    private static final String BEANS_VALIDATION_AVAILABLE = "jakarta.faces.private.BEANS_VALIDATION_AVAILABLE";
    public static final String COMPONENT_TYPE = "jakarta.faces.Input";
    public static final String COMPONENT_FAMILY = "jakarta.faces.Input";
    public static final String CONVERSION_MESSAGE_ID = "jakarta.faces.component.UIInput.CONVERSION";
    public static final String REQUIRED_MESSAGE_ID = "jakarta.faces.component.UIInput.REQUIRED";
    public static final String UPDATE_MESSAGE_ID = "jakarta.faces.component.UIInput.UPDATE";
    public static final String VALIDATE_EMPTY_FIELDS_PARAM_NAME = "jakarta.faces.VALIDATE_EMPTY_FIELDS";
    public static final String EMPTY_STRING_AS_NULL_PARAM_NAME = "jakarta.faces.INTERPRET_EMPTY_STRING_SUBMITTED_VALUES_AS_NULL";
    public static final String ALWAYS_PERFORM_VALIDATION_WHEN_REQUIRED_IS_TRUE = "jakarta.faces.ALWAYS_PERFORM_VALIDATION_WHEN_REQUIRED_IS_TRUE";
    private static final Validator[] EMPTY_VALIDATOR = new Validator[0];
    private transient Boolean emptyStringIsNull;
    private transient Boolean validateEmptyFields;
    private transient Boolean isSetAlwaysValidateRequired;
    private transient Object submittedValue = null;
    AttachedObjectListHolder<Validator> validators;

    public UIInput() {
        this.setRendererType("jakarta.faces.Text");
    }

    @Override
    public String getFamily() {
        return "jakarta.faces.Input";
    }

    @Override
    public Object getSubmittedValue() {
        if (this.submittedValue == null && !this.isValid() && this.considerEmptyStringNull(FacesContext.getCurrentInstance())) {
            return "";
        }
        return this.submittedValue;
    }

    @Override
    public void setSubmittedValue(Object submittedValue) {
        this.submittedValue = submittedValue;
    }

    @Override
    public Object getValue() {
        return this.isLocalValueSet() ? this.getLocalValue() : super.getValue();
    }

    @Override
    public void setValue(Object value) {
        super.setValue(value);
        this.setLocalValueSet(true);
    }

    @Override
    public void resetValue() {
        super.resetValue();
        this.setSubmittedValue(null);
        this.getStateHelper().remove((Serializable)((Object)PropertyKeys.localValueSet));
        this.getStateHelper().remove((Serializable)((Object)PropertyKeys.valid));
    }

    @Override
    public boolean isLocalValueSet() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.localValueSet), false);
    }

    @Override
    public void setLocalValueSet(boolean localValueSet) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.localValueSet), localValueSet);
    }

    @Override
    public boolean isRequired() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.required), false);
    }

    public String getRequiredMessage() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.requiredMessage));
    }

    public void setRequiredMessage(String message) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.requiredMessage), message);
    }

    public String getConverterMessage() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.converterMessage));
    }

    public void setConverterMessage(String message) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.converterMessage), message);
    }

    public String getValidatorMessage() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.validatorMessage));
    }

    public void setValidatorMessage(String message) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.validatorMessage), message);
    }

    @Override
    public boolean isValid() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.valid), true);
    }

    @Override
    public void setValid(boolean valid) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.valid), valid);
    }

    @Override
    public void setRequired(boolean required) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.required), required);
    }

    @Override
    public boolean isImmediate() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.immediate), false);
    }

    @Override
    public void setImmediate(boolean immediate) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.immediate), immediate);
    }

    @Override
    public void markInitialState() {
        super.markInitialState();
        if (this.validators != null) {
            this.validators.markInitialState();
        }
    }

    @Override
    public void clearInitialState() {
        if (this.initialStateMarked()) {
            super.clearInitialState();
            if (this.validators != null) {
                this.validators.clearInitialState();
            }
        }
    }

    @Override
    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        super.processDecodes(context);
        if (this.isImmediate()) {
            this.executeValidate(context);
        }
    }

    @Override
    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.pushComponentToEL(context, this);
        if (!this.isImmediate()) {
            Application application = context.getApplication();
            application.publishEvent(context, PreValidateEvent.class, this);
            this.executeValidate(context);
            application.publishEvent(context, PostValidateEvent.class, this);
        }
        Iterator<UIComponent> i = this.getFacetsAndChildren();
        while (i.hasNext()) {
            i.next().processValidators(context);
        }
        this.popComponentFromEL(context);
    }

    @Override
    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        super.processUpdates(context);
        this.pushComponentToEL(context, this);
        try {
            this.updateModel(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        finally {
            this.popComponentFromEL(context);
        }
        if (!this.isValid()) {
            context.renderResponse();
        }
    }

    @Override
    public void decode(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        this.setValid(true);
        super.decode(context);
    }

    public void updateModel(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isValid() || !this.isLocalValueSet()) {
            return;
        }
        ValueExpression ve = this.getValueExpression("value");
        if (ve != null) {
            Exception caught = null;
            FacesMessage message = null;
            try {
                ve.setValue(context.getELContext(), this.getLocalValue());
                this.resetValue();
            }
            catch (ELException e) {
                caught = e;
                String messageStr = e.getMessage();
                for (Throwable result = e.getCause(); null != result && result.getClass().isAssignableFrom(ELException.class); result = result.getCause()) {
                    messageStr = result.getMessage();
                }
                message = null == messageStr ? MessageFactory.getMessage(context, UPDATE_MESSAGE_ID, MessageFactory.getLabel(context, this)) : new FacesMessage(FacesMessage.SEVERITY_ERROR, messageStr, messageStr);
                this.setValid(false);
            }
            catch (Exception e) {
                caught = e;
                message = MessageFactory.getMessage(context, UPDATE_MESSAGE_ID, MessageFactory.getLabel(context, this));
                this.setValid(false);
            }
            if (caught != null) {
                assert (message != null);
                UpdateModelException toQueue = new UpdateModelException(message, (Throwable)caught);
                ExceptionQueuedEventContext eventContext = new ExceptionQueuedEventContext(context, toQueue, this, PhaseId.UPDATE_MODEL_VALUES);
                context.getApplication().publishEvent(context, ExceptionQueuedEvent.class, eventContext);
            }
        }
    }

    public void validate(FacesContext context) {
        Object newValue;
        block8: {
            if (context == null) {
                throw new NullPointerException();
            }
            Object submittedValue = this.getSubmittedValue();
            if (!(submittedValue != null || this.isRequired() && this.isSetAlwaysValidateRequired(context))) {
                if (this instanceof UIViewParameter && this.considerEmptyStringNull(context)) {
                    this.validateValue(context, this.getConvertedValue(context, submittedValue));
                }
                return;
            }
            if (this.considerEmptyStringNull(context) && submittedValue instanceof String && ((String)submittedValue).length() == 0) {
                this.setSubmittedValue(null);
                submittedValue = null;
            }
            newValue = null;
            try {
                newValue = this.getConvertedValue(context, submittedValue);
            }
            catch (ConverterException ce) {
                this.addConversionErrorMessage(context, ce);
                this.setValid(false);
                if (submittedValue != null) break block8;
                this.setSubmittedValue("");
            }
        }
        this.validateValue(context, newValue);
        if (this.isValid()) {
            Object previous = this.getValue();
            this.setValue(newValue);
            this.setSubmittedValue(null);
            if (this.compareValues(previous, newValue)) {
                this.queueEvent(new ValueChangeEvent(context, this, previous, newValue));
            }
        }
    }

    private boolean isSetAlwaysValidateRequired(FacesContext context) {
        if (null != this.isSetAlwaysValidateRequired) {
            return this.isSetAlwaysValidateRequired;
        }
        Boolean bool = (Boolean)context.getAttributes().get(ALWAYS_PERFORM_VALIDATION_WHEN_REQUIRED_IS_TRUE);
        if (null != bool) {
            this.isSetAlwaysValidateRequired = bool;
        } else {
            String val = context.getExternalContext().getInitParameter(ALWAYS_PERFORM_VALIDATION_WHEN_REQUIRED_IS_TRUE);
            this.isSetAlwaysValidateRequired = Boolean.valueOf(val);
        }
        return this.isSetAlwaysValidateRequired;
    }

    protected Object getConvertedValue(FacesContext context, Object newSubmittedValue) throws ConverterException {
        Converter converter;
        Renderer renderer = this.getRenderer(context);
        Object newValue = renderer != null ? renderer.getConvertedValue(context, this, newSubmittedValue) : (newSubmittedValue instanceof String ? ((converter = this.getConverterWithType(context)) != null ? converter.getAsObject(context, this, (String)newSubmittedValue) : newSubmittedValue) : newSubmittedValue);
        return newValue;
    }

    protected void validateValue(FacesContext context, Object newValue) {
        if (this.isValid() && this.isRequired() && UIInput.isEmpty(newValue)) {
            String requiredMessageStr = this.getRequiredMessage();
            FacesMessage message = null != requiredMessageStr ? new FacesMessage(FacesMessage.SEVERITY_ERROR, requiredMessageStr, requiredMessageStr) : MessageFactory.getMessage(context, REQUIRED_MESSAGE_ID, MessageFactory.getLabel(context, this));
            context.addMessage(this.getClientId(context), message);
            this.setValid(false);
        }
        if (this.isValid() && (!UIInput.isEmpty(newValue) || this.validateEmptyFields(context)) && this.validators != null) {
            Validator[] validators;
            for (Validator validator : validators = this.validators.asArray(Validator.class)) {
                try {
                    validator.validate(context, this, newValue);
                }
                catch (ValidatorException ve) {
                    FacesMessage message;
                    this.setValid(false);
                    String validatorMessageString = this.getValidatorMessage();
                    if (null != validatorMessageString) {
                        message = new FacesMessage(FacesMessage.SEVERITY_ERROR, validatorMessageString, validatorMessageString);
                        message.setSeverity(FacesMessage.SEVERITY_ERROR);
                    } else {
                        Collection<FacesMessage> messages = ve.getFacesMessages();
                        if (null != messages) {
                            message = null;
                            String cid = this.getClientId(context);
                            for (FacesMessage m : messages) {
                                context.addMessage(cid, m);
                            }
                        } else {
                            message = ve.getFacesMessage();
                        }
                    }
                    if (message == null) continue;
                    context.addMessage(this.getClientId(context), message);
                }
            }
        }
    }

    protected boolean compareValues(Object previous, Object value) {
        boolean result = true;
        if (previous == null) {
            result = value != null;
        } else if (value == null) {
            result = true;
        } else {
            boolean previousEqualsValue = previous.equals(value);
            if (!previousEqualsValue && previous instanceof Comparable && value instanceof Comparable) {
                try {
                    result = 0 != ((Comparable)previous).compareTo(value);
                }
                catch (ClassCastException cce) {
                    result = true;
                }
            } else {
                result = !previousEqualsValue;
            }
        }
        return result;
    }

    private void executeValidate(FacesContext context) {
        try {
            this.validate(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        if (!this.isValid()) {
            context.validationFailed();
            context.renderResponse();
        }
    }

    public static boolean isEmpty(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String && ((String)value).length() < 1) {
            return true;
        }
        return value.getClass().isArray() ? 0 == Array.getLength(value) : (value instanceof List ? ((List)value).isEmpty() : (value instanceof Collection ? ((Collection)value).isEmpty() : value instanceof Map && ((Map)value).isEmpty()));
    }

    @Override
    public void addValidator(Validator validator) {
        if (validator == null) {
            throw new NullPointerException();
        }
        if (this.validators == null) {
            this.validators = new AttachedObjectListHolder();
        }
        this.validators.add(validator);
    }

    @Override
    public Validator[] getValidators() {
        return this.validators != null ? this.validators.asArray(Validator.class) : EMPTY_VALIDATOR;
    }

    @Override
    public void removeValidator(Validator validator) {
        if (validator == null) {
            return;
        }
        if (this.validators != null) {
            this.validators.remove(validator);
        }
    }

    @Override
    public void addValueChangeListener(ValueChangeListener listener) {
        this.addFacesListener(listener);
    }

    @Override
    public ValueChangeListener[] getValueChangeListeners() {
        return (ValueChangeListener[])this.getFacesListeners(ValueChangeListener.class);
    }

    @Override
    public void removeValueChangeListener(ValueChangeListener listener) {
        this.removeFacesListener(listener);
    }

    @Override
    public Object saveState(FacesContext context) {
        Object validatorsState;
        if (context == null) {
            throw new NullPointerException();
        }
        Object[] result = null;
        Object superState = super.saveState(context);
        Object object = validatorsState = this.validators != null ? this.validators.saveState(context) : null;
        if (superState != null || validatorsState != null) {
            result = new Object[]{superState, validatorsState};
        }
        return result;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (state == null) {
            return;
        }
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        if (values[1] != null) {
            if (this.validators == null) {
                this.validators = new AttachedObjectListHolder();
            }
            this.validators.restoreState(context, values[1]);
        }
    }

    private Converter getConverterWithType(FacesContext context) {
        Class<?> converterType;
        Converter converter = this.getConverter();
        if (converter != null) {
            return converter;
        }
        ValueExpression valueExpression = this.getValueExpression("value");
        if (valueExpression == null) {
            return null;
        }
        try {
            converterType = valueExpression.getType(context.getELContext());
        }
        catch (ELException e) {
            throw new FacesException(e);
        }
        if (converterType == null || converterType == String.class || converterType == Object.class) {
            return null;
        }
        try {
            Application application = context.getApplication();
            return application.createConverter(converterType);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void addConversionErrorMessage(FacesContext context, ConverterException ce) {
        FacesMessage message;
        String converterMessageString = this.getConverterMessage();
        if (null != converterMessageString) {
            message = new FacesMessage(FacesMessage.SEVERITY_ERROR, converterMessageString, converterMessageString);
        } else {
            message = ce.getFacesMessage();
            if (message == null && (message = MessageFactory.getMessage(context, CONVERSION_MESSAGE_ID, new Object[0])).getDetail() == null) {
                message.setDetail(ce.getMessage());
            }
        }
        context.addMessage(this.getClientId(context), message);
    }

    private boolean considerEmptyStringNull(FacesContext ctx) {
        if (this.emptyStringIsNull == null) {
            String val = ctx.getExternalContext().getInitParameter(EMPTY_STRING_AS_NULL_PARAM_NAME);
            this.emptyStringIsNull = Boolean.valueOf(val);
        }
        return this.emptyStringIsNull;
    }

    private boolean validateEmptyFields(FacesContext ctx) {
        if (this.validateEmptyFields == null) {
            ExternalContext extCtx = ctx.getExternalContext();
            String val = extCtx.getInitParameter(VALIDATE_EMPTY_FIELDS_PARAM_NAME);
            if (null == val) {
                val = (String)extCtx.getApplicationMap().get(VALIDATE_EMPTY_FIELDS_PARAM_NAME);
            }
            this.validateEmptyFields = val == null || "auto".equals(val) ? Boolean.valueOf(this.isBeansValidationAvailable(ctx)) : Boolean.valueOf(val);
        }
        return this.validateEmptyFields;
    }

    private boolean isBeansValidationAvailable(FacesContext context) {
        boolean result = false;
        Map<String, Object> appMap = context.getExternalContext().getApplicationMap();
        if (appMap.containsKey(BEANS_VALIDATION_AVAILABLE)) {
            result = (Boolean)appMap.get(BEANS_VALIDATION_AVAILABLE);
        } else {
            try {
                new BeanValidator();
                result = true;
                appMap.put(BEANS_VALIDATION_AVAILABLE, true);
            }
            catch (Throwable t) {
                appMap.put(BEANS_VALIDATION_AVAILABLE, Boolean.FALSE);
            }
        }
        return result;
    }

    static enum PropertyKeys {
        localValueSet,
        required,
        requiredMessage,
        converterMessage,
        validatorMessage,
        valid,
        immediate;

    }
}

