/*
 * Decompiled with CFR 0.152.
 */
package tck.arquillian.protocol.appclient;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.jboss.arquillian.container.spi.context.annotation.DeploymentScoped;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import tck.arquillian.protocol.appclient.AppClientProtocolConfiguration;

public class AppClientCmd {
    private static final Logger LOGGER = Logger.getLogger(AppClientCmd.class.getName());
    private static final String outThreadHame = "APPCLIENT-out";
    private static final String errThreadHame = "APPCLIENT-err";
    private Process appClientProcess;
    private BufferedReader outputReader;
    private BufferedReader errorReader;
    private BlockingQueue<String> outputQueue = new LinkedBlockingQueue<String>();
    private String[] clientCmdLine = new String[0];
    private String[] clientEnvp = null;
    private File clientDir = null;
    private String clientEarDir;
    private String clientEarLibClasspath;
    private CompletableFuture<Process> onExit;
    @Inject
    @DeploymentScoped
    private Instance<AppClientProtocolConfiguration> packagerConfigInstance;

    public void init() {
        AppClientProtocolConfiguration config = (AppClientProtocolConfiguration)this.packagerConfigInstance.get();
        this.clientCmdLine = config.clientCmdLineAsArray();
        this.clientEnvp = config.clientEnvAsArray();
        this.clientDir = config.clientDirAsFile();
        this.clientEarDir = config.getClientEarDir();
        this.clientEarLibClasspath = config.clientEarLibClasspath();
    }

    public AppClientProtocolConfiguration getConfig() {
        return (AppClientProtocolConfiguration)this.packagerConfigInstance.get();
    }

    public boolean waitForExit(long timeout, TimeUnit units) throws InterruptedException {
        return this.appClientProcess.waitFor(timeout, units);
    }

    public String[] readAll(long timeout) {
        ArrayList<String> lines = new ArrayList<String>();
        String line = null;
        do {
            try {
                line = this.outputQueue.poll(100L, TimeUnit.MILLISECONDS);
                if (line == null) continue;
                lines.add(line);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!this.onExit.isDone());
        return lines.toArray(new String[0]);
    }

    public synchronized void quit() throws Exception {
        this.appClientProcess.destroy();
        try {
            this.appClientProcess.waitFor();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void run(AppClientInfo appClientInfo, String ... additionalArgs) throws Exception {
        int n;
        File earDir;
        ArrayList<String> cmdList = new ArrayList<String>();
        String clientAppArchiveName = appClientInfo.clientAppArchive;
        if (clientAppArchiveName.endsWith(".jar")) {
            clientAppArchiveName = clientAppArchiveName.substring(0, clientAppArchiveName.length() - 4);
        }
        if ((earDir = new File(this.clientEarDir)).isAbsolute()) {
            earDir = new File(this.clientDir, this.clientEarDir);
        }
        String[] cmdLine = Arrays.copyOf(this.clientCmdLine, this.clientCmdLine.length);
        for (n = 0; n < cmdLine.length; ++n) {
            String arg = cmdLine[n];
            if (arg.contains("${deploymentName}")) {
                cmdLine[n] = arg = arg.replaceAll("\\$\\{deploymentName}", appClientInfo.deploymentName);
            }
            if (arg.contains("${clientEarDir}")) {
                cmdLine[n] = arg = arg.replaceAll("\\$\\{clientEarDir}", earDir.getAbsolutePath());
            }
            if (arg.contains("${vehicleArchiveName}")) {
                cmdLine[n] = arg = arg.replaceAll("\\$\\{vehicleArchiveName}", appClientInfo.vehicleArchiveName);
            }
            if (arg.contains("${clientAppArchive}")) {
                cmdLine[n] = arg = arg.replaceAll("\\$\\{clientAppArchive}", appClientInfo.clientAppArchive);
            }
            if (arg.contains("${clientAppArchiveName}")) {
                cmdLine[n] = arg = arg.replaceAll("\\$\\{clientAppArchiveName}", clientAppArchiveName);
            }
            if (arg.contains("${clientEarLibClasspath}")) {
                cmdLine[n] = arg = arg.replaceAll("\\$\\{clientEarLibClasspath}", this.clientEarLibClasspath);
            }
            if (!arg.contains("${clientStubJar}")) continue;
            cmdLine[n] = arg = arg.replaceAll("\\$\\{clientStubJar}", appClientInfo.clientStubJar);
        }
        for (n = 0; n < this.clientEnvp.length; ++n) {
            String env = this.clientEnvp[n];
            if (!env.contains("${clientEarLibClasspath}")) continue;
            String env2 = env.replaceAll("\\$\\{clientEarLibClasspath}", this.clientEarLibClasspath);
            LOGGER.info("Replaced clientEarLibClasspath in " + env2);
            this.clientEnvp[n] = env2;
        }
        for (n = 0; n < cmdLine.length; ++n) {
            cmdList.addAll(Arrays.asList(cmdLine[n].split(" ")));
        }
        if (additionalArgs != null) {
            String[] newCmdLine = new String[cmdLine.length + additionalArgs.length];
            System.arraycopy(cmdLine, 0, newCmdLine, 0, cmdLine.length);
            System.arraycopy(additionalArgs, 0, newCmdLine, cmdLine.length, additionalArgs.length);
            cmdList.addAll(Arrays.asList(additionalArgs));
        }
        this.appClientProcess = Runtime.getRuntime().exec(cmdList.toArray(new String[0]), this.clientEnvp, this.clientDir);
        this.onExit = this.appClientProcess.onExit();
        LOGGER.info("Created process" + String.valueOf(this.appClientProcess.info()));
        LOGGER.info("process(%d).envp: %s".formatted(this.appClientProcess.pid(), Arrays.toString(this.clientEnvp)));
        this.outputReader = new BufferedReader(new InputStreamReader(this.appClientProcess.getInputStream(), StandardCharsets.UTF_8));
        this.errorReader = new BufferedReader(new InputStreamReader(this.appClientProcess.getErrorStream(), StandardCharsets.UTF_8));
        Thread readOutputThread = new Thread(this::readClientOut, outThreadHame);
        readOutputThread.start();
        Thread readErrorThread = new Thread(this::readClientErr, errThreadHame);
        readErrorThread.start();
        LOGGER.info("Started process reader threads");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readClientOut() {
        if (this.outputReader == null) {
            return;
        }
        this.readClientProcess(this.outputReader, false);
        AppClientCmd appClientCmd = this;
        synchronized (appClientCmd) {
            this.outputReader = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readClientErr() {
        if (this.errorReader == null) {
            return;
        }
        this.readClientProcess(this.errorReader, true);
        AppClientCmd appClientCmd = this;
        synchronized (appClientCmd) {
            this.errorReader = null;
        }
    }

    private void readClientProcess(BufferedReader reader, boolean errReader) {
        LOGGER.info("Begin readClientProcess");
        int count = 0;
        try {
            String line = reader.readLine();
            while (line != null) {
                ++count;
                if (errReader) {
                    this.errorLineReceived(line);
                } else {
                    this.outputLineReceived(line);
                }
                line = reader.readLine();
            }
        }
        catch (Throwable e) {
            LOGGER.warning(AppClientCmd.formatException("error during read, caused by:\n", e));
        }
        LOGGER.info(String.format("Exiting(%s), read %d lines", errReader, count));
    }

    private synchronized void outputLineReceived(String line) {
        LOGGER.info("[APPCLIENT-out] " + line);
        this.outputQueue.add(line);
    }

    private synchronized void errorLineReceived(String line) {
        LOGGER.info("[APPCLIENT-err] " + line);
        this.outputQueue.add(line);
    }

    private static String formatException(String msg, Throwable e) {
        StringWriter sw = new StringWriter();
        sw.append(msg);
        e.printStackTrace(new PrintWriter((Writer)sw, true));
        return sw.toString();
    }

    record AppClientInfo(String deploymentName, String vehicleArchiveName, String clientAppArchive, String clientStubJar) {
    }
}

