/*
 * Decompiled with CFR 0.152.
 */
package tck.arquillian.protocol.appclient;

import com.sun.ts.tests.common.vehicle.VehicleType;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.util.logging.Logger;
import org.jboss.arquillian.container.spi.client.deployment.Deployment;
import org.jboss.arquillian.container.spi.context.annotation.DeploymentScoped;
import org.jboss.arquillian.container.test.spi.ContainerMethodExecutor;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.spi.TestMethodExecutor;
import org.jboss.arquillian.test.spi.TestResult;
import tck.arquillian.protocol.appclient.AppClientArchiveName;
import tck.arquillian.protocol.appclient.AppClientCmd;
import tck.arquillian.protocol.appclient.AppClientProtocolConfiguration;
import tck.arquillian.protocol.appclient.DeploymentMonitor;
import tck.arquillian.protocol.common.ProtocolCommonConfig;
import tck.arquillian.protocol.common.TargetVehicle;
import tck.arquillian.protocol.common.TsTestPropsBuilder;

public class AppClientMethodExecutor
implements ContainerMethodExecutor {
    static Logger log = Logger.getLogger(AppClientMethodExecutor.class.getName());
    private AppClientCmd appClient;
    private AppClientProtocolConfiguration config;
    @Inject
    @DeploymentScoped
    Instance<Deployment> deploymentInstance;
    @Inject
    @DeploymentScoped
    Instance<DeploymentMonitor> deploymentMonitorInstance;

    public AppClientMethodExecutor(AppClientCmd appClient, AppClientProtocolConfiguration config) {
        this.appClient = appClient;
        this.config = config;
    }

    /*
     * WARNING - void declaration
     */
    public TestResult invoke(TestMethodExecutor testMethodExecutor) {
        TestResult result = TestResult.passed();
        TargetVehicle testVehicle = testMethodExecutor.getMethod().getAnnotation(TargetVehicle.class);
        if (this.config == null) {
            result = TestResult.failed((Throwable)new IllegalStateException("AppClientMethodExecutor: no config obtained from packagerConfigInstance"));
            return result;
        }
        AppClientArchiveName appClientArchiveName = this.config.getAppClientArchiveName();
        String testMethod = testMethodExecutor.getMethodName();
        if (this.config.isRunClient()) {
            DeploymentMonitor deploymentMonitor = (DeploymentMonitor)this.deploymentMonitorInstance.get();
            log.info("Running appClient for: %s, monitor: %s".formatted(testMethod, deploymentMonitor));
            try {
                void var11_15;
                Deployment deployment = (Deployment)this.deploymentInstance.get();
                String appArchiveName = appClientArchiveName.name();
                String vehicleArchiveName = this.determineVehicleArchiveName(testVehicle);
                String deploymentName = this.config.getDeploymentName();
                Object var11_13 = null;
                if (this.config.needsStubs() && deploymentMonitor.needsStubs()) {
                    log.info("Getting deployment stubs for: " + appArchiveName);
                    String string = this.getDeploymentStubs();
                } else {
                    log.info("No stubs needed");
                }
                String[] additionalAgrs = TsTestPropsBuilder.runArgs((ProtocolCommonConfig)this.config, (Deployment)deployment, (TestMethodExecutor)testMethodExecutor);
                AppClientCmd.AppClientInfo appClientInfo = new AppClientCmd.AppClientInfo(deploymentName, vehicleArchiveName, appArchiveName, (String)var11_15);
                this.appClient.run(appClientInfo, additionalAgrs);
            }
            catch (Exception ex) {
                result = TestResult.failed((Throwable)ex);
                return result;
            }
        } else {
            log.info("Not running appClient for: " + testMethod);
        }
        String[] lines = this.appClient.readAll(this.config.getClientTimeout());
        log.info(String.format("AppClient(%s) readAll returned %d lines\n", testMethod, lines.length));
        boolean sawStatus = false;
        MainStatus status = MainStatus.NOT_RUN;
        String reason = "None";
        String description = "None";
        for (String line : lines) {
            System.out.println(line);
            if (!line.contains("STATUS:")) continue;
            sawStatus = true;
            description = line;
            status = MainStatus.parseStatus(line);
            int reasonStart = line.indexOf(46);
            if (reasonStart <= 0 || reasonStart >= line.length() - 1) continue;
            reason = line.substring(reasonStart + 1);
        }
        if (!sawStatus) {
            IllegalStateException illegalStateException = new IllegalStateException("No STATUS: output seen from client");
            result = TestResult.failed((Throwable)illegalStateException);
        } else {
            switch (status) {
                case PASSED: {
                    result = TestResult.passed((String)reason);
                    break;
                }
                case ERROR: 
                case FAILED: {
                    result = TestResult.failed((Throwable)new Exception(reason));
                    break;
                }
                case NOT_RUN: {
                    result = TestResult.skipped((String)reason);
                }
            }
            result.addDescription(description);
        }
        return result;
    }

    private String getDeploymentStubs() throws Exception {
        String deploymentName = this.config.getDeploymentName();
        log.info("Getting deployment stubs, deployment: " + deploymentName);
        CharSequence[] cmdLine = this.config.clientStubsCmdLineAsArray();
        String[] clientEnvp = new String[]{};
        for (int n = 0; n < cmdLine.length; ++n) {
            String arg = cmdLine[n];
            if (!arg.contains("${deploymentName}")) continue;
            arg = arg.replaceAll("\\$\\{deploymentName}", deploymentName);
            cmdLine[n] = arg;
        }
        log.info("Running: " + String.join((CharSequence)" ", cmdLine));
        Process stubsProcess = Runtime.getRuntime().exec((String[])cmdLine, clientEnvp, null);
        int exit = stubsProcess.waitFor();
        log.info("Stubs process exited with: " + exit);
        if (exit != 0) {
            throw new RuntimeException("Stubs process failed with exit code: " + exit);
        }
        String stubsJarName = "%s%s.jar".formatted(deploymentName, this.config.getClientStubsJarSuffix());
        Path stubsJarPath = Path.of("target", stubsJarName);
        File stubsJarFile = stubsJarPath.toFile();
        if (!stubsJarFile.exists()) {
            String msg = "Expected stubs target/${deploymentName=%s}${clientStubsJarSuffix=%s}.jar not found: %s".formatted(deploymentName, this.config.getClientStubsJarSuffix(), stubsJarFile.getAbsolutePath());
            throw new FileNotFoundException(msg);
        }
        return stubsJarFile.getAbsolutePath();
    }

    private String determineVehicleArchiveName(TargetVehicle targetVehicle) {
        Object vehicleArchiveName = this.config.getVehicleArchiveName();
        if ((((String)vehicleArchiveName).isEmpty() || ((String)vehicleArchiveName).equals("none")) && targetVehicle != null) {
            String vehicle = targetVehicle.value();
            VehicleType vehicleType = VehicleType.valueOf((String)vehicle);
            switch (vehicleType) {
                case appmanaged: 
                case appmanagedNoTx: 
                case stateful3: 
                case stateless3: {
                    vehicleArchiveName = vehicleType.name() + "_vehicle_web";
                    break;
                }
                default: {
                    vehicleArchiveName = vehicleType.name() + "_vehicle";
                }
            }
        }
        return vehicleArchiveName;
    }

    static enum MainStatus {
        PASSED,
        FAILED,
        ERROR,
        NOT_RUN;


        static MainStatus parseStatus(String reason) {
            MainStatus status = FAILED;
            if (reason.contains("Passed.")) {
                status = PASSED;
            } else if (reason.contains("Error.")) {
                status = ERROR;
            } else if (reason.contains("Not run.")) {
                status = NOT_RUN;
            }
            return status;
        }
    }
}

