/*
 * Decompiled with CFR 0.152.
 */
package tck.arquillian.protocol.appclient;

import java.util.logging.Logger;

public class DeploymentMonitor {
    Logger log = Logger.getLogger(DeploymentMonitor.class.getName());
    private String name;
    private Status status = Status.DEPLOYED;

    public DeploymentMonitor(String name) {
        this.name = name;
        this.log.info(name + ", deployed");
        this.status = Status.NEEDS_STUBS;
    }

    public boolean needsStubs() {
        return this.status == Status.NEEDS_STUBS;
    }

    public void haveStubJar(String name) {
        this.log.info(name + ", haveStubJar: " + name);
        this.status = Status.HAS_STUBS;
    }

    public void undeploy() {
        this.log.info(this.name + ", undeployed");
        this.status = Status.UNDEPLOYED;
    }

    public void dispose() {
        this.log.info(this.name + ", disposed");
        this.status = Status.DISPOSED;
    }

    public String toString() {
        return "DeploymentMonitor{name='" + this.name + "', status=" + String.valueOf((Object)this.status) + "}";
    }

    public static enum Status {
        DEPLOYED,
        NEEDS_STUBS,
        HAS_STUBS,
        FAILED,
        UNDEPLOYED,
        DISPOSED;

    }
}

