/*
 * Decompiled with CFR 0.152.
 */
package tck.arquillian.protocol.appclient;

import java.lang.annotation.Annotation;
import java.util.logging.Logger;
import org.jboss.arquillian.container.spi.event.DeploymentEvent;
import org.jboss.arquillian.container.spi.event.UnDeployDeployment;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.test.spi.enricher.resource.ResourceProvider;
import tck.arquillian.protocol.appclient.DeploymentMonitor;

public class DeploymentMonitorProvider
implements ResourceProvider {
    Logger log = Logger.getLogger(DeploymentMonitor.class.getName());
    @Inject
    @ApplicationScoped
    InstanceProducer<DeploymentMonitor> monitor;
    private DeploymentMonitor activeDeploymentMonitor;

    public void onDeployment(@Observes DeploymentEvent event) {
        this.log.info("Deployment event observed: %s, currentMonitor: %s".formatted(event.getDeployment(), this.activeDeploymentMonitor));
        if (this.activeDeploymentMonitor != null) {
            this.activeDeploymentMonitor.dispose();
        }
        this.activeDeploymentMonitor = new DeploymentMonitor(event.getDeployment().getDescription().getName());
        this.monitor.set((Object)this.activeDeploymentMonitor);
    }

    public void onUndeployment(@Observes UnDeployDeployment event) {
        this.log.info("Undeployment event observed: %s, currentMonitor: %s".formatted(event.getDeployment(), this.activeDeploymentMonitor));
        if (this.activeDeploymentMonitor != null) {
            this.activeDeploymentMonitor.undeploy();
        }
    }

    public Object lookup(ArquillianResource resource, Annotation ... qualifiers) {
        return this.monitor.get();
    }

    public boolean canProvide(Class<?> type) {
        return type.isAssignableFrom(DeploymentMonitor.class);
    }
}

