/*
 * Decompiled with CFR 0.152.
 */
package tck.arquillian.protocol.appclient;

import com.sun.ts.tests.common.vehicle.VehicleType;
import com.sun.ts.tests.common.vehicle.appmanaged.AppManagedServletVehicle;
import com.sun.ts.tests.common.vehicle.appmanagedNoTx.AppManagedNoTxServletVehicle;
import com.sun.ts.tests.common.vehicle.servlet.ServletVehicle;
import com.sun.ts.tests.common.vehicle.stateful3.Stateful3ServletVehicle;
import com.sun.ts.tests.common.vehicle.stateless3.Stateless3ServletVehicle;
import com.sun.ts.tests.common.vehicle.web.AltWebVehicleRunner;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;
import org.jboss.arquillian.container.test.spi.TestDeployment;
import org.jboss.arquillian.container.test.spi.client.deployment.DeploymentPackager;
import org.jboss.arquillian.container.test.spi.client.deployment.ProtocolArchiveProcessor;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.ArchiveAsset;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.FileAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import tck.arquillian.protocol.appclient.AppClientArchiveName;
import tck.arquillian.protocol.appclient.AppClientProtocolConfiguration;
import tck.arquillian.protocol.common.ProtocolJarResolver;

public class AppClientDeploymentPackager
implements DeploymentPackager {
    static Logger log = Logger.getLogger(AppClientDeploymentPackager.class.getName());
    @Inject
    @ApplicationScoped
    private InstanceProducer<AppClientArchiveName> appClientArchiveName;

    public Archive<?> generateDeployment(TestDeployment testDeployment, Collection<ProtocolArchiveProcessor> processors) {
        File appclient;
        Archive archive = testDeployment.getApplicationArchive();
        String deploymentName = testDeployment.getDeploymentName();
        log.info("Generating deployment for: " + deploymentName);
        Collection auxiliaryArchives = testDeployment.getAuxiliaryArchives();
        EnterpriseArchive ear = (EnterpriseArchive)archive;
        ear.addAsLibraries(auxiliaryArchives.toArray(new Archive[0]));
        File protocolJar = ProtocolJarResolver.resolveProtocolJar();
        if (protocolJar == null) {
            String msg = "Failed to resolve protocol.jar. You either need a jakarta.tck.arquillian:arquillian-protocol-lib dependency in the runner pom.xml or a downloaded target/protocol/protocol.jar file.\n The runner pom needs to be pom.xml or the path needs to be set by the system property tck.arquillian.protocol.runnerPom";
            throw new RuntimeException(msg);
        }
        ear.addAsLibrary(protocolJar, "arquillian-protocol-lib.jar");
        VehicleType vehicleType = this.getVehicleType(deploymentName);
        if (vehicleType != VehicleType.none) {
            this.addJPAServletVehicle(ear, vehicleType);
        }
        AppClientProtocolConfiguration config = (AppClientProtocolConfiguration)testDeployment.getProtocolConfiguration();
        String mainClass = this.determineAppMainJar(ear);
        log.info("mainClass: " + mainClass);
        String extractDir = config.getClientEarDir();
        if (extractDir == null) {
            extractDir = "target/appclient";
        }
        if (!(appclient = new File(extractDir)).exists()) {
            if (appclient.mkdirs()) {
                log.info("Created appclient directory: " + appclient.getAbsolutePath());
            } else {
                throw new RuntimeException("Failed to create appclient directory: " + appclient.getAbsolutePath());
            }
        }
        File archiveOnDisk = new File(appclient, ear.getName());
        ZipExporter exporter = (ZipExporter)ear.as(ZipExporter.class);
        exporter.exportTo(archiveOnDisk, true);
        log.info("Exported test ear to: " + archiveOnDisk.getAbsolutePath());
        if (config.isUnpackClientEar()) {
            this.unpackClientEar(ear, appclient);
        }
        return ear;
    }

    private VehicleType getVehicleType(String deploymentName) {
        VehicleType vehicleType = VehicleType.none;
        if (deploymentName.contains("appmanagedNoTx_vehicle")) {
            vehicleType = VehicleType.appmanagedNoTx;
        } else if (deploymentName.contains("appmanaged_vehicle")) {
            vehicleType = VehicleType.appmanaged;
        } else if (deploymentName.contains("stateful3_vehicle")) {
            vehicleType = VehicleType.stateful3;
        } else if (deploymentName.contains("stateless3_vehicle")) {
            vehicleType = VehicleType.stateless3;
        }
        return vehicleType;
    }

    private void addJPAServletVehicle(EnterpriseArchive ear, VehicleType vehicleType) {
        String deploymentName = ear.getName();
        String webArchiveName = vehicleType.name() + "_vehicle_web";
        WebArchive war = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)(webArchiveName + ".war"));
        war.addClass(ServletVehicle.class);
        war.addClass(AltWebVehicleRunner.class);
        switch (vehicleType) {
            case appmanagedNoTx: {
                war.addClass(AppManagedNoTxServletVehicle.class);
                break;
            }
            case appmanaged: {
                war.addClass(AppManagedServletVehicle.class);
                war.addAsWebInfResource((Asset)new StringAsset(""), "beans.xml");
                break;
            }
            case stateful3: {
                war.addClass(Stateful3ServletVehicle.class);
                war.addAsWebInfResource((Asset)new StringAsset(""), "beans.xml");
                break;
            }
            case stateless3: {
                war.addClass(Stateless3ServletVehicle.class);
            }
        }
        ear.addAsModule((Archive)war);
        System.setProperty("vehicle_archive_name_override", webArchiveName);
        log.info(String.format("Added %s.war to: %s", webArchiveName, deploymentName));
    }

    private void unpackClientEar(EnterpriseArchive ear, File clientEarDir) {
        for (ArchivePath path : ear.getContent().keySet()) {
            Object archiveFile;
            Node node = ear.get(path);
            Asset asset = node.getAsset();
            if (asset instanceof ArchiveAsset) {
                ArchiveAsset asset2 = (ArchiveAsset)asset;
                archiveFile = new File(clientEarDir, path.get());
                if (!((File)archiveFile).getParentFile().exists()) {
                    ((File)archiveFile).getParentFile().mkdirs();
                }
                ZipExporter zipExporter = (ZipExporter)asset2.getArchive().as(ZipExporter.class);
                zipExporter.exportTo((File)archiveFile, true);
                log.info("Exported test ear content to: " + ((File)archiveFile).getAbsolutePath());
                continue;
            }
            archiveFile = node.getAsset();
            if (!(archiveFile instanceof FileAsset)) continue;
            FileAsset asset3 = (FileAsset)archiveFile;
            File file = new File(clientEarDir, path.get());
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            try {
                Files.copy(asset3.openStream(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                log.info("Exported test ear content to: " + file.getAbsolutePath());
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to export test ear content to: " + file.getAbsolutePath(), e);
            }
        }
    }

    private String determineAppMainJar(EnterpriseArchive ear) {
        String mainClass = null;
        Map contents = ear.getContent();
        block0: for (Node node : contents.values()) {
            String[] lines;
            ArchiveAsset jar;
            Node mfNode;
            Asset asset = node.getAsset();
            if (!(asset instanceof ArchiveAsset) || (mfNode = (jar = (ArchiveAsset)asset).getArchive().get("META-INF/MANIFEST.MF")) == null) continue;
            StringAsset manifest = (StringAsset)mfNode.getAsset();
            String source = manifest.getSource();
            for (String line : lines = source.split("\n")) {
                if (!line.startsWith("Main-Class:")) continue;
                mainClass = line.substring(11).trim();
                this.appClientArchiveName.set((Object)new AppClientArchiveName(jar.getArchive().getName()));
                continue block0;
            }
        }
        return mainClass;
    }
}

