/*
 * Decompiled with CFR 0.152.
 */
package tck.arquillian.protocol.appclient;

import java.util.logging.Logger;
import org.jboss.arquillian.container.spi.client.deployment.Deployment;
import org.jboss.arquillian.container.spi.context.annotation.DeploymentScoped;
import org.jboss.arquillian.container.test.spi.ContainerMethodExecutor;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.spi.TestMethodExecutor;
import org.jboss.arquillian.test.spi.TestResult;
import tck.arquillian.protocol.appclient.AppClientArchiveName;
import tck.arquillian.protocol.appclient.AppClientCmd;
import tck.arquillian.protocol.appclient.AppClientProtocolConfiguration;
import tck.arquillian.protocol.common.ProtocolCommonConfig;
import tck.arquillian.protocol.common.TsTestPropsBuilder;

public class AppClientMethodExecutor
implements ContainerMethodExecutor {
    static Logger log = Logger.getLogger(AppClientMethodExecutor.class.getName());
    private AppClientCmd appClient;
    private AppClientProtocolConfiguration config;
    @Inject
    @DeploymentScoped
    private Instance<Deployment> deploymentInstance;
    @Inject
    @DeploymentScoped
    private Instance<AppClientArchiveName> appClientArchiveName;

    public AppClientMethodExecutor(AppClientCmd appClient, AppClientProtocolConfiguration config) {
        this.appClient = appClient;
        this.config = config;
    }

    public TestResult invoke(TestMethodExecutor testMethodExecutor) {
        TestResult result = TestResult.passed();
        String testMethod = testMethodExecutor.getMethodName();
        if (this.config.isRunClient()) {
            log.info("Running appClient for: " + testMethod);
            try {
                Deployment deployment = (Deployment)this.deploymentInstance.get();
                String appArchiveName = ((AppClientArchiveName)this.appClientArchiveName.get()).name();
                String vehicleArchiveName = TsTestPropsBuilder.vehicleArchiveName((Deployment)deployment);
                String[] additionalAgrs = TsTestPropsBuilder.runArgs((ProtocolCommonConfig)this.config, (Deployment)deployment, (TestMethodExecutor)testMethodExecutor);
                this.appClient.run(vehicleArchiveName, appArchiveName, additionalAgrs);
            }
            catch (Exception ex) {
                result = TestResult.failed((Throwable)ex);
                return result;
            }
        } else {
            log.info("Not running appClient for: " + testMethod);
        }
        String[] lines = this.appClient.readAll(this.config.getClientTimeout());
        log.info(String.format("AppClient(%s) readAll returned %d lines\n", testMethod, lines.length));
        boolean sawStatus = false;
        MainStatus status = MainStatus.NOT_RUN;
        String reason = "None";
        String description = "None";
        for (String line : lines) {
            System.out.println(line);
            if (!line.contains("STATUS:")) continue;
            sawStatus = true;
            description = line;
            status = MainStatus.parseStatus(line);
            int reasonStart = line.indexOf(46);
            if (reasonStart <= 0 || reasonStart >= line.length() - 1) continue;
            reason = line.substring(reasonStart + 1);
        }
        if (!sawStatus) {
            IllegalStateException ex = new IllegalStateException("No STATUS: output seen from client");
            result = TestResult.failed((Throwable)ex);
        } else {
            switch (status) {
                case PASSED: {
                    result = TestResult.passed((String)reason);
                    break;
                }
                case ERROR: 
                case FAILED: {
                    result = TestResult.failed((Throwable)new Exception(reason));
                    break;
                }
                case NOT_RUN: {
                    result = TestResult.skipped((String)reason);
                }
            }
            result.addDescription(description);
        }
        return result;
    }

    static enum MainStatus {
        PASSED,
        FAILED,
        ERROR,
        NOT_RUN;


        static MainStatus parseStatus(String reason) {
            MainStatus status = FAILED;
            if (reason.contains("Passed.")) {
                status = PASSED;
            } else if (reason.contains("Error.")) {
                status = ERROR;
            } else if (reason.contains("Not run.")) {
                status = NOT_RUN;
            }
            return status;
        }
    }
}

