/*
 * Decompiled with CFR 0.152.
 */
package tck.arquillian.protocol.appclient;

import java.io.File;
import java.util.ArrayList;
import org.jboss.arquillian.container.test.spi.client.protocol.ProtocolConfiguration;
import tck.arquillian.protocol.common.ProtocolCommonConfig;

public class AppClientProtocolConfiguration
implements ProtocolConfiguration,
ProtocolCommonConfig {
    private boolean runClient = true;
    private boolean runAsVehicle = false;
    private String clientEnvString;
    private String clientCmdLineString;
    private String cmdLineArgSeparator = ";";
    private String clientDir;
    private String clientEarDir = "target/appclient";
    private long clientTimeout = 60000L;
    private String workDir;
    private String tsJteFile;
    private String tsSqlStmtFile;
    private boolean trace;
    private boolean unpackClientEar = false;
    private boolean anySetter;

    public boolean isAppClient() {
        return true;
    }

    public boolean isRunClient() {
        return this.runClient;
    }

    public void setRunClient(boolean runClient) {
        this.runClient = runClient;
        this.anySetter = true;
    }

    public boolean isRunAsVehicle() {
        return this.runAsVehicle;
    }

    public void setRunAsVehicle(boolean runAsVehicle) {
        this.runAsVehicle = runAsVehicle;
        this.anySetter = true;
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
        this.anySetter = true;
    }

    public String getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(String workDir) {
        this.workDir = workDir;
        this.anySetter = true;
    }

    public String getTsJteFile() {
        return this.tsJteFile;
    }

    public void setTsJteFile(String tsJteFile) {
        this.tsJteFile = tsJteFile;
        this.anySetter = true;
    }

    public String getTsSqlStmtFile() {
        return this.tsSqlStmtFile;
    }

    public void setTsSqlStmtFile(String tsSqlStmtFile) {
        this.tsSqlStmtFile = tsSqlStmtFile;
        this.anySetter = true;
    }

    public String getClientEnvString() {
        return this.clientEnvString;
    }

    public void setClientEnvString(String clientEnvString) {
        this.clientEnvString = clientEnvString;
        this.anySetter = true;
    }

    public String getClientCmdLineString() {
        return this.clientCmdLineString;
    }

    public void setClientCmdLineString(String clientCmdLineString) {
        this.clientCmdLineString = clientCmdLineString;
        this.anySetter = true;
    }

    public String getCmdLineArgSeparator() {
        return this.cmdLineArgSeparator;
    }

    public void setCmdLineArgSeparator(String cmdLineArgSeparator) {
        this.cmdLineArgSeparator = cmdLineArgSeparator;
        this.anySetter = true;
    }

    public String getClientDir() {
        return this.clientDir;
    }

    public void setClientDir(String clientDir) {
        this.clientDir = clientDir;
        this.anySetter = true;
    }

    public String getClientEarDir() {
        return this.clientEarDir;
    }

    public void setClientEarDir(String clientEarDir) {
        this.clientEarDir = clientEarDir;
        this.anySetter = true;
    }

    public boolean isUnpackClientEar() {
        return this.unpackClientEar;
    }

    public void setUnpackClientEar(boolean unpackClientEar) {
        this.unpackClientEar = unpackClientEar;
        this.anySetter = true;
    }

    public long getClientTimeout() {
        return this.clientTimeout;
    }

    public void setClientTimeout(long clientTimeout) {
        this.clientTimeout = clientTimeout;
        this.anySetter = true;
    }

    public boolean wasAnySetterCalled() {
        return this.anySetter;
    }

    public File clientDirAsFile() {
        File dir = null;
        if (this.clientDir != null) {
            dir = new File(this.clientDir);
        }
        return dir;
    }

    public String clientEarLibClasspath() {
        StringBuilder cp = new StringBuilder();
        File libDir = new File(this.clientEarDir, "lib");
        if (this.unpackClientEar && libDir.exists()) {
            File[] jars;
            for (File jar : jars = libDir.listFiles()) {
                if (!cp.isEmpty()) {
                    cp.append(File.pathSeparator);
                }
                cp.append(jar.getAbsolutePath());
            }
        }
        return cp.toString();
    }

    public String[] clientCmdLineAsArray() {
        String[] cmdArray = this.clientCmdLineString.trim().split(this.cmdLineArgSeparator);
        for (int i = 0; i < cmdArray.length; ++i) {
            cmdArray[i] = cmdArray[i].trim();
        }
        return cmdArray;
    }

    public String[] clientEnvAsArray() {
        String[] envp = null;
        if (this.clientEnvString != null) {
            ArrayList tmp = new ArrayList();
            envp = this.clientEnvString.trim().split(";");
            for (int i = 0; i < envp.length; ++i) {
                envp[i] = envp[i].trim();
            }
        }
        return envp;
    }
}

