/*
 * Decompiled with CFR 0.152.
 */
package tck.arquillian.protocol.common;

import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import java.util.logging.Logger;
import org.jboss.arquillian.container.spi.client.deployment.Deployment;
import org.jboss.arquillian.test.spi.TestMethodExecutor;
import tck.arquillian.protocol.common.ProtocolCommonConfig;
import tck.arquillian.protocol.common.TargetVehicle;

public class TsTestPropsBuilder {
    static Logger log = Logger.getLogger(TsTestPropsBuilder.class.getName());
    static String[] tsJtePropNames = new String[]{"s1as", "s1as.modules", "Driver", "authpassword", "authuser", "binarySize", "cofSize", "cofTypeSize", "db.dml.file", "db.supports.sequence", "db1", "db2", "DriverManager", "ftable", "generateSQL", "harness.log.port", "harness.log.traceflag", "harness.socket.retry.count", "harness.temp.directory", "imap.port", "iofile", "java.naming.factory.initial", "javamail.mailbox", "javamail.password", "javamail.protocol", "javamail.root.path", "javamail.server", "javamail.username", "jdbc.db", "jms_timeout", "jstl.db.user", "jstl.db.password", "log.file.location", "logical.hostname.servlet", "longvarbinarySize", "mailuser1", "org.omg.CORBA.ORBClass", "password", "password1", "platform.mode", "porting.ts.HttpsURLConnection.class.1", "porting.ts.HttpsURLConnection.class.2", "porting.ts.login.class.1", "porting.ts.login.class.2", "porting.ts.url.class.1", "porting.ts.url.class.2", "porting.ts.jms.class.1", "porting.ts.jms.class.2", "porting.ts.deploy.class.1", "porting.ts.deploy.class.2", "ptable", "rapassword1", "rapassword2", "rauser1", "rauser2", "securedWebServicePort", "sigTestClasspath", "smtp.port", "transport_protocol", "ts_home", "user", "user1", "varbinarySize", "variable.mapper", "vehicle_ear_name", "webServerHost", "webServerPort", "whitebox-anno_no_md", "whitebox-mdcomplete", "whitebox-mixedmode", "whitebox-multianno", "whitebox-notx", "whitebox-notx-param", "whitebox-permissiondd", "whitebox-tx", "whitebox-tx-param", "whitebox-xa", "whitebox-xa-param", "work.dir", "ws_wait"};

    public static String vehicleArchiveName(Deployment deployment) {
        String vehicleArchiveName = deployment.getDescription().getArchive().getName();
        int dot = vehicleArchiveName.lastIndexOf(46);
        if (dot != -1) {
            vehicleArchiveName = vehicleArchiveName.substring(0, dot);
        }
        return vehicleArchiveName;
    }

    public static String[] runArgs(ProtocolCommonConfig config, Deployment deployment, TestMethodExecutor testMethodExecutor) throws IOException {
        String workDir;
        Class<?> testClass = testMethodExecutor.getMethod().getDeclaringClass();
        Class<?> testSuperclass = testClass.getSuperclass();
        TargetVehicle testVehicle = testMethodExecutor.getMethod().getAnnotation(TargetVehicle.class);
        String testMethodName = testMethodExecutor.getMethod().getName();
        String vehicle = "none";
        if (testVehicle != null) {
            vehicle = testVehicle.value();
        }
        log.info(String.format("Base class: %s, vehicle: %s", testSuperclass.getName(), vehicle));
        String vehicleArchiveName = TsTestPropsBuilder.vehicleArchiveName(deployment);
        Path tsJte = Paths.get(config.getTsJteFile(), new String[0]);
        Path tssqlStmt = null;
        if (config.getTsSqlStmtFile() != null) {
            tssqlStmt = Paths.get(config.getTsSqlStmtFile(), new String[0]);
        }
        if ((workDir = config.getWorkDir()) == null) {
            throw new IllegalStateException("Missing workDir value for test properties file");
        }
        Path workDirPath = Paths.get(workDir, new String[0]);
        if (!workDirPath.toFile().exists()) {
            log.info("Creating work directory: " + workDirPath.toAbsolutePath());
            Files.createDirectory(workDirPath, new FileAttribute[0]);
        }
        Path testProps = workDirPath.resolve("tstest.jte");
        Properties tsJteProps = new Properties();
        tsJteProps.load(new FileReader(tsJte.toFile()));
        log.info("Read in ts.jte file: " + tsJte);
        Properties props = new Properties();
        if (vehicle.equals("ejb") && config.isAppClient()) {
            props.setProperty("finder", "jck");
        } else {
            props.setProperty("finder", "cts");
        }
        props.setProperty("service_eetest.vehicles", vehicle);
        props.setProperty("vehicle", vehicle);
        props.setProperty("vehicle_archive_name", vehicleArchiveName);
        props.setProperty("harness.log.delayseconds", "0");
        if (config.isTrace()) {
            props.setProperty("harness.log.traceflag", "true");
        }
        for (String propName : tsJtePropNames) {
            String propValue = tsJteProps.getProperty(propName);
            if (propValue == null) continue;
            if (propValue.startsWith("${") && propValue.endsWith("}")) {
                String refName = propValue.substring(2, propValue.length() - 1);
                if ((propValue = tsJteProps.getProperty(refName)) == null && refName != null) {
                    propValue = System.getProperty(refName);
                }
                log.info(String.format("Setting property %s -> %s to %s", propName, refName, propValue));
            }
            if (propValue == null) {
                propValue = System.getProperty(propName);
            }
            if (propValue == null) continue;
            props.setProperty(propName, propValue);
        }
        if (TsTestPropsBuilder.isAbstract(testSuperclass)) {
            props.setProperty("test_classname", testClass.getName());
        } else {
            props.setProperty("test_classname", testSuperclass.getName());
        }
        try (OutputStream out = Files.newOutputStream(testProps, new OpenOption[0]);){
            props.store(out, "Properties for test: " + testMethodName);
            log.info(props.toString());
        }
        String[] args = new String[]{"-p", testProps.toFile().getAbsolutePath(), "-ap", tssqlStmt != null ? tssqlStmt.toFile().getAbsolutePath() : "/dev/null", "-classname", testMethodExecutor.getMethod().getDeclaringClass().getName(), "-t", testMethodName, "-vehicle", vehicle};
        return args;
    }

    public static boolean isAbstract(Class<?> clazz) {
        int modifiers = clazz.getModifiers();
        return Modifier.isAbstract(modifiers);
    }
}

