/*
 * Decompiled with CFR 0.152.
 */
package tck.arquillian.protocol.common;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolvedArtifact;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.jboss.shrinkwrap.resolver.api.maven.PomEquippedResolveStage;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;

public class ProtocolJarResolver {
    static Logger log = Logger.getLogger(ProtocolJarResolver.class.getName());

    public static File resolveProtocolJar() {
        File protocolJar = null;
        String[] activeMavenProfiles = new String[]{"staging"};
        Object libGAV = "jakarta.tck.arquillian:arquillian-protocol-lib";
        String version = ProtocolJarResolver.versionInfo();
        if (version != null && !version.isEmpty()) {
            libGAV = (String)libGAV + ":" + version;
        }
        MavenResolvedArtifact protocolLib = null;
        try {
            MavenResolvedArtifact[] resolvedArtifacts;
            for (MavenResolvedArtifact resolvedArtifact : resolvedArtifacts = (MavenResolvedArtifact[])((MavenFormatStage)((MavenStrategyStage)((PomEquippedResolveStage)Maven.resolver().loadPomFromFile("pom.xml", activeMavenProfiles)).resolve((String)libGAV)).withTransitivity()).asResolvedArtifact()) {
                MavenCoordinate gav = resolvedArtifact.getCoordinate();
                if (!gav.getGroupId().equals("jakarta.tck.arquillian") || !gav.getArtifactId().equals("arquillian-protocol-lib")) continue;
                protocolLib = resolvedArtifact;
                break;
            }
        }
        catch (Exception e) {
            log.warning("Failed to resolve jakarta.tck.arquillian:arquillian-protocol-lib: " + e.getMessage());
        }
        if (protocolLib != null) {
            protocolJar = protocolLib.asFile();
        } else {
            log.warning("Failed to resolve jakarta.tck.arquillian:arquillian-protocol-lib, check the runner pom.xml dependencies");
            protocolJar = new File("target/protocol/protocol.jar");
            if (!protocolJar.exists()) {
                log.warning("Failed to find downloaded jakarta.tck.arquillian:arquillian-protocol-lib in target/protocol/protocol.jar");
                protocolJar = null;
            }
        }
        return protocolJar;
    }

    public static String versionInfo() {
        URL versionURL = ProtocolJarResolver.class.getResource("/javatest.version");
        String versionInfo = "";
        try {
            assert (versionURL != null);
            try (InputStream is = versionURL.openStream();){
                if (is != null) {
                    byte[] info = is.readAllBytes();
                    versionInfo = new String(info);
                }
            }
        }
        catch (Exception e) {
            log.warning("Failed to read javatest.version: " + e.getMessage());
        }
        return versionInfo;
    }
}

