/*
 * Decompiled with CFR 0.152.
 */
package tck.arquillian.protocol.javatest;

import java.io.File;
import java.util.Collection;
import java.util.logging.Logger;
import org.jboss.arquillian.container.test.spi.TestDeployment;
import org.jboss.arquillian.container.test.spi.client.deployment.DeploymentPackager;
import org.jboss.arquillian.container.test.spi.client.deployment.ProtocolArchiveProcessor;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import tck.arquillian.protocol.common.ProtocolJarResolver;

public class JavaTestDeploymentPackager
implements DeploymentPackager {
    static Logger log = Logger.getLogger(JavaTestDeploymentPackager.class.getName());

    public Archive<?> generateDeployment(TestDeployment testDeployment, Collection<ProtocolArchiveProcessor> processors) {
        Archive archive = testDeployment.getApplicationArchive();
        Collection auxiliaryArchives = testDeployment.getAuxiliaryArchives();
        File protocolJar = ProtocolJarResolver.resolveProtocolJar();
        if (protocolJar == null) {
            String msg = "Failed to resolve protocol.jar. You either need a jakarta.tck.arquillian:arquillian-protocol-lib dependency in the runner pom.xml or a downloaded target/protocol/protocol.jar file.\n The runner pom needs to be pom.xml or the path needs to be set by the system property tck.arquillian.protocol.runnerPom";
            throw new RuntimeException(msg);
        }
        if (archive instanceof EnterpriseArchive) {
            EnterpriseArchive ear = (EnterpriseArchive)archive;
            ear.addAsLibraries(auxiliaryArchives.toArray(new Archive[0]));
            ear.addAsLibraries(new File[]{protocolJar});
        } else if (archive instanceof WebArchive) {
            WebArchive war = (WebArchive)archive;
            war.addAsLibraries(auxiliaryArchives.toArray(new Archive[0]));
            war.addAsLibraries(new File[]{protocolJar});
        }
        return archive;
    }
}

