/*
 * Decompiled with CFR 0.152.
 */
package tck.arquillian.protocol.javatest;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.tests.common.vehicle.VehicleClient;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.logging.Logger;
import org.jboss.arquillian.container.spi.client.deployment.Deployment;
import org.jboss.arquillian.container.spi.context.annotation.DeploymentScoped;
import org.jboss.arquillian.container.test.spi.ContainerMethodExecutor;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.spi.TestMethodExecutor;
import org.jboss.arquillian.test.spi.TestResult;
import tck.arquillian.protocol.common.ProtocolCommonConfig;
import tck.arquillian.protocol.common.TargetVehicle;
import tck.arquillian.protocol.common.TsTestPropsBuilder;
import tck.arquillian.protocol.javatest.JavaTestProtocolConfiguration;

public class JavaTestMethodExecutor
implements ContainerMethodExecutor {
    static Logger log = Logger.getLogger(JavaTestMethodExecutor.class.getName());
    private JavaTestProtocolConfiguration config;
    @Inject
    @DeploymentScoped
    private Instance<Deployment> deploymentInstance;

    public JavaTestMethodExecutor(JavaTestProtocolConfiguration config) {
        this.config = config;
    }

    public TestResult invoke(TestMethodExecutor testMethodExecutor) {
        String[] args;
        log.fine("Executing test method: " + testMethodExecutor.getMethod().getName());
        long start = System.currentTimeMillis();
        Deployment deployment = (Deployment)this.deploymentInstance.get();
        TargetVehicle testVehicle = testMethodExecutor.getMethod().getAnnotation(TargetVehicle.class);
        String vehicle = "none";
        if (testVehicle != null) {
            vehicle = testVehicle.value();
            String vehicleArchiveName = deployment.getDescription().getArchive().getName();
            int dot = vehicleArchiveName.lastIndexOf(46);
            if (dot != -1) {
                vehicleArchiveName = vehicleArchiveName.substring(0, dot);
            }
            this.config.setVehicleArchiveName(vehicleArchiveName);
        }
        try {
            args = TsTestPropsBuilder.runArgs((ProtocolCommonConfig)this.config, (Deployment)deployment, (TestMethodExecutor)testMethodExecutor);
        }
        catch (IOException e) {
            TestResult result = TestResult.failed((Throwable)e);
            result.addDescription("Failed to write test properties");
            return result;
        }
        Status status = !vehicle.equals("none") ? this.runVehicleClient(args) : this.runClient(testMethodExecutor.getInstance(), args);
        TestResult result = switch (status.getType()) {
            case 0 -> TestResult.passed((String)status.getReason());
            case 1 -> TestResult.failed((Throwable)new Exception(status.getReason()));
            case 2 -> TestResult.failed((Throwable)new EETest.Fault(status.getReason()));
            case 3 -> TestResult.skipped((String)status.getReason());
            default -> TestResult.failed((Throwable)new IllegalStateException("Unkown status type: " + status.getType()));
        };
        result.setStart(start);
        result.setEnd(System.currentTimeMillis());
        return result;
    }

    Status runVehicleClient(String[] args) {
        VehicleClient client = new VehicleClient();
        return client.run(args, System.out, System.err);
    }

    Status runClient(Object client, String[] args) {
        try {
            Class<?> baseTestClass = client.getClass();
            MethodHandles.Lookup publicLookup = MethodHandles.publicLookup();
            MethodType methodType = MethodType.methodType(Status.class, String[].class, PrintWriter.class, PrintWriter.class);
            MethodHandle run = publicLookup.findVirtual(baseTestClass, "run", methodType);
            PrintWriter out = new PrintWriter(System.out, true);
            PrintWriter err = new PrintWriter(System.err, true);
            Status status = run.invoke(client, args, out, err);
            return status;
        }
        catch (Throwable e) {
            return new Status(2, "Failed to run test client: " + e.getMessage());
        }
    }
}

