/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.ejb.dba;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.sql.DataSource;

public class DBSupport
implements Serializable {
    protected static final String prefix = "java:comp/env/";
    protected static final String DBLookupName = "java:comp/env/jdbc/DB1";
    protected String tablePrefix = null;
    protected DataSource ds = null;
    protected transient Connection dbConnection = null;
    protected TSNamingContext nctx = null;
    protected int cofID = 0;
    protected String cofName = null;
    protected float cofPrice = 0.0f;

    public DBSupport(String tablePrefix) throws Exception {
        this.tablePrefix = tablePrefix;
        TestUtil.logTrace("[DBSupport] Getting naming context...");
        this.nctx = new TSNamingContext();
        TestUtil.logTrace("[DBSupport] Lookup DataSource java:comp/env/jdbc/DB1");
        this.ds = (DataSource)this.nctx.lookup(DBLookupName);
    }

    public static void initTable(String tablePrefix, Properties props) throws Exception {
        String cleanupPropName = "DEPLOY_" + tablePrefix + "_Cleanup";
        DataSource ds = null;
        Connection conn = null;
        Statement stmt = null;
        TestUtil.logTrace("[DBSupport] initTable()");
        try {
            if (null == tablePrefix) {
                throw new Exception("tablePrefix cannot be null!");
            }
            TestUtil.logTrace("[DBSupport] Getting naming context...");
            TSNamingContext nctx = new TSNamingContext();
            TestUtil.logTrace("[DBSupport] Lookup DataSource java:comp/env/jdbc/DB1");
            ds = (DataSource)nctx.lookup(DBLookupName);
            TestUtil.logTrace("[DBSupport] Getting DB connection...");
            conn = ds.getConnection();
            TestUtil.logTrace("[DBSupport] Cleanup table");
            stmt = conn.createStatement();
            TestUtil.logTrace("[DBSupport] Use SQL prop " + cleanupPropName);
            String sqlStr = TestUtil.getProperty(cleanupPropName);
            TestUtil.logTrace("[DBSupport] SQL = '" + sqlStr + "'");
            stmt.executeUpdate(sqlStr);
            TestUtil.logTrace("[DBSupport] Table cleaned up!");
        }
        catch (SQLException e) {
            TestUtil.logErr("[DBSupport] Cannot init table :" + e);
            throw new SQLException("SQL Exception in initTable: " + e);
        }
        finally {
            try {
                if (null != stmt) {
                    stmt.close();
                }
                if (null != conn) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                TestUtil.logTrace("[DBSupport] Ignoring Exception (cleanup): " + e);
            }
        }
    }

    public void getDBConnection() throws SQLException {
        TestUtil.logTrace("[DBSupport] getDBConnection()");
        if (null == this.dbConnection) {
            this.dbConnection = this.ds.getConnection();
        }
    }

    public void closeDBConnection() throws SQLException {
        TestUtil.logTrace("[DBSupport] closeDBConnection()");
        if (null != this.dbConnection) {
            this.dbConnection.close();
            this.dbConnection = null;
        }
    }

    public PreparedStatement getStmt(String suffix) throws SQLException {
        TestUtil.logTrace("getStmt()");
        this.getDBConnection();
        TestUtil.logMsg("connection = " + this.dbConnection);
        String sqlPropName = "DEPLOY_" + this.tablePrefix + "_" + suffix;
        TestUtil.logTrace("[DBSupport] Get SQL for " + sqlPropName);
        String sqlStr = TestUtil.getProperty(sqlPropName);
        TestUtil.logMsg("[DBSupport] SQL = " + sqlStr);
        TestUtil.logMsg("[DBSupport] getStatement: " + this.dbConnection);
        PreparedStatement pStmt = this.dbConnection.prepareStatement(sqlStr);
        return pStmt;
    }

    public void closeStmt(PreparedStatement pStmt, ResultSet result) {
        try {
            if (null != result) {
                result.close();
            }
        }
        catch (SQLException e) {
            TestUtil.logTrace("[DBSupport] Ignoring Exception while closing ResultSet: " + e);
        }
        try {
            if (null != pStmt) {
                pStmt.close();
            }
        }
        catch (SQLException e) {
            TestUtil.logTrace("[DBSupport] Ignoring Exception while closing PreparedStatement: " + e);
        }
    }
}

