/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.ejb.wrappers;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsUtil;
import jakarta.ejb.EJBException;
import jakarta.ejb.MessageDrivenBean;
import jakarta.ejb.MessageDrivenContext;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Properties;

public class MDBWrapper
implements MessageDrivenBean,
MessageListener {
    protected static final String prefix = "java:comp/env/jms/";
    protected static final String qFactoryLookup = "java:comp/env/jms/myQueueConnectionFactory";
    protected static final String replyQueueLookup = "java:comp/env/jms/replyQueue";
    public TSNamingContext nctx = null;
    protected MessageDrivenContext mctx = null;
    protected QueueConnectionFactory qFactory;
    protected QueueConnection conn = null;
    protected Queue replyQueue = null;
    protected QueueSender mSender = null;
    protected boolean result = false;

    public void ejbCreate() {
        try {
            TestUtil.logTrace("[MDBWrapper] ejbCreate()");
            this.nctx = new TSNamingContext();
            TestUtil.logTrace("[MDBWrapper] Looking up java:comp/env/jms/myQueueConnectionFactory");
            this.qFactory = (QueueConnectionFactory)this.nctx.lookup(qFactoryLookup);
            TestUtil.logTrace("[MDBWrapper] Looking up java:comp/env/jms/replyQueue");
            this.replyQueue = (Queue)this.nctx.lookup(replyQueueLookup);
        }
        catch (Exception e) {
            TestUtil.logErr("[MDBWrapper] Exception in ejbCreate()", e);
            throw new EJBException("Exception in ejbCreate()", e);
        }
    }

    public void setMessageDrivenContext(MessageDrivenContext mctx) {
        TestUtil.logTrace("[MDBWrapper] setMessageDrivenContext()");
        this.mctx = mctx;
    }

    public void ejbRemove() {
        TestUtil.logTrace("[MDBWrapper] ejbRemove()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message msg) {
        QueueSession session = null;
        Object messageSent = null;
        String testName = "Undefined";
        Properties props = null;
        boolean pass = false;
        try {
            props = this.getProperties(msg);
            TestUtil.init(props);
            testName = msg.getStringProperty("COM_SUN_JMS_TESTNAME");
            if (testName.equals("cleanUpBean")) {
                TestUtil.logTrace("[MDBWrapper] Removing stateful session bean");
                this.runTest(testName, msg, session, props);
                return;
            }
            pass = this.runTest(testName, msg, session, props);
            this.conn = this.qFactory.createQueueConnection();
            session = this.conn.createQueueSession(true, 0);
            JmsUtil.sendTestResults((String)testName, (boolean)pass, (QueueSession)session, (Queue)this.replyQueue);
        }
        catch (Exception e) {
            TestUtil.logErr("[MDBWrapper] Exception in onMessage(): ", e);
        }
        finally {
            this.cleanup(this.conn);
        }
    }

    protected boolean runTest(String testName, Message msg, QueueSession session, Properties props) {
        Boolean pass = Boolean.FALSE;
        Class[] params = new Class[]{Properties.class};
        Object[] args = new Object[1];
        TestUtil.logTrace("[MDBWrapper] runTest()");
        try {
            TestUtil.logTrace("[MDBWrapper] run test '" + testName + "'");
            Class<?> testDriverClass = this.getClass();
            Method testMethod = testDriverClass.getMethod(testName, params);
            args[0] = props;
            pass = (Boolean)testMethod.invoke((Object)this, args);
        }
        catch (NoSuchMethodException e) {
            TestUtil.logErr("[MDBWrapper] Cannot find method '" + testName + "' make sure it is defined in sub-class", e);
            pass = Boolean.FALSE;
        }
        catch (Exception e) {
            TestUtil.logErr("[MDBWrapper] Unexpected exception", e);
            pass = Boolean.FALSE;
        }
        return pass;
    }

    protected Properties getProperties(Message msg) throws JMSException {
        String hostname = null;
        String traceflag = null;
        String logport = null;
        Properties props = new Properties();
        hostname = msg.getStringProperty("harnesshost");
        props.put("harness.host", hostname);
        traceflag = msg.getStringProperty("harnesslogtraceflag");
        props.put("harness.log.traceflag", traceflag);
        logport = msg.getStringProperty("harnesslogport");
        props.put("harness.log.port", logport);
        Enumeration propNames = msg.getPropertyNames();
        String name = null;
        while (propNames.hasMoreElements()) {
            name = (String)propNames.nextElement();
            props.put(name, msg.getStringProperty(name));
        }
        return props;
    }

    protected void cleanup(QueueConnection conn) {
        try {
            if (null != conn) {
                conn.close();
            }
        }
        catch (Exception e) {
            TestUtil.logErr("[MDBWrapper] Ignoring Exception on QueueConnection cleanup: ", e);
        }
    }
}

