/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.servlet.common.client;

import com.sun.ts.tests.common.webclient.BaseUrlClient;
import com.sun.ts.tests.common.webclient.WebTestCase;
import com.sun.ts.tests.common.webclient.http.HttpRequest;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUrlClient
extends BaseUrlClient {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected static final String APITEST = "apitest";
    protected static final String DONOTUSEServletName = "NoServletName";
    private InetAddress[] _addrs = null;
    private String _servlet = null;

    protected AbstractUrlClient() {
        String suffix;
        Object cname = ((Object)((Object)this)).getClass().getName();
        String prefix = "com.sun.ts.tests.";
        if (((String)cname).startsWith(prefix)) {
            cname = ((String)cname).substring(prefix.length());
        }
        if (((String)cname).endsWith(suffix = ".URLClient")) {
            cname = ((String)cname).substring(0, ((String)cname).length() - suffix.length());
        }
        cname = ((String)cname).replace('.', '_');
        cname = "/" + (String)cname + "_web";
        this.setContextRoot((String)cname);
    }

    protected void setTestProperties(WebTestCase testCase) {
        this.setStandardProperties(TEST_PROPS.getProperty("standard"), testCase);
        this.setApiTestProperties(TEST_PROPS.getProperty(APITEST), testCase);
        super.setTestProperties(testCase);
    }

    private void setApiTestProperties(String testValue, WebTestCase testCase) {
        if (testValue == null) {
            return;
        }
        this._testName = testValue;
        StringBuilder sb = new StringBuilder(50);
        if (this._servlet != null && TEST_PROPS.getProperty(DONOTUSEServletName) == null) {
            sb.append("GET ").append(this._contextRoot).append("/");
            sb.append(this._servlet).append("?testname=").append(testValue);
            sb.append(" HTTP/1.1");
        } else {
            sb.append("GET ").append(this._contextRoot).append("/");
            sb.append(testValue).append(" HTTP/1.0");
        }
        this.logger.debug("REQUEST LINE: {}", (Object)sb);
        HttpRequest req = new HttpRequest(sb.toString(), this._hostname, this._port);
        testCase.setRequest(req);
        if (TEST_PROPS.getProperty("search_string") == null || TEST_PROPS.getProperty("search_string").equals("")) {
            testCase.setResponseSearchString("Test PASSED");
            testCase.setUnexpectedResponseSearchString("Test FAILED");
        }
    }

    private void setStandardProperties(String testValue, WebTestCase testCase) {
        if (testValue == null) {
            return;
        }
        StringBuffer sb = new StringBuffer(50);
        this._testName = testValue;
        if (this._servlet != null) {
            sb.append("GET ").append(this._contextRoot).append("/");
            sb.append(this._servlet).append("?testname=").append(testValue);
            sb.append(" HTTP/1.1");
        } else {
            sb.append("GET ").append(this._contextRoot).append("/");
            sb.append(testValue).append(" HTTP/1.0");
        }
        this.logger.debug("REQUEST LINE: {}", (Object)sb);
        HttpRequest req = new HttpRequest(sb.toString(), this._hostname, this._port);
        testCase.setRequest(req);
    }

    protected void setServletName(String servlet) {
        this._servlet = servlet;
    }

    protected String getServletName() {
        return this._servlet;
    }

    protected String getLocalInterfaceInfo(boolean returnAddresses) {
        String result = null;
        this.initInetAddress();
        if (this._addrs.length != 0) {
            StringBuilder sb = new StringBuilder(32);
            if (!returnAddresses) {
                sb.append("localhost,");
            } else {
                sb.append("127.0.0.1,");
            }
            for (int i = 0; i < this._addrs.length; ++i) {
                if (returnAddresses) {
                    String ip = this._addrs[i].getHostAddress();
                    if (!ip.equals("127.0.0.1")) {
                        if (ip.contains("%")) {
                            int scope_id = ip.indexOf("%");
                            ip = ip.substring(0, scope_id);
                        }
                        sb.append(ip);
                    }
                } else {
                    String host = this._addrs[i].getCanonicalHostName();
                    if (!host.equals("localhost")) {
                        sb.append(host);
                    }
                }
                if (i + 1 == this._addrs.length) continue;
                sb.append(",");
            }
            result = sb.toString();
            this.logger.trace("[AbstractUrlClient] Interface info: {}", (Object)result);
        }
        return result;
    }

    private void initInetAddress() {
        if (this._addrs == null) {
            try {
                this._addrs = InetAddress.getAllByName(InetAddress.getLocalHost().getCanonicalHostName());
            }
            catch (UnknownHostException uhe) {
                this.logger.info("[AbstractUrlClient][WARNING] Unable to obtain local host information.");
            }
        }
    }

    protected String getRequest(String rq) {
        return rq;
    }

    protected String getURLString(String protocol, String hostname, int portnum, String sContext) {
        return protocol + "://" + hostname + ":" + portnum + "/" + sContext;
    }

    protected URL getURL(String protocol, String hostname, int portnum, String sContext) throws MalformedURLException {
        return new URL(protocol + "://" + hostname + ":" + portnum + "/" + sContext);
    }

    public URLConnection getHttpsURLConnection(URL newURL) throws IOException {
        URLConnection httpsURLConn = null;
        httpsURLConn = newURL.openConnection();
        if (httpsURLConn == null) {
            throw new IOException("Error opening httsURLConnection");
        }
        httpsURLConn.setDoInput(true);
        httpsURLConn.setDoOutput(true);
        httpsURLConn.setUseCaches(false);
        return httpsURLConn;
    }
}

