/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.lib.harness;

import com.sun.ts.lib.deliverable.DeliverableFactory;
import com.sun.ts.lib.deliverable.PropertyManagerInterface;
import com.sun.ts.lib.harness.VehicleVerifier;
import com.sun.ts.lib.util.TestUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;

public final class ProfileHelper {
    private static PropertyManagerInterface jteMgr;

    public static String[] getArchives(String sDir, String sInteropDirections) {
        try {
            jteMgr = DeliverableFactory.getDeliverableInstance().getPropertyManager();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String javaeeLevel = jteMgr.getProperty("javaee.level", "full");
        ArrayList<String> sFilteredAppJarsArray = new ArrayList<String>();
        boolean bEarPresent = false;
        File fTestDir = new File(sDir);
        String[] sAppJarsArray = fTestDir.list(ArchiveFilter.getInstance());
        if (sInteropDirections.equals("forward") && !ProfileHelper.isInteropDir(sDir)) {
            sAppJarsArray = fTestDir.list(NonVIBuiltArchiveFilter.getInstance());
        } else if (sInteropDirections.equals("reverse") && !ProfileHelper.isInteropDir(sDir)) {
            sAppJarsArray = fTestDir.list(VIBuiltArchiveFilter.getInstance());
        }
        if (sAppJarsArray != null) {
            bEarPresent = ProfileHelper.isEarPresent(sAppJarsArray);
            if (javaeeLevel.contains("full")) {
                if (bEarPresent) {
                    for (int ii = 0; ii < sAppJarsArray.length; ++ii) {
                        String name = sAppJarsArray[ii];
                        if (!name.endsWith(".ear") && (name.indexOf("_component") == -1 || !name.endsWith(".jar") && !name.endsWith(".war") && !name.endsWith(".rar") && !name.endsWith(".car"))) continue;
                        sFilteredAppJarsArray.add(name);
                    }
                    sAppJarsArray = sFilteredAppJarsArray.toArray(new String[0]);
                }
            } else {
                for (int ii = 0; ii < sAppJarsArray.length; ++ii) {
                    String name = sAppJarsArray[ii];
                    if (!name.endsWith(".war")) continue;
                    sFilteredAppJarsArray.add(name);
                }
                sAppJarsArray = sFilteredAppJarsArray.toArray(new String[0]);
            }
        }
        return sAppJarsArray;
    }

    private static boolean isEarPresent(String[] archives) {
        boolean bFoundEar = false;
        for (int ii = 0; ii < archives.length; ++ii) {
            if (!archives[ii].endsWith(".ear")) continue;
            bFoundEar = true;
            break;
        }
        return bFoundEar;
    }

    private static boolean isInteropDir(String sDir) {
        return sDir.indexOf("interop") != -1;
    }

    public static class ArchiveFilter
    implements FilenameFilter {
        private static ArchiveFilter instance = new ArchiveFilter();

        private ArchiveFilter() {
        }

        public static ArchiveFilter getInstance() {
            return instance;
        }

        @Override
        public boolean accept(File dir, String name) {
            return (name.endsWith(".ear") || name.endsWith(".war") || name.endsWith(".rar") || name.endsWith(".jar")) && this.deployThisVehicleApp(dir, name) && this.appIsNotExcluded(dir, name);
        }

        protected boolean appIsNotExcluded(File file, String sName) {
            boolean bVal = true;
            if (sName.indexOf("ejb_Tsr.ear") != -1 || sName.indexOf("ejb_Deployment.ear") != -1) {
                bVal = false;
            }
            return bVal;
        }

        protected boolean deployThisVehicleApp(File file, String sName) {
            boolean bVal = false;
            if (sName.indexOf("ejbembed") != -1) {
                bVal = false;
            } else if (sName.indexOf("_vehicle") == -1 || sName.indexOf("_vehicles") != -1) {
                bVal = true;
            } else {
                VehicleVerifier vehicleVerifier = VehicleVerifier.getInstance(file);
                String[] sVal = vehicleVerifier.getVehicleSet();
                if (sVal != null) {
                    int ii;
                    String keywords = jteMgr.getProperty("current.keywords", "all");
                    TestUtil.logHarnessDebug((String)("ProfileHelper - current.keywords = " + keywords));
                    ArrayList<String> filtered = new ArrayList<String>();
                    for (ii = 0; ii < sVal.length; ++ii) {
                        if ((keywords.indexOf(sVal[ii] + "_vehicle") == -1 || keywords.indexOf("!" + sVal[ii] + "_vehicle") != -1) && keywords.indexOf("!" + sVal[ii] + "_vehicle") != -1) continue;
                        filtered.add(sVal[ii]);
                    }
                    if (!filtered.isEmpty()) {
                        sVal = filtered.toArray(new String[0]);
                    }
                    for (ii = 0; ii < sVal.length; ++ii) {
                        if (sName.indexOf(sVal[ii] + "_vehicle") == -1) continue;
                        bVal = true;
                    }
                }
            }
            return bVal;
        }
    }

    public static class NonVIBuiltArchiveFilter
    extends ArchiveFilter {
        private static NonVIBuiltArchiveFilter instance = new NonVIBuiltArchiveFilter();

        private NonVIBuiltArchiveFilter() {
        }

        public static NonVIBuiltArchiveFilter getInstance() {
            return instance;
        }

        @Override
        public boolean accept(File dir, String name) {
            return (name.endsWith(".ear") || name.endsWith(".war") || name.endsWith(".rar") || name.endsWith(".jar")) && !name.startsWith("vi_built_") && this.deployThisVehicleApp(dir, name);
        }
    }

    public static class VIBuiltArchiveFilter
    extends ArchiveFilter {
        private static VIBuiltArchiveFilter instance = new VIBuiltArchiveFilter();

        private VIBuiltArchiveFilter() {
        }

        public static VIBuiltArchiveFilter getInstance() {
            return instance;
        }

        @Override
        public boolean accept(File dir, String name) {
            return (name.endsWith(".ear") || name.endsWith(".war") || name.endsWith(".rar") || name.endsWith(".jar")) && name.startsWith("vi_built_") && this.deployThisVehicleApp(dir, name);
        }
    }
}

