/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.lib.harness;

import com.sun.interview.Interview;
import com.sun.javatest.Harness;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Script;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFinder;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.finder.BinaryTestFinder;
import com.sun.javatest.finder.ChameleonTestFinder;
import com.sun.javatest.util.BackupPolicy;
import com.sun.ts.lib.deliverable.DeliverableFactory;
import com.sun.ts.lib.deliverable.PropertyManagerInterface;
import com.sun.ts.lib.harness.TSHarnessObserver;
import com.sun.ts.lib.harness.TSScript;
import com.sun.ts.lib.harness.TSTestFinder;
import com.sun.ts.lib.javatest.TSLegacyParameters;
import com.sun.ts.lib.util.TestUtil;
import java.io.File;
import java.util.Map;

public class TS
extends TestSuite {
    private TestEnvironment env;
    private boolean observerAdded;
    private PropertyManagerInterface propMgr;

    public TS(File root, Map tsInfo, ClassLoader cl) throws Exception {
        super(root, tsInfo, cl);
    }

    public File getInitialExcludeList() {
        File jtxFile = super.getInitialExcludeList();
        if (jtxFile != null && jtxFile.exists() && jtxFile.isFile()) {
            return jtxFile;
        }
        String tsHome = System.getProperty("TS_HOME");
        jtxFile = new File(tsHome, "bin/ts.jtx");
        return jtxFile;
    }

    public InterviewParameters createInterview() {
        TSLegacyParameters ctsInterv = null;
        try {
            ctsInterv = new TSLegacyParameters((TestSuite)this);
        }
        catch (Interview.HelpNotFoundFault f) {
            TestUtil.logHarness((String)"TS.createInterview() couldn't find help files.");
        }
        catch (Interview.BadHelpFault bf) {
            TestUtil.logHarness((String)"TS.createInterview() found invalid help files.");
        }
        catch (Exception ep) {
            TestUtil.logHarness((String)("TS.createInterview()" + ep.toString()));
            ep.printStackTrace();
        }
        return ctsInterv;
    }

    public Script createScript(TestDescription td, String[] exclTestCases, TestEnvironment scriptEnv, WorkDirectory workDir, BackupPolicy backupPolicy) throws TestSuite.Fault {
        TSScript s = new TSScript();
        s.initArgs(TestUtil.EMPTY_STRING_ARRAY);
        s.initTestDescription(td);
        s.initExcludedTestCases(exclTestCases);
        s.initTestEnvironment(scriptEnv);
        s.initWorkDir(workDir);
        s.initBackupPolicy(backupPolicy);
        return s;
    }

    public TestFinder createTestFinder() throws TestSuite.Fault {
        File fTSRoot = this.getRoot();
        if (fTSRoot == null) {
            TestUtil.logHarness((String)"getRoot() returns null!");
            fTSRoot = new File(System.getProperty("TS_HOME"), "src");
        }
        File jtd = new File(fTSRoot, "testsuite.jtd");
        Object finder = null;
        String[] args = null;
        if (jtd.exists() && !Boolean.getBoolean("no.binary.finder")) {
            finder = new BinaryTestFinder();
            args = new String[]{"-binary", jtd.getPath()};
            TestUtil.logHarness((String)"Use BinaryTestFinder...");
        } else {
            String finderFilePath = this.getFinderFilePath();
            if (finderFilePath == null) {
                finder = new TSTestFinder();
                args = TestUtil.EMPTY_STRING_ARRAY;
                TestUtil.logHarness((String)"Use TSTestFinder...");
            } else {
                finder = new ChameleonTestFinder();
                args = new String[]{"-f", finderFilePath};
                TestUtil.logHarness((String)"Use ChameleonTestFinder...");
            }
        }
        try {
            finder.init(args, fTSRoot, null);
        }
        catch (TestFinder.Fault exp) {
            exp.printStackTrace();
            throw new TestSuite.Fault(null, "error initializing test finder.");
        }
        return finder;
    }

    public void starting(Harness harness) throws TestSuite.Fault {
        if (this.observerAdded) {
            return;
        }
        this.env = harness.getParameters().getEnv();
        try {
            this.propMgr = DeliverableFactory.getDeliverableInstance().createPropertyManager(this.env);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            TestUtil.logHarness((String)"Failed to create PropertyManager in TS constructor.");
        }
        try {
            String sTestDir = this.propMgr.getProperty("harness.temp.directory");
            if (TestUtil.harnessDebug) {
                TestUtil.logHarnessDebug((String)("Harness temp dir = " + sTestDir));
            }
            this.createDir(sTestDir);
            this.cleanDir(new File(sTestDir), new File(sTestDir));
        }
        catch (Exception e) {
            e.printStackTrace();
            TestUtil.logHarness((String)"Failed to create PropertyManager.");
        }
        harness.addObserver((Harness.Observer)new TSHarnessObserver());
        this.observerAdded = true;
    }

    private String getFinderFilePath() {
        File propsDir = new File(System.getProperty("TS_HOME", System.getProperty("ts.home")) + File.separator + "src" + File.separator + "com" + File.separator + "sun" + File.separator + "ts" + File.separator + "lib", "harness");
        File finderProperties = new File(propsDir, "finder.properties");
        System.err.println("finderProperties = " + finderProperties.toString());
        if (!finderProperties.exists()) {
            finderProperties = new File(propsDir, "map.jtc");
        }
        if (finderProperties.exists()) {
            return finderProperties.getPath();
        }
        return null;
    }

    private void createDir(String sDir) throws Exception {
        File fDir = new File(sDir);
        if (!fDir.exists()) {
            if (!fDir.mkdirs()) {
                throw new Exception("Failed to create directory: " + sDir);
            }
            TestUtil.logHarnessDebug((String)("Successfully created directory: " + sDir));
        }
    }

    private void cleanDir(File initialDir, File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) continue;
            files[i].delete();
        }
    }
}

