/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.connector.embedded.adapter1;

import com.sun.ts.tests.common.connector.embedded.adapter1.CRDActivationSpec;
import com.sun.ts.tests.common.connector.embedded.adapter1.CRDMessageListener;
import com.sun.ts.tests.common.connector.embedded.adapter1.CRDMessageWork;
import com.sun.ts.tests.common.connector.embedded.adapter1.CRDWorkManager;
import com.sun.ts.tests.common.connector.util.ConnectorStatus;
import com.sun.ts.tests.common.connector.util.TSMessageListenerInterface;
import com.sun.ts.tests.common.connector.whitebox.Debug;
import com.sun.ts.tests.common.connector.whitebox.Util;
import com.sun.ts.tests.common.connector.whitebox.XidImpl;
import jakarta.resource.NotSupportedException;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ActivationSpec;
import jakarta.resource.spi.AuthenticationMechanism;
import jakarta.resource.spi.BootstrapContext;
import jakarta.resource.spi.ConfigProperty;
import jakarta.resource.spi.Connector;
import jakarta.resource.spi.ResourceAdapter;
import jakarta.resource.spi.ResourceAdapterInternalException;
import jakarta.resource.spi.SecurityPermission;
import jakarta.resource.spi.TransactionSupport;
import jakarta.resource.spi.endpoint.MessageEndpointFactory;
import jakarta.resource.spi.work.ExecutionContext;
import jakarta.resource.spi.work.TransactionContext;
import jakarta.resource.spi.work.Work;
import jakarta.resource.spi.work.WorkListener;
import jakarta.resource.spi.work.WorkManager;
import java.io.Serializable;
import java.lang.reflect.Method;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

@Connector(description={"CTS Test Resource Adapter with No DD"}, displayName={"whitebox-rd.rar"}, vendorName="Java Software", eisType="TS EIS", version="1.7", licenseDescription={"CTS License Required"}, licenseRequired=true, authMechanisms={@AuthenticationMechanism(credentialInterface=AuthenticationMechanism.CredentialInterface.PasswordCredential, authMechanism="BasicPassword", description={"Basic Password Authentication"})}, reauthenticationSupport=false, securityPermissions={@SecurityPermission(description={"Security Perm description"}, permissionSpec="")}, transactionSupport=TransactionSupport.TransactionSupportLevel.XATransaction, requiredWorkContexts={TransactionContext.class})
public class CRDResourceAdapterImpl
implements ResourceAdapter,
Serializable {
    private transient BootstrapContext bsc;
    private transient CRDWorkManager awm;
    private transient WorkManager wm;
    private transient Work work;
    private transient CRDMessageListener ml;
    private transient MessageEndpointFactory mef;
    private String eisUser = "";
    private String eisPwd = "";
    @ConfigProperty(defaultValue="CRDResourceAdapterImpl")
    private String raName;

    public CRDResourceAdapterImpl() {
        this.debug("enterred constructor...");
        this.eisUser = System.getProperty("eislogin.name");
        this.eisPwd = System.getProperty("eislogin.password");
        this.debug("leaving constructor...");
    }

    public void start(BootstrapContext bsc) throws ResourceAdapterInternalException {
        this.debug("enterred start");
        ConnectorStatus.getConnectorStatus().logState("CRDResourceAdapterImpl.start called");
        this.bsc = bsc;
        this.wm = bsc.getWorkManager();
        this.awm = new CRDWorkManager(bsc);
        this.awm.runTests();
        this.debug("leaving start");
    }

    public void stop() {
        this.debug("entered stop");
        this.debug("leaving stop");
    }

    public void endpointActivation(MessageEndpointFactory factory, ActivationSpec as) throws NotSupportedException {
        this.debug("enterred endpointActivation");
        try {
            Method onMessagexa = this.getOnMessageMethod();
            boolean isDelivered = this.mef.isDeliveryTransacted(onMessagexa);
            if (!isDelivered) {
                this.debug("should NOT have found mdb with unsupported transaction attribute!");
            } else {
                this.mef = factory;
                String destinationName = ((CRDActivationSpec)as).getAnnoDestinationName();
                this.work = new CRDMessageWork(destinationName, this.mef);
                this.wm.scheduleWork(this.work, Long.MAX_VALUE, null, null);
                XidImpl myid = new XidImpl();
                ExecutionContext ec = new ExecutionContext();
                int idcount = myid.getFormatId();
                ec.setXid((Xid)myid);
                this.ml = new CRDMessageListener(myid, this.bsc);
                this.wm.scheduleWork(this.work, Long.MAX_VALUE, ec, (WorkListener)this.ml);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        this.debug("leaving endpointActivation");
    }

    public void endpointDeactivation(MessageEndpointFactory ep, ActivationSpec spec) {
        this.debug("enterred endpointDeactivation");
        this.debug("leaving endpointDeactivation");
    }

    private Method getOnMessageMethod() {
        Method onMessageMethod = null;
        try {
            Class<TSMessageListenerInterface> msgListenerClass = TSMessageListenerInterface.class;
            Class[] paramTypes = new Class[]{String.class};
            onMessageMethod = msgListenerClass.getMethod("onMessage", paramTypes);
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
        }
        return onMessageMethod;
    }

    public XAResource[] getXAResources(ActivationSpec[] specs) throws ResourceException {
        this.debug("enterred getXAResources");
        this.debug("leaving getXAResources");
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof CRDResourceAdapterImpl)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        CRDResourceAdapterImpl that = (CRDResourceAdapterImpl)obj;
        if (!Util.isEqual(this.eisUser, that.getEisUser())) {
            return false;
        }
        if (!Util.isEqual(this.eisPwd, that.getEisPwd())) {
            return false;
        }
        return Util.isEqual(this.raName, that.getRaName());
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public void setRaName(String name) {
        this.raName = name;
        String str = "setRAName called with raname=" + this.raName;
        ConnectorStatus.getConnectorStatus().logState(str);
        this.debug(str);
    }

    public String getRaName() {
        this.debug("CRDResourceAdapterImpl.getRAName");
        return this.raName;
    }

    public void debug(String out) {
        Debug.trace("CRDResourceAdapterImpl:  " + out);
    }

    public void setEisUser(String val) {
        this.eisUser = val;
    }

    public String getEisUser() {
        return this.eisUser;
    }

    public void setEisPwd(String val) {
        this.eisUser = val;
    }

    public String getEisPwd() {
        return this.eisPwd;
    }
}

