/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.connector.embedded.adapter1;

import com.sun.ts.tests.common.connector.util.ConnectorStatus;
import com.sun.ts.tests.common.connector.whitebox.Debug;
import com.sun.ts.tests.common.connector.whitebox.NestedWorkXid;
import jakarta.resource.spi.work.ExecutionContext;
import jakarta.resource.spi.work.TransactionContext;
import jakarta.resource.spi.work.Work;
import jakarta.resource.spi.work.WorkCompletedException;
import jakarta.resource.spi.work.WorkException;
import jakarta.resource.spi.work.WorkManager;
import jakarta.resource.spi.work.WorkRejectedException;
import javax.transaction.xa.Xid;

public class NestedWorkXid1
implements Work {
    private WorkManager wm;
    private Xid xid;
    private ContextType contxtType;

    public NestedWorkXid1(WorkManager wm, Xid xid, ContextType contxt) {
        this.wm = wm;
        this.xid = xid;
        this.contxtType = contxt;
        ConnectorStatus.getConnectorStatus().logAPI("NestedWorkXid1.constructor", "", "");
        Debug.trace("NestedWorkXid1.constructor");
    }

    public void release() {
        ConnectorStatus.getConnectorStatus().logAPI("NestedWorkXid1.release", "", "");
        Debug.trace("NestedWorkXid1.release");
    }

    public void run() {
        String strPass = "anno based NestedWorkXid1 child context submitted";
        try {
            Debug.trace("NestedWorkXid1.run");
            ConnectorStatus.getConnectorStatus().logAPI("NestedWorkXid1.run", "", "");
            Debug.trace("Got the xid");
            NestedWorkXid workid = new NestedWorkXid();
            if (this.contxtType == ContextType.TRANSACTION_CONTEXT) {
                Debug.trace("Using TRANSACTION_CONTEXT to set the xid in tc");
                TransactionContext tc = new TransactionContext();
                tc.setXid(this.xid);
                this.wm.doWork((Work)workid, Long.MAX_VALUE, (ExecutionContext)tc, null);
            } else {
                Debug.trace("Using EXECUTION_CONTEXT to set the xid in ec");
                ExecutionContext ec = new ExecutionContext();
                ec.setXid(this.xid);
                this.wm.doWork((Work)workid, Long.MAX_VALUE, ec, null);
            }
            Debug.trace(strPass);
            ConnectorStatus.getConnectorStatus().logState(strPass);
        }
        catch (WorkCompletedException we) {
            Debug.trace(strPass);
            ConnectorStatus.getConnectorStatus().logState(strPass);
        }
        catch (WorkRejectedException we) {
            Debug.trace("WorkRejectedException in NestedWorkXid1");
        }
        catch (WorkException we) {
            Debug.trace("WorkException in NestedWorkXid1");
        }
        catch (Exception ex) {
            Debug.trace("Exception in NestedWorkXid1");
        }
    }

    public static enum ContextType {
        EXECUTION_CONTEXT,
        TRANSACTION_CONTEXT,
        SECURITY_CONTEXT;

    }
}

