/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.connector.whitebox.mdcomplete;

import com.sun.ts.tests.common.connector.util.ConnectorStatus;
import com.sun.ts.tests.common.connector.whitebox.ContextWork;
import com.sun.ts.tests.common.connector.whitebox.Debug;
import com.sun.ts.tests.common.connector.whitebox.NestWork;
import com.sun.ts.tests.common.connector.whitebox.TSSecurityContext;
import com.sun.ts.tests.common.connector.whitebox.TSSecurityContextWithListener;
import com.sun.ts.tests.common.connector.whitebox.WorkImpl;
import com.sun.ts.tests.common.connector.whitebox.XidImpl;
import com.sun.ts.tests.common.connector.whitebox.mdcomplete.TSNestedSecurityContext;
import com.sun.ts.tests.common.connector.whitebox.mdcomplete.UnknownWorkContext;
import jakarta.resource.spi.BootstrapContext;
import jakarta.resource.spi.work.ExecutionContext;
import jakarta.resource.spi.work.TransactionContext;
import jakarta.resource.spi.work.Work;
import jakarta.resource.spi.work.WorkCompletedException;
import jakarta.resource.spi.work.WorkContext;
import jakarta.resource.spi.work.WorkException;
import jakarta.resource.spi.work.WorkManager;
import javax.transaction.xa.Xid;

public class MDCompleteWorkManager {
    private BootstrapContext bsc = null;
    private WorkManager wmgr;
    private String sicUser = "";
    private String sicPwd = "";
    private String eisUser = "";
    private String eisPwd = "";

    public MDCompleteWorkManager(BootstrapContext val) {
        this.debug("enterred constructor");
        this.bsc = val;
        this.wmgr = this.bsc.getWorkManager();
        this.sicUser = System.getProperty("j2eelogin.name");
        this.sicPwd = System.getProperty("j2eelogin.password");
        this.eisUser = System.getProperty("eislogin.name");
        this.eisPwd = System.getProperty("eislogin.password");
        this.debug("leaving constructor");
    }

    public void runTests() {
        this.debug("enterred runTests");
        this.doWork();
        this.testNestedContext();
        this.testNestedContext2();
        this.testNestedContext3();
        this.submitTICWork();
        this.debug("leaving runTests");
    }

    public void doWork() {
        this.debug("MDCompleteWorkManager enterred doWork");
        try {
            WorkImpl workimpl = new WorkImpl(this.wmgr);
            ExecutionContext ec = this.startTx();
            ContextWork w1 = new ContextWork(this.wmgr);
            this.debug("MDCompleteWorkManager.doWork() submitting UnknownWorkContext generate error code.");
            UnknownWorkContext uwc = new UnknownWorkContext();
            uwc.setXid(ec.getXid());
            w1.addWorkContext(uwc);
            this.wmgr.doWork((Work)w1);
        }
        catch (WorkCompletedException e) {
            this.debug("MDCompleteWorkManager WorkCompletedException thrown is " + e.getMessage());
            String strErrorCode = e.getErrorCode();
            if ("1".equals(strErrorCode)) {
                ConnectorStatus.getConnectorStatus().logState("MDCompleteWorkManager threw WorkContextErrorCodes.UNSUPPORTED_CONTEXT_TYPE");
                this.debug("MDCompleteWorkManager threw WorkContextErrorCodes.UNSUPPORTED_CONTEXT_TYPE");
            } else {
                this.debug("MDCompleteWorkManager threw WorkContextErrorCodes = " + strErrorCode);
            }
        }
        catch (WorkException we) {
            this.debug("MDCompleteWorkManager WorkException thrown is " + we.getMessage());
            Debug.printDebugStack((Exception)((Object)we));
        }
        catch (Exception ex) {
            this.debug("MDCompleteWorkManager Exception thrown is " + ex.getMessage());
            Debug.printDebugStack(ex);
        }
        this.debug("MDCompleteWorkManager leaving doWork");
    }

    public void testNestedContext2() {
        try {
            this.debug("enterred testNestedWork2()");
            ContextWork parent = new ContextWork(this.wmgr);
            NestWork nw = new NestWork();
            TSSecurityContextWithListener psic = new TSSecurityContextWithListener(this.sicUser, this.sicPwd, this.eisUser, false);
            parent.addWorkContext((WorkContext)psic);
            parent.addNestedWork(nw);
            this.wmgr.doWork((Work)parent);
        }
        catch (WorkException e) {
            this.debug("testNestedWork2() - got WorkException()");
        }
        catch (Exception e) {
            this.debug("got exception in testNestedContext2() with user = " + this.sicUser + " pwd = " + this.sicPwd + "  principal=" + this.eisUser);
            this.debug(e.toString());
            Debug.printDebugStack(e);
        }
        this.debug("leaving testNestedContext2()");
    }

    public void testNestedContext3() {
        try {
            this.debug("enterred testNestedWork3()");
            ContextWork parent = new ContextWork(this.wmgr);
            NestWork nw = new NestWork();
            TSSecurityContext psic = new TSSecurityContext(this.sicUser, this.sicPwd, this.eisUser, false);
            TSNestedSecurityContext csic = new TSNestedSecurityContext("phakeUsr", "phakePwd", "phakeEis", false, false);
            nw.addWorkContext((WorkContext)csic);
            parent.addWorkContext((WorkContext)psic);
            parent.addNestedWork(nw);
            this.wmgr.doWork((Work)parent);
        }
        catch (WorkException e) {
            this.debug("testNestedWork3() - got WorkException()");
        }
        catch (Exception e) {
            this.debug("got exception in testSecurityInflow() with user = " + this.sicUser + " pwd = " + this.sicPwd + "  principal=" + this.eisUser);
            this.debug(e.toString());
            Debug.printDebugStack(e);
        }
        this.debug("leaving testNestedContext3()");
    }

    public void testNestedContext() {
        String strPass = "Nested Work and Nested Security Context worked.";
        try {
            this.debug("enterred testNestedContext()");
            ContextWork parent = new ContextWork(this.wmgr);
            NestWork nw = new NestWork();
            TSSecurityContextWithListener sic = new TSSecurityContextWithListener(this.sicUser, this.sicPwd, this.eisUser, false);
            TSSecurityContextWithListener sic2 = new TSSecurityContextWithListener(this.sicUser, this.sicPwd, this.eisUser, false);
            parent.addWorkContext((WorkContext)sic);
            nw.addWorkContext((WorkContext)sic2);
            parent.addNestedWork(nw);
            this.wmgr.doWork((Work)parent);
            ConnectorStatus.getConnectorStatus().logState(strPass);
            this.debug(strPass);
        }
        catch (WorkCompletedException e) {
            ConnectorStatus.getConnectorStatus().logState(strPass);
            this.debug(strPass);
        }
        catch (Exception e) {
            this.debug("got exception in testSecurityInflow() with user = " + this.sicUser + " pwd = " + this.sicPwd + "  principal=" + this.eisUser);
            this.debug(e.toString());
            Debug.printDebugStack(e);
        }
        this.debug("leaving testNestedContext()");
    }

    public void submitTICWork() {
        try {
            this.debug("enterred submitTICWork()");
            ExecutionContext ec = this.startTx();
            ContextWork w1 = new ContextWork(this.wmgr);
            TransactionContext tic = new TransactionContext();
            tic.setXid(ec.getXid());
            this.debug("adding Duplicate WorkContext (with dup TIC Listener) should throw WorkContextErrorCodes.DUPLICATE_CONTEXTS.");
            w1.addWorkContext((WorkContext)tic);
            w1.addWorkContext((WorkContext)tic);
            this.wmgr.doWork((Work)w1);
            this.debug("submitted Duplicate WorkContext with dup TIC Listener");
        }
        catch (WorkCompletedException e) {
            String strErrorCode = e.getErrorCode();
            if ("2".equals(strErrorCode)) {
                ConnectorStatus.getConnectorStatus().logState("MDCompleteWorkManager threw WorkContextErrorCodes.DUPLICATE_CONTEXTS");
                this.debug("MDCompleteWorkManager correctly threw WorkContextErrorCodes.DUPLICATE_CONTEXTS");
            } else {
                this.debug("MDCompleteWorkManager threw improper WorkContextErrorCodes = " + strErrorCode);
            }
            this.debug("MDCompleteWorkManager threw WorkContextErrorCodes = " + strErrorCode);
        }
        catch (Exception e) {
            this.debug("got bad exception when testing for WorkContextErrorCodes.DUPLICATE_CONTEXTS");
            Debug.printDebugStack(e);
        }
        this.debug("leaving submitTICWork()");
    }

    private ExecutionContext startTx() {
        ExecutionContext ec = new ExecutionContext();
        try {
            XidImpl xid = new XidImpl();
            ec.setXid((Xid)xid);
            ec.setTransactionTimeout(5000L);
        }
        catch (Exception ex) {
            Debug.printDebugStack(ex);
        }
        return ec;
    }

    public void debug(String out) {
        Debug.trace("MDCompleteWorkManager:  " + out);
    }
}

