/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.dao;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.dao.DAO;
import com.sun.ts.tests.common.dao.DAOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;

public class DataSourceDAO
implements DAO {
    protected static final String DEFAULT_DB_LOOKUP = "jdbc/DB1";
    protected static final String SQL_DELETE_ALL = "delete_all";
    protected String sqlTablePrefix = null;
    protected ConnectionProvider provider = null;
    protected boolean strictPolicy = true;
    private transient Connection dbConnection = null;
    private boolean activeSession;

    public DataSourceDAO(String sqlTablePrefix) throws DAOException {
        this(sqlTablePrefix, new ConnectionProvider());
    }

    public DataSourceDAO(String sqlTablePrefix, String user, String password) throws DAOException {
        this(sqlTablePrefix, new ConnectionProvider(user, password));
    }

    public DataSourceDAO(String dbLookupName, String sqlTablePrefix) throws DAOException {
        this(sqlTablePrefix, new ConnectionProvider(dbLookupName));
    }

    public DataSourceDAO(String dbLookupName, String sqlTablePrefix, String user, String password) throws DAOException {
        this(sqlTablePrefix, new ConnectionProvider(dbLookupName, user, password));
    }

    protected DataSourceDAO(String sqlTablePrefix, ConnectionProvider provider) throws DAOException {
        if (null == sqlTablePrefix || sqlTablePrefix.equals("")) {
            throw new IllegalArgumentException("Invalid sqlTablePrefix" + sqlTablePrefix);
        }
        if (null == provider) {
            throw new IllegalArgumentException("Null provider");
        }
        this.activeSession = false;
        this.provider = provider;
        this.sqlTablePrefix = sqlTablePrefix;
    }

    @Override
    public void startSession() throws DAOException {
        if (this.activeSession || null != this.dbConnection) {
            if (this.strictPolicy) {
                throw new IllegalStateException("CONNECTION LEAK: Nested session detected (startSession() for DAO " + this);
            }
            this.closeDBConnection();
        }
        try {
            this.getDBConnection();
        }
        catch (Exception e) {
            throw new DAOException("Cannot start DAO session", e);
        }
        this.activeSession = true;
    }

    @Override
    public void stopSession() {
        this.activeSession = false;
        this.closeDBConnection();
    }

    public void deleteAll() throws DAOException {
        PreparedStatement pStmt = null;
        try {
            TestUtil.logTrace((String)"[CoffeeDAO] deleteAll()");
            pStmt = this.getStmt(SQL_DELETE_ALL);
            pStmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new DAOException("SQLException in remove(): " + e);
        }
        finally {
            this.closeStmt(pStmt, null);
        }
    }

    public void cleanup() throws DAOException {
        this.startSession();
        try {
            this.deleteAll();
        }
        finally {
            this.stopSession();
        }
    }

    protected void getDBConnection() throws SQLException {
        TestUtil.logTrace((String)"[DataSourceDAO] getDBConnection()");
        if (null == this.dbConnection) {
            this.dbConnection = this.provider.getDBConnection();
        }
        if (this.dbConnection != null) {
            TestUtil.logTrace((String)("dbConnection:" + this.dbConnection.toString()));
        } else {
            TestUtil.logTrace((String)"dbConnection:null");
        }
    }

    protected void closeDBConnection() {
        TestUtil.logTrace((String)"[DataSourceDAO] closeDBConnection()");
        if (null != this.dbConnection) {
            try {
                this.dbConnection.close();
            }
            catch (SQLException e) {
                TestUtil.logMsg((String)("[DataSourceDAO] Closing DB connection:  Ignoring Exception " + e));
            }
            finally {
                this.dbConnection = null;
            }
        }
    }

    protected PreparedStatement getStmt(String suffix) throws DAOException, SQLException {
        if (!this.activeSession) {
            throw new IllegalStateException("No current session");
        }
        TestUtil.logTrace((String)"[DataSourceDAO] getStmt()");
        String sqlPropName = this.sqlTablePrefix + "_" + suffix;
        TestUtil.logTrace((String)("[DataSourceDAO] Get SQL for " + sqlPropName));
        String sqlStr = TestUtil.getProperty((String)sqlPropName);
        if (null == sqlStr) {
            String msg = "Cannot find SQL property '" + sqlPropName + "' please check tssql.stmt";
            TestUtil.logErr((String)msg);
            throw new DAOException(msg);
        }
        TestUtil.logMsg((String)("[DataSourceDAO] SQL = " + sqlStr));
        PreparedStatement pStmt = this.dbConnection.prepareStatement(sqlStr);
        return pStmt;
    }

    public void closeStmt(PreparedStatement pStmt, ResultSet result) {
        try {
            if (null != result) {
                result.close();
            }
        }
        catch (SQLException e) {
            TestUtil.logTrace((String)("[DataSourceDAO] Ignoring Exception while closing ResultSet: " + e));
        }
        try {
            if (null != pStmt) {
                pStmt.close();
            }
        }
        catch (SQLException e) {
            TestUtil.logTrace((String)("[DataSourceDAO] Ignoring Exception while closing PreparedStatement: " + e));
        }
    }

    @Override
    public void setPolicy(int policy) {
        if (1 == policy) {
            this.strictPolicy = true;
        } else if (2 == policy) {
            this.strictPolicy = true;
        } else {
            throw new IllegalArgumentException("Unsupported policy " + policy);
        }
    }

    protected void finalize() throws Throwable {
        TestUtil.logTrace((String)("[DataSourceDAO] finalize(): conn=" + this.dbConnection));
        if ((this.activeSession || null != this.dbConnection) && this.strictPolicy) {
            TestUtil.logErr((String)("CONNECTION LEAK: Openned session on GC for DAO " + this));
            throw new IllegalStateException("CONNECTION LEAK: Openned session on GC for DAO " + this);
        }
    }

    protected static class ConnectionProvider {
        public static final int AUTH_CONTAINER = 1;
        public static final int AUTH_BEAN_MANAGED = 2;
        protected static final String ENV_PREFIX = "java:comp/env/";
        protected String dbLookupName;
        protected int authorizationType;
        protected String user;
        protected String password;
        protected DataSource ds = null;

        protected ConnectionProvider() throws DAOException {
            this(DataSourceDAO.DEFAULT_DB_LOOKUP, 1, null, null);
        }

        protected ConnectionProvider(String user, String password) throws DAOException {
            this(DataSourceDAO.DEFAULT_DB_LOOKUP, 2, user, password);
        }

        protected ConnectionProvider(String dbLookupName) throws DAOException {
            this(dbLookupName, 1, null, null);
        }

        protected ConnectionProvider(String dbLookupName, String user, String password) throws DAOException {
            this(dbLookupName, 2, user, password);
        }

        private ConnectionProvider(String dbLookupName, int authorizationType, String user, String password) throws DAOException {
            if (null == dbLookupName || dbLookupName.equals("")) {
                throw new IllegalArgumentException("Invalid dbLookupName" + dbLookupName);
            }
            if (2 == authorizationType && (null == user || null == password)) {
                throw new IllegalArgumentException("Invalid user/password" + user + "/" + password);
            }
            if (1 != authorizationType && 2 != authorizationType) {
                throw new IllegalArgumentException("Invalid authization type " + authorizationType);
            }
            try {
                this.dbLookupName = dbLookupName;
                this.authorizationType = authorizationType;
                this.user = user;
                this.password = password;
                TestUtil.logTrace((String)("[ConnectionProvider] Looking up datasource " + dbLookupName));
                TSNamingContext nCtx = new TSNamingContext();
                this.ds = (DataSource)nCtx.lookup(ENV_PREFIX + dbLookupName);
            }
            catch (Exception e) {
                throw new DAOException("Naming exception", e);
            }
        }

        public Connection getDBConnection() throws SQLException {
            TestUtil.logTrace((String)"[DataSourceDAO] getDBConnection()");
            return switch (this.authorizationType) {
                case 1 -> {
                    TestUtil.logTrace((String)"AuthorizationType:AUTH_CONTAINER");
                    yield this.ds.getConnection();
                }
                case 2 -> {
                    TestUtil.logTrace((String)"AuthorizationType:AUTH_BEAN_MANAGED");
                    yield this.ds.getConnection(this.user, this.password);
                }
                default -> throw new IllegalStateException("Illegal authorization type :" + this.authorizationType);
            };
        }
    }
}

