/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.vehicle.connectorservlet;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.RemoteStatus;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.vehicle.VehicleRunnable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorVehicleRunner
implements VehicleRunnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectorVehicleRunner.class);
    protected String sVehicle = "connectorservlet";
    protected Status sTestStatus = Status.passed((String)"");
    String urlSuffix = "";
    Status sServletStatus = Status.passed((String)"");
    String sVehicleArchiveName = "";
    String contextRootPrefix;
    String[] argv;
    Properties p;

    @Override
    public Status run(String[] argv, Properties p) {
        this.argv = argv;
        this.p = p;
        this.sVehicle = p.getProperty("vehicle");
        this.sVehicleArchiveName = p.getProperty("vehicle_archive_name");
        this.contextRootPrefix = this.sVehicleArchiveName.indexOf("_vehicles") != -1 ? this.sVehicleArchiveName.substring(0, this.sVehicleArchiveName.indexOf("_vehicles") + 1) + this.sVehicle + "_vehicle_web" : (this.sVehicleArchiveName.endsWith("_web") ? this.sVehicleArchiveName : this.sVehicleArchiveName + "_web");
        this.urlSuffix = "/" + this.contextRootPrefix + "/" + this.sVehicle + "_vehicle";
        return this.run();
    }

    protected Status run() {
        this.urlSuffix = "/" + this.contextRootPrefix + "/connectorservlet_vehicle";
        this.sServletStatus = this.runWebVehicleTest("connectorservlet");
        LOGGER.info("Test: returning from running in connectorservlet vehicles");
        this.sTestStatus = this.sServletStatus.isPassed() ? Status.passed((String)"Test passed in a connectorservlet ") : Status.failed((String)"Test failed in a connectorservlet ");
        return this.sTestStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Status runWebVehicleTest(String vehicle) {
        Status status;
        URLConnection connection = null;
        URL url = null;
        ObjectOutputStream objOut = null;
        ObjectInputStream objIn = null;
        try {
            url = new URL("http://" + this.p.getProperty("webServerHost") + ":" + Integer.parseInt(this.p.getProperty("webServerPort")) + this.urlSuffix);
            connection = url.openConnection();
            LOGGER.info("Opened connection to {}", (Object)url);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setRequestProperty("Content-Type", "java-internal/" + this.p.getClass().getName());
            objOut = new ObjectOutputStream(connection.getOutputStream());
            LOGGER.trace("got outputstream");
            objOut.writeObject(this.p);
            objOut.writeObject(this.argv);
            LOGGER.trace("wrote objects to the {} vehicle", (Object)vehicle);
            objOut.flush();
            objOut.close();
            objOut = null;
            objIn = new ObjectInputStream(connection.getInputStream());
            status = ((RemoteStatus)objIn.readObject()).toStatus();
            TestUtil.logMsg((String)("Test status from a " + vehicle + ":  " + status.getType() + ":" + status.getReason()));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            status = Status.failed((String)"Fatal: Improper URL");
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            status = Status.failed((String)"Please set an appropriate value for the property:  webServerPort");
        }
        catch (IOException e) {
            e.printStackTrace();
            status = Status.failed((String)("Fatal: Problem with connection: " + e));
        }
        catch (Exception e) {
            e.printStackTrace();
            status = Status.failed((String)("ServiceTest failed inside a " + vehicle + ": " + e.getMessage()));
        }
        finally {
            if (objOut != null) {
                try {
                    objOut.close();
                }
                catch (Exception e) {}
            }
            if (objIn != null) {
                try {
                    objIn.close();
                }
                catch (Exception e) {}
            }
        }
        return status;
    }
}

