/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.vehicle.ejb3share;

import com.sun.ts.lib.util.TestUtil;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.RollbackException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.SystemException;
import jakarta.transaction.UserTransaction;

public final class UserTransactionWrapper
implements EntityTransaction {
    private UserTransaction delegate;

    public UserTransactionWrapper() {
    }

    public UserTransactionWrapper(UserTransaction delegate) {
        this.delegate = delegate;
    }

    public void setDelegate(UserTransaction delegate) {
        this.delegate = delegate;
    }

    public void rollback() {
        TestUtil.logTrace((String)"in UserTransactionWrapper.rollback()");
        if (!this.isActive()) {
            throw new IllegalStateException("Transaction is not active.");
        }
        try {
            this.delegate.rollback();
        }
        catch (SystemException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public boolean isActive() {
        boolean active = false;
        try {
            int txStatus = this.delegate.getStatus();
            TestUtil.logTrace((String)("UserTransactionWrapper.isActive().getStatus():" + txStatus));
            if (txStatus == 0 || txStatus == 1) {
                active = true;
            }
        }
        catch (SystemException e) {
            throw new PersistenceException((Throwable)e);
        }
        return active;
    }

    public void setTimeout(Integer timeout) {
    }

    public Integer getTimeout() {
        return null;
    }

    public void commit() {
        TestUtil.logTrace((String)"in UserTransactionWrapper.commit()");
        if (!this.isActive()) {
            throw new IllegalStateException("Transaction is not active.");
        }
        try {
            this.delegate.commit();
        }
        catch (Exception e) {
            throw new RollbackException((Throwable)e);
        }
    }

    public void begin() {
        TestUtil.logTrace((String)"in UserTransactionWrapper.begin()");
        if (this.isActive()) {
            throw new IllegalStateException("Transaction is already active.");
        }
        try {
            this.delegate.begin();
            TestUtil.logTrace((String)("UserTransactionWrapper.begin().getStatus():" + this.delegate.getStatus()));
        }
        catch (SystemException e) {
            throw new PersistenceException((Throwable)e);
        }
        catch (NotSupportedException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public void setRollbackOnly() {
        TestUtil.logTrace((String)"in UserTransactionWrapper.setRollbackOnly()");
        if (!this.isActive()) {
            throw new IllegalStateException("Transaction is not active.");
        }
    }

    public boolean getRollbackOnly() {
        TestUtil.logTrace((String)"in UserTransactionWrapper.getRollbackOnly()");
        if (!this.isActive()) {
            throw new IllegalStateException("Transaction is not active.");
        }
        try {
            int txStatus = this.delegate.getStatus();
            TestUtil.logTrace((String)("UserTransactionWrapper.getRollbackOnly().getStatus():" + txStatus));
            return txStatus == 1;
        }
        catch (SystemException e) {
            throw new PersistenceException((Throwable)e);
        }
    }
}

