/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.vehicle.web;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.RemoteStatus;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.vehicle.VehicleRunnable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;

public class WebVehicleRunner
implements VehicleRunnable {
    protected String sVehicle = "";
    protected Status sTestStatus = Status.passed((String)"");
    String urlSuffix = "";
    Status sServletStatus = Status.passed((String)"");
    Status sJspStatus = Status.passed((String)"");
    String sVehicleArchiveName = "";
    String contextRootPrefix;
    String[] argv;
    Properties p;

    @Override
    public Status run(String[] argv, Properties p) {
        this.argv = argv;
        this.p = p;
        this.sVehicle = p.getProperty("vehicle");
        this.sVehicleArchiveName = p.getProperty("vehicle_archive_name");
        this.contextRootPrefix = this.sVehicleArchiveName.indexOf("_vehicles") != -1 ? this.sVehicleArchiveName.substring(0, this.sVehicleArchiveName.indexOf("_vehicles") + 1) + this.sVehicle + "_vehicle_web" : (this.sVehicleArchiveName.endsWith("_web") ? this.sVehicleArchiveName : this.sVehicleArchiveName + "_web");
        this.urlSuffix = "/" + this.contextRootPrefix + "/" + this.sVehicle + "_vehicle";
        return this.run();
    }

    protected Status run() {
        if (this.sVehicle.equalsIgnoreCase("web")) {
            this.urlSuffix = "/" + this.contextRootPrefix + "/servlet_vehicle";
            this.sServletStatus = this.runWebVehicleTest("servlet");
            this.urlSuffix = "/" + this.contextRootPrefix + "/jsp_vehicle";
            this.sJspStatus = this.runWebVehicleTest("jsp");
            TestUtil.logMsg((String)"Test: returning from running in web vehicles");
        }
        this.sTestStatus = this.sServletStatus.isPassed() && this.sJspStatus.isPassed() ? Status.passed((String)"Test passed in a servlet and in a jsp") : (this.sServletStatus.isFailed() && this.sServletStatus.isFailed() ? Status.failed((String)"Test failed in a servlet and in a jsp") : (this.sJspStatus.isFailed() ? Status.failed((String)"Test passed in a jsp but failed in a servlet") : Status.failed((String)"Test passed in a servlet but failed in a jsp")));
        return this.sTestStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Status runWebVehicleTest(String vehicle) {
        Status status;
        URLConnection connection = null;
        URL url = null;
        ObjectOutputStream objOut = null;
        ObjectInputStream objIn = null;
        try {
            if (vehicle.indexOf("jsp") != -1) {
                this.urlSuffix = this.urlSuffix + ".jsp";
            }
            TSURL ctsURL = new TSURL();
            url = ctsURL.getURL("http", this.p.getProperty("webServerHost"), Integer.parseInt(this.p.getProperty("webServerPort")), this.urlSuffix);
            connection = url.openConnection();
            TestUtil.logMsg((String)("Opened connection to " + url));
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setRequestProperty("Content-Type", "java-internal/" + this.p.getClass().getName());
            objOut = new ObjectOutputStream(connection.getOutputStream());
            TestUtil.logTrace((String)"got outputstream");
            objOut.writeObject(this.p);
            objOut.writeObject(this.argv);
            TestUtil.logTrace((String)("wrote objects to the " + vehicle + " vehicle"));
            objOut.flush();
            objOut.close();
            objOut = null;
            if (vehicle.indexOf("jsp") != -1) {
                Properties sprop = TestUtil.getResponseProperties((URLConnection)connection);
                int type = Integer.parseInt(sprop.getProperty("type"));
                String reason = sprop.getProperty("reason");
                status = new Status(type, reason);
            } else {
                objIn = new ObjectInputStream(connection.getInputStream());
                status = ((RemoteStatus)objIn.readObject()).toStatus();
            }
            TestUtil.logMsg((String)("Test status from a " + vehicle + ":  " + status.getType() + ":" + status.getReason()));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            status = Status.failed((String)"Fatal: Improper URL");
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            status = Status.failed((String)"Please set an appropriate value for the property:  webServerPort");
        }
        catch (IOException e) {
            e.printStackTrace();
            status = Status.failed((String)("Fatal: Problem with connection: " + e));
        }
        catch (Exception e) {
            e.printStackTrace();
            status = Status.failed((String)("ServiceTest failed inside a " + vehicle + ": " + e.getMessage()));
        }
        finally {
            if (objOut != null) {
                try {
                    objOut.close();
                }
                catch (Exception e) {}
            }
            if (objIn != null) {
                try {
                    objIn.close();
                }
                catch (Exception e) {}
            }
        }
        return status;
    }
}

