/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.webclient;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.webclient.Util;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class Goldenfile {
    private static final byte[] NOTFOUND = "NO GOLDENFILE FOUND".getBytes();
    private static final byte[] NOPERM = "INSUFFICIENT PERMISSIONS".getBytes();
    private File _file = null;
    private byte[] _errMessage = null;
    private long _length = 0L;
    private String _encoding = null;

    public Goldenfile(String path, String encoding) {
        this._file = new File(path);
        if (!this._file.exists()) {
            TestUtil.logTrace((String)("[GoldenFile] Goldenfile: " + path + ", not found!"));
            this._errMessage = NOTFOUND;
            this._file = null;
        } else if (!this._file.canRead()) {
            this._errMessage = NOPERM;
            this._file = null;
        } else {
            this._length = this._file.length();
            this._encoding = encoding;
        }
    }

    public long getLength() {
        return this._length;
    }

    public byte[] getGoldenFileAsBytes() throws IOException {
        if (this._file != null) {
            return this.getGoldenFileAsString().getBytes();
        }
        return this._errMessage;
    }

    public String getGoldenFileAsString() throws IOException {
        String gf = null;
        if (this._file != null) {
            TestUtil.logTrace((String)("[Goldenfile] Loading goldenfile using encoding: " + this._encoding));
            FileInputStream in = new FileInputStream(this._file);
            gf = Util.getEncodedStringFromStream(in, this._encoding);
            in.close();
        } else {
            gf = new String(this._errMessage);
        }
        return gf;
    }

    public InputStream getGoldenFileAsStream() throws IOException {
        if (this._file != null) {
            return new ByteArrayInputStream(this.getGoldenFileAsBytes());
        }
        return new ByteArrayInputStream(this._errMessage);
    }
}

