/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.webclient;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.webclient.TestCase;
import com.sun.ts.tests.common.webclient.TestFailureException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TestSequence
implements TestCase {
    private Map<String, TestCase> _testMap = new HashMap<String, TestCase>();
    private List<String> _testNameList = new ArrayList<String>();
    private String _name = "DEFAULT";
    private boolean _managed = false;

    @Override
    public void execute() throws TestFailureException {
        TestUtil.logTrace((String)("[TestSequence] Beginning execution of sequence '" + this._name + "' containing '" + this._testNameList.size() + "' test entities."));
        int size = this._testNameList.size();
        for (int i = 0; i < size; ++i) {
            String testName = this._testNameList.get(i);
            TestUtil.logTrace((String)("[TestSequence] Executing test case: " + testName));
            TestCase cse = this._testMap.get(testName);
            if (this._managed) {
                cse.setState(cse.getState());
            }
            cse.execute();
            TestUtil.logTrace((String)("[TestSequence] Test case: " + testName + "complete."));
        }
        TestUtil.logTrace((String)"[TestSequence] Sequence complete!");
    }

    public void enableStateManagement(boolean value) {
        this._managed = value;
    }

    public boolean isStateManagementEnabled() {
        return this._managed;
    }

    public void addTestCase(String identifier, TestCase cs) {
        this._testMap.put(identifier, cs);
        this._testNameList.add(identifier);
    }

    public void removeTestCase(String identifier) {
        this._testMap.remove(identifier);
        this._testNameList.remove(identifier);
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void setState(Object state) {
    }

    @Override
    public Object getState() {
        throw new UnsupportedOperationException();
    }
}

