/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.webclient.handler;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.webclient.handler.Handler;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.httpclient.Header;

public class LocationHandler
implements Handler {
    private static Handler handler = new LocationHandler();

    private LocationHandler() {
    }

    public static Handler getInstance() {
        return handler;
    }

    @Override
    public boolean invoke(Header configuredHeader, Header responseHeader) {
        boolean pass = true;
        try {
            TestUtil.logTrace((String)"[LocationHandler] LocationHandler invoked.");
            URL configURL = new URL(configuredHeader.getValue());
            URL responseURL = new URL(responseHeader.getValue());
            if (!configURL.getProtocol().equals(responseURL.getProtocol())) {
                pass = false;
                TestUtil.logErr((String)"[LocationHandler] Mismatch between protocols:");
                TestUtil.logErr((String)("[LocationHandler] Configured value: " + configURL.getProtocol()));
                TestUtil.logErr((String)("[LocationHandler] Response value: " + responseURL.getProtocol()));
            }
            if (!configURL.getPath().equals(responseURL.getPath())) {
                pass = false;
                TestUtil.logErr((String)"[LocationHandler] Mismatch between paths:");
                TestUtil.logErr((String)("[LocationHandler] Configured value: " + configURL.getPath()));
                TestUtil.logErr((String)("[LocationHandler] Response value: " + responseURL.getPath()));
            }
            if (configURL.getQuery() == null) {
                if (responseURL.getQuery() != null) {
                    pass = false;
                    TestUtil.logErr((String)"[LocationHandler] Mismatch between querys:");
                    TestUtil.logErr((String)"[LocationHandler] Configured value is null");
                    TestUtil.logErr((String)"[LocationHandler] Response value is non-null");
                }
            } else if (!configURL.getQuery().equals(responseURL.getQuery())) {
                pass = false;
                TestUtil.logErr((String)"[LocationHandler] Mismatch between querys:");
                TestUtil.logErr((String)("[LocationHandler] Configured value: " + configURL.getQuery()));
                TestUtil.logErr((String)("[LocationHandler] Response value: " + responseURL.getQuery()));
            }
        }
        catch (MalformedURLException mue) {
            pass = false;
            TestUtil.logErr((String)"[LocationHandler] MalformedURLException");
            TestUtil.printStackTrace((Throwable)mue);
        }
        return pass;
    }
}

