/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.common;

import com.sun.ts.lib.util.TestUtil;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.Session;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;

public final class Cleanup {
    private String user = null;
    private String pass = null;
    private ConnectionFactory cf = null;
    public static final String JMSDEFAULT = "jmsDefault";

    public Cleanup() {
        this(JMSDEFAULT, JMSDEFAULT, null);
    }

    public Cleanup(ConnectionFactory cf) {
        this(JMSDEFAULT, JMSDEFAULT, cf);
    }

    public Cleanup(String user, String pass, ConnectionFactory cf) {
        this.user = user;
        this.pass = pass;
        this.cf = cf;
    }

    public void doClientQueueTestCleanup(ArrayList connections, ArrayList queues) {
        TestUtil.logTrace((String)"Entering doClientQueueTestCleanup()");
        try {
            this.closeAllConnections(connections);
            this.flushQueue(queues);
            if (queues != null) {
                queues.clear();
            }
            if (connections != null) {
                connections.clear();
            }
        }
        catch (Exception e) {
            TestUtil.logTrace((String)("Ignoring exception: " + e));
        }
        TestUtil.logTrace((String)"Leaving doClientQueueTestCleanup()");
    }

    public void closeAllConnections(ArrayList connections) {
        TestUtil.logTrace((String)"Entering closeAllConnections()");
        try {
            if (connections != null && !connections.isEmpty()) {
                for (int i = 0; i < connections.size(); ++i) {
                    ((Connection)connections.get(i)).close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        TestUtil.logTrace((String)"Leaving closeAllConnections()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushDestination(Destination destination) throws Exception {
        Connection conn = null;
        MessageConsumer consumer = null;
        MessageProducer producer = null;
        Session sess = null;
        ObjectMessage msg = null;
        int priority = 0;
        int numMsgsFlushed = 0;
        TestUtil.logTrace((String)"Entering flushDestination()");
        try {
            TestUtil.logTrace((String)"Create new Connection,Session,MessageProducer,MessageConsumer to flush Destination");
            conn = this.cf.createConnection(this.user, this.pass);
            sess = conn.createSession(false, 1);
            producer = sess.createProducer(destination);
            consumer = sess.createConsumer(destination);
            conn.start();
            msg = sess.createObjectMessage();
            msg.setObject((Serializable)((Object)"Flush Destination"));
            msg.setStringProperty("COM_SUN_JMS_TESTNAME", "flushDestination");
            TestUtil.logTrace((String)"Send low priority message to Destination to signal the last message");
            producer.send((Message)msg, 2, priority, 0L);
            TestUtil.logTrace((String)"Now flush the Destination");
            Message rmsg = consumer.receive(5000L);
            while (rmsg != null) {
                String tname = rmsg.getStringProperty("COM_SUN_JMS_TESTNAME");
                if (tname != null && tname.equals("flushDestination")) {
                    rmsg = consumer.receiveNoWait();
                    while (rmsg != null) {
                        ++numMsgsFlushed;
                        rmsg = consumer.receiveNoWait();
                    }
                    break;
                }
                ++numMsgsFlushed;
                rmsg = consumer.receiveNoWait();
            }
            if (numMsgsFlushed > 0) {
                TestUtil.logTrace((String)("#######flushed " + numMsgsFlushed + " messages"));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("flushDestination exception: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            try {
                conn.close();
            }
            catch (Exception exception) {}
        }
        TestUtil.logTrace((String)"Leaving flushDestination()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushQueue(ArrayList queues) throws Exception {
        Connection qc = null;
        MessageConsumer qconsumer = null;
        Session qs = null;
        Object msg = null;
        Enumeration msgs = null;
        boolean priority = false;
        int numMsgsFlushed = 0;
        int numMsgs = 0;
        TestUtil.logTrace((String)"Entering flushQueue(Arraylist)");
        try {
            TestUtil.logTrace((String)"Create new Connection,Session to flush Queue");
            qc = this.cf.createConnection(this.user, this.pass);
            qs = qc.createSession(false, 1);
            qc.start();
            for (int i = 0; i < queues.size(); ++i) {
                TestUtil.logTrace((String)"Create QueueBrowser to count number of messages left on Queue");
                QueueBrowser qBrowser = qs.createBrowser((Queue)queues.get(i));
                msgs = qBrowser.getEnumeration();
                while (msgs.hasMoreElements()) {
                    msgs.nextElement();
                    ++numMsgs;
                }
                if (numMsgs == 0) {
                    TestUtil.logTrace((String)("No messages left on Queue " + ((Queue)queues.get(i)).getQueueName()));
                    continue;
                }
                TestUtil.logTrace((String)(numMsgs + " messages left on Queue " + ((Queue)queues.get(i)).getQueueName()));
                TestUtil.logTrace((String)"Create new MessageConsumer to flush messages in Queue");
                qconsumer = qs.createConsumer((Destination)((Queue)queues.get(i)));
                TestUtil.logTrace((String)"Now flush the Queue");
                Message rmsg = qconsumer.receive(5000L);
                while (rmsg != null) {
                    ++numMsgsFlushed;
                    rmsg = qconsumer.receiveNoWait();
                    if (rmsg != null) continue;
                    rmsg = qconsumer.receiveNoWait();
                }
                if (numMsgsFlushed <= 0) continue;
                TestUtil.logTrace((String)("Flushed " + numMsgsFlushed + " messages"));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("flushQueue exception: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            try {
                qc.close();
            }
            catch (Exception exception) {}
        }
        TestUtil.logTrace((String)"Leaving flushQueue(ArrayList)");
    }

    public void flushQueue(Queue queue, Session session) throws Exception {
        int numMsgsFlushed = 0;
        int numMsgs = 0;
        Enumeration msgs = null;
        TestUtil.logTrace((String)"Entering flushQueue(Queue, Session)");
        try {
            QueueBrowser qBrowser = session.createBrowser(queue);
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            msgs = qBrowser.getEnumeration();
            while (msgs.hasMoreElements()) {
                msgs.nextElement();
                ++numMsgs;
            }
            if (numMsgs == 0) {
                TestUtil.logTrace((String)("No messages left on Queue " + queue.getQueueName()));
            } else {
                TestUtil.logTrace((String)(numMsgs + " messages left on Queue " + queue.getQueueName()));
                if (consumer != null) {
                    Message msg = consumer.receiveNoWait();
                    while (msg != null) {
                        ++numMsgsFlushed;
                        msg = consumer.receiveNoWait();
                    }
                    if (numMsgsFlushed > 0) {
                        TestUtil.logTrace((String)("Flushed " + numMsgsFlushed + " messages"));
                    }
                    if (numMsgsFlushed > 0 && session.getTransacted()) {
                        session.commit();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        TestUtil.logTrace((String)"Leaving flushQueue(Queue, Session)");
    }
}

