/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.lib.harness;

import com.sun.ts.lib.harness.CleanupMethod;
import com.sun.ts.lib.harness.ExcludeListProcessor;
import com.sun.ts.lib.harness.SetupMethod;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public abstract class EETest
implements Serializable {
    static final long serialVersionUID = -4235235600918875382L;
    protected transient PrintStream log;
    protected transient PrintStream err;
    protected String sTestCase;
    transient Status sTestStatus = Status.passed("");
    Class testClass = this.getClass();
    Object testClInst;
    boolean nCl;
    boolean bUtilAlreadyInitialized;
    Vector vLeftOverTestArgs;
    protected int iLogDelaySeconds;

    protected Properties getTestPropsFromArgs(String[] argv) {
        Properties p = new Properties();
        boolean bRunIndividualTest = false;
        this.vLeftOverTestArgs = new Vector();
        for (int ii = 0; ii < argv.length; ++ii) {
            if (argv[ii].startsWith("-p") || argv[ii].startsWith("-ap")) {
                Properties ap = this.initializeProperties(argv[++ii]);
                Enumeration<?> e = ap.propertyNames();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    p.put(key, ap.getProperty(key));
                }
                continue;
            }
            if (argv[ii].startsWith("-d")) {
                String sProp = argv[ii].substring(2, argv[ii].indexOf(61));
                String sVal = argv[ii].substring(argv[ii].indexOf(61) + 1);
                p.put(sProp, sVal);
                continue;
            }
            if (argv[ii].equalsIgnoreCase("-t")) {
                this.sTestCase = argv[++ii];
                bRunIndividualTest = true;
                continue;
            }
            this.vLeftOverTestArgs.addElement(argv[ii]);
        }
        if (bRunIndividualTest) {
            p.setProperty("testName", this.sTestCase);
        }
        return p;
    }

    private Method getSetupMethod(Class testClass, Method runMethod) {
        String[] s = new String[]{};
        Class[] setupParameterTypes = new Class[]{s.getClass(), new Properties().getClass()};
        Method setupMethod = null;
        SetupMethod annotation = runMethod.getAnnotation(SetupMethod.class);
        String testSetupMethodName = null;
        if (annotation != null) {
            try {
                TestUtil.logTrace((String)"getSetupMethod - getting setup method from annotation");
                SetupMethod setupAnnotation = annotation;
                testSetupMethodName = setupAnnotation.name();
                setupMethod = testClass.getMethod(setupAnnotation.name(), setupParameterTypes);
                TestUtil.logTrace((String)("getSetupMethod - setup method name: " + setupAnnotation.name()));
            }
            catch (NoSuchMethodException e) {
                this.setTestStatus(Status.failed("Could not find annotation defined test setup method (" + testSetupMethodName + ") for testcase: " + this.sTestCase), e);
            }
        } else {
            TestUtil.logTrace((String)"No setupMethod annotation present");
            try {
                TestUtil.logTrace((String)("getSetupMethod - checking for testcase specific setup method:  " + this.sTestCase + "_setup"));
                setupMethod = testClass.getMethod(this.sTestCase + "_setup", setupParameterTypes);
            }
            catch (NoSuchMethodException e2) {
                TestUtil.logTrace((String)"getSetupMethod - checking for default class specific setup method");
                try {
                    setupMethod = testClass.getMethod("setup", setupParameterTypes);
                }
                catch (NoSuchMethodException e3) {
                    this.setTestStatus(Status.failed("Could not find setup method fortestcase: " + this.sTestCase), e3);
                }
            }
            catch (RuntimeException re) {
                this.setTestStatus(Status.failed("Could not access the test case: " + this.sTestCase), re);
            }
            catch (ThreadDeath t) {
                throw t;
            }
            catch (Throwable t) {
                this.setTestStatus(Status.failed("Unexpected Throwable: " + t), t);
            }
        }
        return setupMethod;
    }

    private Method getRunMethod(Class testClass) {
        Method runMethod = null;
        try {
            TestUtil.logTrace((String)("** IN getRunMethod: testClass=" + testClass.getName()));
            TestUtil.logTrace((String)("** IN getRunMethod: testname=" + this.sTestCase));
            runMethod = testClass.getMethod(this.sTestCase, null);
        }
        catch (NoSuchMethodException e) {
            this.setTestStatus(Status.failed("Could not find the run methodfor test case: " + this.sTestCase), e);
        }
        catch (RuntimeException e) {
            this.setTestStatus(Status.failed("Could not access the test case: " + this.sTestCase), e);
        }
        catch (ThreadDeath t) {
            throw t;
        }
        catch (Throwable t) {
            this.setTestStatus(Status.failed("Unexpected Throwable: " + t), t);
        }
        return runMethod;
    }

    private Method getCleanupMethod(Class testClass, Method runMethod) {
        Method cleanupMethod = null;
        CleanupMethod annotation = runMethod.getAnnotation(CleanupMethod.class);
        if (annotation != null) {
            try {
                TestUtil.logTrace((String)"getCleanupMethod - getting cleanup method from annotation");
                CleanupMethod cleanupAnnotation = annotation;
                cleanupMethod = testClass.getMethod(cleanupAnnotation.name(), null);
                TestUtil.logTrace((String)("getCleanupMethod - cleanup method name: " + cleanupAnnotation.name()));
            }
            catch (NoSuchMethodException e) {
                this.setTestStatus(Status.failed("Could not find annotation defined cleanup method for testcase: " + this.sTestCase), e);
            }
        } else {
            TestUtil.logTrace((String)"No cleanupMethod annotation present");
            try {
                TestUtil.logTrace((String)("getCleanupMethod - checking for testcase specific cleanup method:  " + this.sTestCase + "_cleanup"));
                cleanupMethod = testClass.getMethod(this.sTestCase + "_cleanup", null);
            }
            catch (NoSuchMethodException e2) {
                TestUtil.logTrace((String)"getCleanupMethod - checking for default class specific cleanup method");
                try {
                    cleanupMethod = testClass.getMethod("cleanup", null);
                }
                catch (NoSuchMethodException e3) {
                    this.setTestStatus(Status.failed("Could not find cleanup method fortestcase: " + this.sTestCase), e3);
                }
            }
            catch (RuntimeException re) {
                this.setTestStatus(Status.failed("Could not access the test case: " + this.sTestCase), re);
            }
            catch (ThreadDeath t) {
                throw t;
            }
            catch (Throwable t) {
                this.setTestStatus(Status.failed("Unexpected Throwable: " + t), t);
            }
        }
        return cleanupMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties initializeProperties(String sPropertiesFile) {
        FileInputStream propertyFileInputStream = null;
        Properties props = null;
        try {
            propertyFileInputStream = new FileInputStream(sPropertiesFile);
            props = new Properties();
            props.load(propertyFileInputStream);
        }
        catch (FileNotFoundException e) {
            TestUtil.logHarness((String)"Could not find specified props file", (Throwable)e);
        }
        catch (IOException e) {
            TestUtil.logHarness((String)"IOException while reading props file", (Throwable)e);
        }
        catch (Exception e) {
            TestUtil.logHarness((String)"Exception while reading props file", (Throwable)e);
        }
        finally {
            try {
                if (propertyFileInputStream != null) {
                    propertyFileInputStream.close();
                }
            }
            catch (IOException ex) {
                TestUtil.logHarness((String)"IOException while closing props file", (Throwable)ex);
            }
        }
        return props;
    }

    public Status run(String[] argv, PrintStream log, PrintStream err) {
        return this.run(argv, new PrintWriter(log, true), new PrintWriter(err, true));
    }

    public Status run(String[] argv, PrintWriter log, PrintWriter err) {
        Status retStatus = Status.failed("No status set yet");
        Properties props = this.getTestPropsFromArgs(argv);
        try {
            String delayseconds = TestUtil.getProperty((Properties)props, (String)"harness.log.delayseconds", (String)"0");
            this.iLogDelaySeconds = Integer.parseInt(delayseconds) * 1000;
        }
        catch (NumberFormatException e) {
            this.iLogDelaySeconds = 0;
        }
        if (props.isEmpty()) {
            return Status.failed("FAILED:  An error occurred while trying to load the test properties");
        }
        int iSize = this.vLeftOverTestArgs.size();
        if (iSize == 0) {
            argv = null;
        } else {
            argv = new String[iSize];
            for (int ii = 0; ii < iSize; ++ii) {
                argv[ii] = (String)this.vLeftOverTestArgs.elementAt(ii);
            }
        }
        props.put("line.separator", System.getProperty("line.separator"));
        if (this.sTestCase == null) {
            return this.runAllTestCases(argv, props, log, err);
        }
        TestUtil.setCurrentTest((String)this.sTestCase, (PrintWriter)log, (PrintWriter)err);
        TestUtil.initClient((Properties)props);
        retStatus = this.getPropsReady(argv, props);
        try {
            Thread.sleep(this.iLogDelaySeconds);
        }
        catch (InterruptedException e) {
            this.logErr("Exception: " + e);
        }
        return retStatus;
    }

    protected void setTestStatus(Status s, Throwable t) {
        if (this.sTestStatus.getType() == 0) {
            this.sTestStatus = s;
        }
        if (t != null) {
            TestUtil.logErr((String)s.getReason());
            TestUtil.logErr((String)"Exception at:  ", (Throwable)t);
        }
    }

    protected Status runAllTestCases(String[] argv, Properties p, PrintWriter log, PrintWriter err) {
        int ii;
        String[] sTestCases;
        int iPassedCount = 0;
        int iFailedCount = 0;
        TestUtil.initClient((Properties)p);
        try {
            sTestCases = this.getAllTestCases(p);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Status.failed("An error occurred trying to get alltestcase methods.");
        }
        for (ii = 0; ii < sTestCases.length; ++ii) {
            this.sTestCase = sTestCases[ii];
            p.setProperty("testName", this.sTestCase);
            TestUtil.setCurrentTest((String)this.sTestCase, (PrintWriter)log, (PrintWriter)err);
            this.bUtilAlreadyInitialized = true;
            this.sTestStatus = Status.passed("");
            TestUtil.separator2();
            TestUtil.logMsg((String)("Beginning Test:  " + sTestCases[ii]));
            TestUtil.separator2();
            this.sTestStatus = this.getPropsReady(argv, p);
            try {
                Thread.sleep(this.iLogDelaySeconds);
            }
            catch (InterruptedException e) {
                this.logErr("Exception: " + e);
            }
            if (this.sTestStatus.getType() == 0) {
                int n = ii;
                sTestCases[n] = sTestCases[n] + "...........PASSED";
                ++iPassedCount;
            } else {
                TestUtil.logMsg((String)this.sTestStatus.getReason());
                int n = ii;
                sTestCases[n] = sTestCases[n] + "...........FAILED";
                ++iFailedCount;
            }
            TestUtil.separator2();
            TestUtil.logMsg((String)("End Test:  " + sTestCases[ii]));
            TestUtil.separator2();
        }
        TestUtil.separator2();
        TestUtil.logMsg((String)("Completed running " + sTestCases.length + " tests."));
        TestUtil.logMsg((String)("Number of Tests Passed = " + iPassedCount));
        TestUtil.logMsg((String)("Number of Tests Failed = " + iFailedCount));
        TestUtil.separator2();
        for (ii = 0; ii < sTestCases.length; ++ii) {
            TestUtil.logMsg((String)sTestCases[ii]);
        }
        if (iFailedCount > 0) {
            return Status.failed("FAILED");
        }
        return Status.passed("PASSED");
    }

    public Status run(String[] argv, Properties p, PrintWriter log, PrintWriter err) {
        this.sTestCase = TestUtil.getProperty((Properties)p, (String)"testName");
        TestUtil.setCurrentTest((String)this.sTestCase, (PrintWriter)log, (PrintWriter)err);
        TestUtil.initClient((Properties)p);
        return this.getPropsReady(argv, p);
    }

    protected Status getPropsReady(String[] argv, Properties p) {
        String finder;
        Enumeration<?> enum1 = p.propertyNames();
        while (enum1.hasMoreElements()) {
            String key = (String)enum1.nextElement();
            String value = p.getProperty(key);
            if (value == null) continue;
            p.put(key, value.trim());
        }
        this.sTestCase = TestUtil.getProperty((Properties)p, (String)"testName");
        String sClass_name = TestUtil.getProperty((Properties)p, (String)"test_classname");
        if (sClass_name != null && (finder = TestUtil.getProperty((Properties)p, (String)"finder")).trim().equals("jck") && !this.getClass().getName().equals(sClass_name.trim())) {
            try {
                this.testClInst = Class.forName(sClass_name).newInstance();
                this.testClass = this.testClInst.getClass();
                this.nCl = true;
            }
            catch (Exception te) {
                te.printStackTrace();
            }
        }
        if (p.getProperty("harness.host") == null) {
            p.setProperty("harness.host", "localhost");
        }
        return this.run(argv, p);
    }

    public Status run(String[] argv, Properties p) {
        this.sTestStatus = Status.passed("");
        this.sTestCase = TestUtil.getProperty((Properties)p, (String)"testName");
        Object[] testArgs = new Object[]{argv, p};
        TestUtil.logTrace((String)"*** in EETest.run(argv,p)");
        if (this.sTestCase == null || this.sTestCase.equals("")) {
            return Status.failed("Invalid test case name: " + this.sTestCase);
        }
        TestUtil.logTrace((String)("TESTCLASS=" + this.testClass.getName()));
        Method runMethod = this.getRunMethod(this.testClass);
        if (runMethod == null) {
            return Status.failed("Invalid test case name as test run Method ( " + this.sTestCase + ") could not be found in " + this.testClass.getName());
        }
        TestUtil.logTrace((String)"** GOT RUN METHOD!");
        TestUtil.logTrace((String)("**runmethod=" + runMethod.getName()));
        TestUtil.logTrace((String)"ABOUT TO GET SETUP METHOD!");
        Method setupMethod = this.getSetupMethod(this.testClass, runMethod);
        if (setupMethod == null) {
            return Status.failed("Invalid test case name as test setupMethod could not be found ( Test setup method: " + this.getSetupMethodName(runMethod) + ", testName:" + this.sTestCase + ") in test class " + this.testClass.getName() + "(test class was loaded from: " + this.testClass.getClassLoader().getName() + ")");
        }
        TestUtil.logTrace((String)("GOT SETUP METHOD: " + setupMethod.getName() + " for " + this.testClass.getName()));
        Method cleanupMethod = this.getCleanupMethod(this.testClass, runMethod);
        if (cleanupMethod == null) {
            return Status.failed("Invalid test case name as test cleanupMethod Method ( for " + this.sTestCase + ") could not be found in " + this.testClass.getName());
        }
        TestUtil.logTrace((String)("GOT CLEANUP METHOD: " + cleanupMethod.getName() + " for " + this.testClass.getName()));
        try {
            TestUtil.logTrace((String)"ABOUT TO INVOKE SETUP METHOD!");
            if (this.nCl) {
                setupMethod.invoke(this.testClInst, testArgs);
            } else {
                setupMethod.invoke((Object)this, testArgs);
            }
            TestUtil.logTrace((String)"INVOKED SETUP METHOD!");
        }
        catch (IllegalAccessException e) {
            this.setTestStatus(Status.failed("Could not execute setup methodfor test case: " + this.sTestCase), e);
        }
        catch (InvocationTargetException e) {
            this.setTestStatus(Status.failed("Test case throws exception: " + e.getTargetException().toString()), e.getTargetException());
        }
        catch (RuntimeException e) {
            this.setTestStatus(Status.failed("Could not access the test case: " + e.toString()), e);
        }
        catch (ThreadDeath t) {
            throw t;
        }
        catch (Throwable t) {
            this.setTestStatus(Status.failed("Unexpected Throwable: " + t), t);
        }
        if (this.sTestStatus.getType() == 0) {
            TestUtil.logTrace((String)"ABOUT TO INVOKE EETEST RUN METHOD!");
            try {
                if (this.nCl) {
                    runMethod.invoke(this.testClInst, (Object[])null);
                } else {
                    runMethod.invoke((Object)this, (Object[])null);
                }
            }
            catch (IllegalAccessException e) {
                this.setTestStatus(Status.failed("Could not execute run methodfor test case: " + this.sTestCase), e);
            }
            catch (InvocationTargetException e) {
                this.setTestStatus(Status.failed("Test case throws exception: " + e.getTargetException().getMessage()), e.getTargetException());
            }
            catch (RuntimeException e) {
                this.setTestStatus(Status.failed("Could not access the test case: " + e.toString()), e);
            }
            catch (ThreadDeath t) {
                throw t;
            }
            catch (Throwable t) {
                this.setTestStatus(Status.failed("Unexpected Throwable: " + t), t);
            }
        }
        try {
            if (this.nCl) {
                cleanupMethod.invoke(this.testClInst, (Object[])null);
            } else {
                cleanupMethod.invoke((Object)this, (Object[])null);
            }
        }
        catch (IllegalAccessException e) {
            this.setTestStatus(Status.failed("Could not execute cleanup method for test case: " + this.sTestCase), e);
        }
        catch (InvocationTargetException e) {
            this.setTestStatus(Status.failed("Test case throws exception: " + e.getTargetException().getMessage()), e.getTargetException());
        }
        catch (RuntimeException e) {
            this.setTestStatus(Status.failed("Could not access the test case: " + e.toString()), e);
        }
        catch (ThreadDeath t) {
            throw t;
        }
        catch (Throwable t) {
            this.setTestStatus(Status.failed("Unexpected Throwable: " + t), t);
        }
        return this.sTestStatus;
    }

    private String getSetupMethodName(Method runMethod) {
        SetupMethod annotation = runMethod.getAnnotation(SetupMethod.class);
        if (annotation != null) {
            SetupMethod setupAnnotation = annotation;
            return setupAnnotation.name();
        }
        return "";
    }

    private String[] getAllTestCases(Properties p) throws SetupException {
        Vector<String> tests = new Vector<String>();
        try {
            ExcludeListProcessor.readExcludeList(TestUtil.getSystemProperty((String)"exclude.list"));
            Object sJavaTestName = "";
            Object sVehicle = TestUtil.getProperty((Properties)p, (String)"vehicle");
            if (sVehicle != null) {
                sVehicle = "_from_" + (String)sVehicle;
            }
            String sClientClassName = this.getClass().getName();
            String sClientJavaName = sClientClassName.substring(sClientClassName.lastIndexOf(46) + 1) + ".java";
            String sCurrentDir = TestUtil.getSystemProperty((String)"current.dir");
            sCurrentDir = sCurrentDir.replace(File.separatorChar, '/');
            Object sRelativeTestDir = sCurrentDir.substring(sCurrentDir.indexOf("tests/"));
            if (!((String)(sRelativeTestDir = ((String)sRelativeTestDir).substring(((String)sRelativeTestDir).indexOf("/") + 1))).endsWith("/")) {
                sRelativeTestDir = (String)sRelativeTestDir + "/";
            }
            Method[] methods = this.testClass.getMethods();
            for (int ii = 0; ii < methods.length; ++ii) {
                String sName;
                Class<?>[] paramTypes = methods[ii].getParameterTypes();
                if (paramTypes.length != 0 || (sName = methods[ii].getName()).indexOf("Test") == -1 && sName.indexOf("test") == -1 || sName.indexOf("Setup") != -1 || sName.indexOf("setup") != -1 || sName.indexOf("Cleanup") != -1 || sName.indexOf("cleanup") != -1) continue;
                sJavaTestName = sName + (String)sVehicle;
                if (!ExcludeListProcessor.isTestExcluded((String)(sJavaTestName = (String)sRelativeTestDir + sClientJavaName + "#" + (String)sJavaTestName))) {
                    tests.addElement(sName);
                } else {
                    System.out.println((String)sJavaTestName + " is excluded.");
                }
                sJavaTestName = "";
            }
        }
        catch (SecurityException e) {
            throw new SetupException("Failed while getting all test methods: ", e);
        }
        if (tests.size() <= 0) {
            throw new SetupException("No methods match signature: \"public void methodName()\"");
        }
        String[] testMethods = new String[tests.size()];
        for (int ii = 0; ii < testMethods.length; ++ii) {
            testMethods[ii] = (String)tests.elementAt(ii);
        }
        return testMethods;
    }

    public void logMsg(String msg) {
        TestUtil.logMsg((String)msg);
    }

    public void logTrace(String msg) {
        TestUtil.logTrace((String)msg);
    }

    public void logTrace(String msg, Throwable e) {
        TestUtil.logTrace((String)msg, (Throwable)e);
    }

    public void logErr(String msg) {
        TestUtil.logErr((String)msg);
    }

    public void logErr(String msg, Throwable e) {
        TestUtil.logErr((String)msg, (Throwable)e);
    }

    public static class SetupException
    extends Exception {
        private static final long serialVersionUID = -7616313680616499158L;
        public Exception e;

        public SetupException(String msg) {
            super(msg);
        }

        public SetupException(String msg, Exception e) {
            super(msg);
            this.e = e;
        }

        @Override
        public void printStackTrace() {
            if (this.e != null) {
                this.e.printStackTrace();
            } else {
                super.printStackTrace();
            }
        }

        @Override
        public void printStackTrace(PrintStream s) {
            if (this.e != null) {
                this.e.printStackTrace(s);
            } else {
                super.printStackTrace(s);
            }
        }

        @Override
        public void printStackTrace(PrintWriter s) {
            if (this.e != null) {
                this.e.printStackTrace(s);
            } else {
                super.printStackTrace(s);
            }
        }

        @Override
        public Throwable getCause() {
            return this.e;
        }

        @Override
        public synchronized Throwable initCause(Throwable cause) {
            if (this.e != null) {
                throw new IllegalStateException("Can't overwrite cause");
            }
            if (!Exception.class.isInstance(cause)) {
                throw new IllegalArgumentException("Cause not permitted");
            }
            this.e = (Exception)cause;
            return this;
        }
    }

    public static class Fault
    extends Exception {
        private static final long serialVersionUID = -1574745208867827913L;
        public Throwable t;

        public Fault(String msg) {
            super(msg);
            TestUtil.logErr((String)msg);
        }

        public Fault(String msg, Throwable t) {
            super(msg);
            this.t = t;
        }

        public Fault(Throwable t) {
            super(t);
            this.t = t;
        }

        @Override
        public void printStackTrace() {
            if (this.t != null) {
                this.t.printStackTrace();
            } else {
                super.printStackTrace();
            }
        }

        @Override
        public void printStackTrace(PrintStream s) {
            if (this.t != null) {
                this.t.printStackTrace(s);
            } else {
                super.printStackTrace(s);
            }
        }

        @Override
        public void printStackTrace(PrintWriter s) {
            if (this.t != null) {
                this.t.printStackTrace(s);
            } else {
                super.printStackTrace(s);
            }
        }

        @Override
        public Throwable getCause() {
            return this.t;
        }

        @Override
        public synchronized Throwable initCause(Throwable cause) {
            if (this.t != null) {
                throw new IllegalStateException("Can't overwrite cause");
            }
            if (!Exception.class.isInstance(cause)) {
                throw new IllegalArgumentException("Cause not permitted");
            }
            this.t = (Exception)cause;
            return this;
        }
    }
}

