/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.lib.harness;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.vehicle.VehicleRunnable;
import com.sun.ts.tests.common.vehicle.VehicleRunnerFactory;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class ServiceEETest
extends EETest {
    String[] sVehicles;
    private Object theSharedObject;
    private Object[] theSharedObjectArray;

    public Properties getVehicleSpecificClientProps(Properties p) {
        return new Properties();
    }

    @Override
    public Status run(String[] argv, Properties p) {
        Status status = null;
        boolean inTestHarness = TestUtil.iWhereAreWe == 1;
        TestUtil.logTrace((String)("Check if called from within test process, inTestHarness= " + inTestHarness));
        boolean isVehicleClient = false;
        URL thisURL = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        TestUtil.logTrace((String)("in ServiceEETest.run(), this URL is:  " + thisURL));
        try {
            String sVehicle;
            Class<?> vcClass = this.getClass().getClassLoader().loadClass("com.sun.ts.tests.common.vehicle.VehicleClient");
            URL vcClassURL = vcClass.getProtectionDomain().getCodeSource().getLocation();
            TestUtil.logTrace((String)("VehicleClient URL is:  " + vcClassURL));
            isVehicleClient = vcClass.isAssignableFrom(this.getClass());
            TestUtil.logTrace((String)("VehicleClient class check if is vehicle class =  " + (isVehicleClient ? "yes, is a com.sun.ts.tests.common.vehicle.VehicleClient" : "no, is not com.sun.ts.tests.common.vehicle.VehicleClient class")));
            if (inTestHarness && !isVehicleClient && ("stateless3".equals(sVehicle = TestUtil.getProperty((Properties)p, (String)"vehicle")) || "stateful3".equals(sVehicle) || "appmanaged".equals(sVehicle) || "appmanagedNoTx".equals(sVehicle))) {
                isVehicleClient = true;
                TestUtil.logTrace((String)"Using appclient vehicle so set is vehicle client to true");
            }
        }
        catch (ClassNotFoundException e) {
            TestUtil.logTrace((String)"VehicleClient class not found, so not a vehicle client.");
        }
        if (inTestHarness && isVehicleClient) {
            TestUtil.logTrace((String)"in ServiceEETest.run() method");
            String sVehicle = TestUtil.getProperty((Properties)p, (String)"vehicle");
            String className = this.getClass().getName();
            TestUtil.logTrace((String)("Vehicle to be used for this test is:  " + sVehicle));
            try {
                VehicleRunnable runner = VehicleRunnerFactory.getVehicleRunner(sVehicle);
                p.putAll((Map<?, ?>)this.getVehicleSpecificClientProps(p));
                status = runner.run(argv, p);
            }
            catch (Throwable e) {
                e.printStackTrace();
                return Status.failed("Vehicle runner failed.");
            }
            return status;
        }
        TestUtil.logTrace((String)"in custom vehicle so call on EETest.");
        return super.run(argv, p);
    }

    @Override
    protected Properties getTestPropsFromArgs(String[] argv) {
        Properties p = new Properties();
        Properties ap = new Properties();
        String sProp = null;
        String sVal = null;
        boolean bRunIndividualTest = false;
        this.vLeftOverTestArgs = new Vector();
        if (TestUtil.harnessDebug) {
            TestUtil.logHarnessDebug((String)("ServiceEETest: " + argv.length + " args: " + Arrays.asList(argv).toString()));
        }
        boolean tFound = false;
        String argItem = null;
        for (int ii = 0; ii < argv.length; ++ii) {
            argItem = argv[ii];
            if (argItem.equals("-p") || argItem.equals("-ap")) {
                ap = this.initializeProperties(argv[++ii]);
                Enumeration<?> e = ap.propertyNames();
                String key = null;
                while (e.hasMoreElements()) {
                    key = (String)e.nextElement();
                    p.put(key, ap.getProperty(key));
                }
                continue;
            }
            if (argItem.startsWith("-d") && argItem.indexOf(61) != -1) {
                int equalSign = argItem.indexOf(61);
                sProp = argItem.substring(2, equalSign);
                sVal = argItem.substring(equalSign + 1);
                p.put(sProp, sVal);
                continue;
            }
            if (argItem.equalsIgnoreCase("-t") && !tFound) {
                this.sTestCase = argv[++ii];
                tFound = true;
                bRunIndividualTest = true;
                continue;
            }
            if (argItem.equalsIgnoreCase("-vehicle")) {
                this.sVehicles = new String[1];
                this.sVehicles[0] = argv[++ii];
                continue;
            }
            this.vLeftOverTestArgs.addElement(argItem);
        }
        if (bRunIndividualTest) {
            p.setProperty("testName", this.sTestCase);
        }
        return p;
    }

    @Override
    public Status run(String[] argv, PrintWriter log, PrintWriter err) {
        int ii;
        Status s = Status.passed("OK");
        Properties props = this.getTestPropsFromArgs(argv);
        try {
            String delayseconds = TestUtil.getProperty((Properties)props, (String)"harness.log.delayseconds", (String)"1");
            this.iLogDelaySeconds = Integer.parseInt(delayseconds) * 1000;
        }
        catch (NumberFormatException e) {
            this.iLogDelaySeconds = 1000;
        }
        if (this.sVehicles == null) {
            if (TestUtil.harnessDebug) {
                TestUtil.logHarnessDebug((String)"ServiceEETest.run(): vehicles = null");
            }
            this.sVehicles = this.getVehicles(props);
        }
        if (props.isEmpty()) {
            return Status.failed("FAILED:  An error occurred while trying to load the test properties");
        }
        int iSize = this.vLeftOverTestArgs.size();
        if (iSize == 0) {
            argv = null;
        } else {
            argv = new String[iSize];
            for (ii = 0; ii < iSize; ++ii) {
                argv[ii] = (String)this.vLeftOverTestArgs.elementAt(ii);
            }
        }
        if (this.sTestCase == null) {
            return this.runAllTestCases(argv, props, log, err);
        }
        for (ii = 0; ii < this.sVehicles.length; ++ii) {
            props.put("vehicle", this.sVehicles[ii]);
            TestUtil.setCurrentTest((String)this.sTestCase, (PrintWriter)new PrintWriter((Writer)log, true), (PrintWriter)new PrintWriter((Writer)err, true));
            TestUtil.initClient((Properties)props);
            s = this.getPropsReady(argv, props);
            try {
                Thread.sleep(this.iLogDelaySeconds);
                TestUtil.logTrace((String)("SLEPT FOR:  " + this.iLogDelaySeconds));
                continue;
            }
            catch (InterruptedException e) {
                this.logErr("Exception: " + e);
            }
        }
        return s;
    }

    protected Status runAllTestCases(String[] argv, Properties p, PrintStream log, PrintStream err) {
        if (this.sVehicles == null) {
            if (TestUtil.harnessDebug) {
                TestUtil.logHarnessDebug((String)"ServiceEETest.runAllTestCases(): vehicles = null");
            }
            this.sVehicles = this.getVehicles(p);
        }
        Status s = Status.passed("OK");
        for (int ii = 0; ii < this.sVehicles.length; ++ii) {
            p.put("vehicle", this.sVehicles[ii]);
            s = super.runAllTestCases(argv, p, new PrintWriter(log, true), new PrintWriter(err, true));
            log.println("Completed running tests in " + this.sVehicles[ii] + " vehicle.");
        }
        return s;
    }

    private String[] getVehicles(Properties p) {
        String[] sReturn = null;
        String sVal = null;
        String sVehiclesToUse = null;
        StringTokenizer st = null;
        try {
            sVal = TestUtil.getProperty((Properties)p, (String)"service_eetest.vehicles");
        }
        catch (Exception e) {
            sVal = "";
            sVal = "ejb servlet jsp";
        }
        if (sVal == null || sVal.equals("")) {
            sVehiclesToUse = "ejb servlet jsp";
            if (TestUtil.harnessDebug) {
                TestUtil.logHarnessDebug((String)"getVehicles:  Using default - all vehicles");
            }
        } else {
            sVehiclesToUse = sVal;
            if (TestUtil.harnessDebug) {
                TestUtil.logHarnessDebug((String)("getVehicles: using vehicle(s) - " + sVehiclesToUse));
            }
        }
        st = new StringTokenizer(sVehiclesToUse);
        int iCount = st.countTokens();
        sReturn = new String[iCount];
        for (int ii = 0; ii < iCount; ++ii) {
            sReturn[ii] = st.nextToken().trim();
        }
        return sReturn;
    }

    public void setSharedObject(Object o) {
        this.theSharedObject = o;
    }

    public Object getSharedObject() {
        return this.theSharedObject;
    }
}

