/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.lib.harness;

import com.sun.ts.lib.util.ConfigUtil;
import com.sun.ts.lib.util.TestUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Properties;

public class VehicleVerifier {
    public static final String VEHICLE_PROP_FILE_NAME = "vehicle.properties";
    public static final String EXCLUDE_KEY = "exclude.dir";
    private static Properties mapping;
    private static String[] keys;
    private static String[] excludes;
    private String relativeTestDir;
    private String testName;
    private static boolean loaded;
    private static VehicleVerifier instance;

    private VehicleVerifier() {
    }

    public static VehicleVerifier getInstance(File path) {
        if (instance == null) {
            instance = new VehicleVerifier();
        }
        instance.init(path, null);
        return instance;
    }

    public static VehicleVerifier getInstance(File path, String sTestName) {
        if (instance == null) {
            instance = new VehicleVerifier();
        }
        instance.init(path, sTestName);
        return instance;
    }

    private void loadExcludes() {
        excludes = mapping == null ? TestUtil.EMPTY_STRING_ARRAY : ConfigUtil.stringToArray((String)((String)mapping.remove(EXCLUDE_KEY)));
    }

    private void init(File file, String sTest) {
        if (!loaded) {
            mapping = ConfigUtil.loadPropertiesFor((String)VEHICLE_PROP_FILE_NAME);
            this.loadExcludes();
            keys = ConfigUtil.loadKeysFrom((Properties)mapping);
            loaded = true;
        }
        this.testName = sTest;
        if (mapping != null) {
            this.relativeTestDir = TestUtil.getRelativePath((String)file.getPath());
            if (this.testName != null) {
                this.relativeTestDir = this.relativeTestDir + "#" + this.testName;
                TestUtil.logHarnessDebug((String)("VehicleVerifier.init:  relative dir = " + this.relativeTestDir));
            }
        }
    }

    private boolean isExcluded() {
        for (int i = 0; i < excludes.length; ++i) {
            if (!this.relativeTestDir.startsWith(excludes[i])) continue;
            TestUtil.logHarnessDebug((String)"VehicleVerifier:  This test dir is excluded from those listed in vehicle.properties.");
            TestUtil.logHarnessDebug((String)"VehicleVerifier:  Please check your exclude list in the vehicle.properties file.");
            return true;
        }
        return false;
    }

    public String[] getVehicleSet() {
        if (mapping == null || keys == null) {
            return TestUtil.EMPTY_STRING_ARRAY;
        }
        if (this.isExcluded()) {
            return TestUtil.EMPTY_STRING_ARRAY;
        }
        String[] result = ConfigUtil.getMappingValue((Properties)mapping, (String[])keys, (String)this.relativeTestDir);
        return result;
    }

    public static void main(String[] args) {
        File testDir = null;
        testDir = args.length == 0 ? new File(System.getProperty("user.dir")) : new File(args[0]);
        VehicleVerifier ver = VehicleVerifier.getInstance(testDir);
        String[] result = ver.getVehicleSet();
        System.out.println(testDir.getPath() + " : " + Arrays.asList(result).toString());
    }

    static {
        instance = new VehicleVerifier();
    }
}

