/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.ejb.dba;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.ejb.dba.CompoundPK;
import com.sun.ts.tests.common.ejb.dba.DBSupport;
import jakarta.ejb.CreateException;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;

public class CompoundDBSupport
extends DBSupport
implements Serializable {
    protected static final String compoundTablePrefix = "compoundPKTable";
    PreparedStatement pStmt = null;
    ResultSet result = null;
    protected CompoundPK cofID = null;
    protected String cofName = null;
    protected float cofPrice = 0.0f;

    public CompoundDBSupport() throws Exception {
        super(compoundTablePrefix);
    }

    public static void initTable(Properties props) throws Exception {
        DBSupport.initTable(compoundTablePrefix, props);
    }

    public boolean keyExists(CompoundPK pkey) throws SQLException {
        try {
            TestUtil.logTrace((String)("[CompoundDBSupport] keyExists(" + pkey + ")"));
            this.getDBConnection();
            this.pStmt = this.getStmt("Select_PK");
            this.pStmt.setInt(1, pkey.pmIDInteger);
            this.pStmt.setString(2, pkey.pmIDString);
            this.pStmt.setFloat(3, pkey.pmIDFloat.floatValue());
            this.result = this.pStmt.executeQuery();
            boolean bl = this.result.next();
            return bl;
        }
        catch (SQLException e) {
            throw new SQLException("SQL Exception in keyExists:" + e);
        }
        finally {
            this.closeStmt(this.pStmt, this.result);
        }
    }

    public void createNewRow(CompoundPK cofID, String cofName, float cofPrice) throws CreateException, SQLException {
        try {
            TestUtil.logTrace((String)("[CompoundDBSupport] createNewRow(" + cofID + ", " + cofName + ", " + cofPrice + ")"));
            this.pStmt = this.getStmt("Insert");
            this.pStmt.setInt(1, cofID.pmIDInteger);
            this.pStmt.setString(2, cofID.pmIDString);
            this.pStmt.setFloat(3, cofID.pmIDFloat.floatValue());
            this.pStmt.setString(4, cofName);
            this.pStmt.setFloat(5, cofPrice);
            TestUtil.logTrace((String)("[CompoundDBSupport] Execute stmt" + this.pStmt));
            if (1 != this.pStmt.executeUpdate()) {
                throw new CreateException("INSERT failed in createNewRow");
            }
            this.cofID = cofID;
            this.cofName = cofName;
            this.cofPrice = cofPrice;
        }
        catch (SQLException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new SQLException("SQL Exception in createNewRow" + e);
        }
        finally {
            this.closeStmt(this.pStmt, null);
        }
        TestUtil.logTrace((String)"[CompoundDBSupport] New row created !");
    }

    public float loadPrice(CompoundPK pkey) throws SQLException {
        try {
            TestUtil.logTrace((String)("[CompoundDBSupport] loadPrice(" + pkey + ")"));
            this.pStmt = this.getStmt("Select_Price");
            this.pStmt.setInt(1, pkey.pmIDInteger);
            this.pStmt.setString(2, pkey.pmIDString);
            this.pStmt.setFloat(3, pkey.pmIDFloat.floatValue());
            this.result = this.pStmt.executeQuery();
            if (!this.result.next()) {
                throw new SQLException("No record for PK = " + pkey);
            }
            float f = this.result.getFloat(1);
            return f;
        }
        catch (SQLException e) {
            throw new SQLException("SQLException in loadPrice(): " + e);
        }
        finally {
            this.closeStmt(this.pStmt, this.result);
        }
    }

    public void storePrice(CompoundPK pkey, float cofPrice) throws SQLException {
        try {
            TestUtil.logTrace((String)"[CompoundDBSupport] storePrice()");
            this.pStmt = this.getStmt("Update");
            this.pStmt.setFloat(1, cofPrice);
            this.pStmt.setInt(2, pkey.pmIDInteger);
            this.pStmt.setString(3, pkey.pmIDString);
            this.pStmt.setFloat(4, pkey.pmIDFloat.floatValue());
            if (1 != this.pStmt.executeUpdate()) {
                throw new SQLException("SQL UPDATE failed in storePrice");
            }
            this.cofPrice = cofPrice;
        }
        catch (SQLException e) {
            throw new SQLException("SQL Exception in storePrice(): " + e);
        }
        finally {
            this.closeStmt(this.pStmt, null);
        }
    }

    public void removeRow(CompoundPK pkey) throws SQLException {
        try {
            TestUtil.logTrace((String)"[CompoundDBSupport] removeRow()");
            this.pStmt = this.getStmt("Delete");
            this.pStmt.setInt(1, pkey.pmIDInteger);
            this.pStmt.setString(2, pkey.pmIDString);
            this.pStmt.setFloat(3, pkey.pmIDFloat.floatValue());
            if (1 != this.pStmt.executeUpdate()) {
                throw new SQLException("DELETE failed in removeRow");
            }
        }
        catch (SQLException e) {
            throw new SQLException("SQL Exception in removeRow(): " + e);
        }
        finally {
            this.closeStmt(this.pStmt, null);
        }
    }
}

