/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.ejb.dba;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.ejb.dba.DBSupport;
import jakarta.ejb.CreateException;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;

public class LongDBSupport
extends DBSupport
implements Serializable {
    protected static final String longTablePrefix = "longPKTable";
    PreparedStatement pStmt = null;
    ResultSet result = null;
    protected long cofID = 0L;
    protected String cofName = null;
    protected float cofPrice = 0.0f;

    public LongDBSupport() throws Exception {
        super(longTablePrefix);
    }

    public static void initTable(Properties props) throws Exception {
        DBSupport.initTable(longTablePrefix, props);
    }

    public boolean keyExists(long pkey) throws SQLException {
        try {
            TestUtil.logTrace((String)("[LongDBSupport] keyExists(" + pkey + ")"));
            this.getDBConnection();
            this.pStmt = this.getStmt("Select_PK");
            this.pStmt.setLong(1, pkey);
            this.result = this.pStmt.executeQuery();
            boolean bl = this.result.next();
            return bl;
        }
        catch (SQLException e) {
            throw new SQLException("SQLException in keyExists: " + e);
        }
        finally {
            this.closeStmt(this.pStmt, this.result);
        }
    }

    public void createNewRow(long cofID, String cofName, float cofPrice) throws CreateException, SQLException {
        try {
            TestUtil.logTrace((String)("[LongDBSupport] createNewRow(" + cofID + ", " + cofName + ", " + cofPrice + ")"));
            this.pStmt = this.getStmt("Insert");
            this.pStmt.setLong(1, cofID);
            this.pStmt.setString(2, cofName);
            this.pStmt.setFloat(3, cofPrice);
            TestUtil.logTrace((String)("[LongDBSupport] Execute stmt" + this.pStmt));
            if (1 != this.pStmt.executeUpdate()) {
                throw new CreateException("INSERT failed in createNewRow");
            }
            this.cofID = cofID;
            this.cofName = cofName;
            this.cofPrice = cofPrice;
        }
        catch (SQLException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new SQLException("SQLException in createNewRow" + e);
        }
        finally {
            this.closeStmt(this.pStmt, null);
        }
        TestUtil.logTrace((String)"[LongDBSupport] New row created !");
    }

    public float loadPrice(long pkey) throws SQLException {
        try {
            TestUtil.logTrace((String)("[LongDBSupport] loadPrice(" + pkey + ")"));
            this.pStmt = this.getStmt("Select_Price");
            this.pStmt.setLong(1, pkey);
            this.result = this.pStmt.executeQuery();
            if (!this.result.next()) {
                throw new SQLException("No record for PK = " + pkey);
            }
            float f = this.result.getFloat(1);
            return f;
        }
        catch (SQLException e) {
            throw new SQLException("SQLException in loadPrice(): " + e);
        }
        finally {
            this.closeStmt(this.pStmt, this.result);
        }
    }

    public void storePrice(long pkey, float cofPrice) throws SQLException {
        try {
            TestUtil.logTrace((String)"[LongDBSupport] storePrice()");
            this.pStmt = this.getStmt("Update");
            this.pStmt.setFloat(1, cofPrice);
            this.pStmt.setLong(2, pkey);
            if (1 != this.pStmt.executeUpdate()) {
                throw new SQLException("UPDATE failed in storePrice");
            }
            this.cofPrice = cofPrice;
        }
        catch (SQLException e) {
            throw new SQLException("SQLException in storePrice(): " + e);
        }
        finally {
            this.closeStmt(this.pStmt, null);
        }
    }

    public void removeRow(long pkey) throws SQLException {
        try {
            TestUtil.logTrace((String)"[LongDBSupport] removeRow()");
            this.pStmt = this.getStmt("Delete");
            this.pStmt.setLong(1, pkey);
            if (1 != this.pStmt.executeUpdate()) {
                throw new SQLException("DELETE failed in removeRow");
            }
        }
        catch (SQLException e) {
            throw new SQLException("SQLException in removeRow(): " + e);
        }
        finally {
            this.closeStmt(this.pStmt, null);
        }
    }
}

