/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.jspservletsec;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.webclient.BaseUrlClient;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecBasicClient
extends BaseUrlClient {
    private static final Logger lOGGER = LoggerFactory.getLogger(SecBasicClient.class);
    private static final String USERNAME = "user";
    private static final String PASSWORD = "password";
    private static final String UNAUTH_USERNAME = "authuser";
    private static final String UNAUTH_PASSWORD = "authpassword";
    private static final String CLASS_TRACE_HEADER = "[SecBasicClient]: ";
    private static final String USER_PRINCIPAL_SEARCH = "The user principal is: ";
    private static final String REMOTE_USER_SEARCH = "getRemoteUser(): ";
    protected String pageSec = null;
    protected String pageGuest = null;
    protected String pageUnprotected = null;
    protected String pageRoleReverse = null;
    private String pageJspBase = "/jsp_sec_secbasic_web";
    private String pageJspSec = this.pageJspBase + "/jspSec.jsp";
    private String pageJspGuest = this.pageJspBase + "/guestPage.jsp";
    private String pageJspUnprotected = this.pageJspBase + "/unprotected.jsp";
    private String pageJspRoleReverse = this.pageJspBase + "/rolereverse.jsp";
    private String pageServletBase = "/servlet_sec_secbasic_web";
    private String pageServletSec = this.pageServletBase + "/ServletSecTest";
    private String pageServletGuest = this.pageServletBase + "/GuestPageTest";
    private String pageServletUnprotected = this.pageServletBase + "/UnProtectedTest";
    private String pageServletRoleReverse = this.pageServletBase + "/RoleReverseTest";
    private String username = null;
    private String password = null;
    private String unauthUsername = null;
    private String unauthPassword = null;

    @Override
    public void setup(String[] args, Properties p) throws Exception {
        super.setup(args, p);
        try {
            this.username = TestUtil.getProperty((Properties)p, (String)USERNAME);
            this.password = TestUtil.getProperty((Properties)p, (String)PASSWORD);
            this.unauthUsername = TestUtil.getProperty((Properties)p, (String)UNAUTH_USERNAME);
            this.unauthPassword = TestUtil.getProperty((Properties)p, (String)UNAUTH_PASSWORD);
            if (args[0].equals("jsp")) {
                this.pageSec = this.pageJspSec;
                this.pageGuest = this.pageJspGuest;
                this.pageUnprotected = this.pageJspUnprotected;
                this.pageRoleReverse = this.pageJspRoleReverse;
            } else {
                this.pageSec = this.pageServletSec;
                this.pageGuest = this.pageServletGuest;
                this.pageUnprotected = this.pageServletUnprotected;
                this.pageRoleReverse = this.pageServletRoleReverse;
            }
        }
        catch (Exception e) {
            lOGGER.error("Error: got exception: ", (Throwable)e);
        }
    }

    public void test1() throws Exception {
        SecBasicClient.logMessage("Sending request to validate presence of www-authenticate header...");
        TEST_PROPS.setProperty("testname", "SecBasic/Test1");
        TEST_PROPS.setProperty("request", SecBasicClient.getRequestLine("GET", this.pageSec));
        TEST_PROPS.setProperty("expected_headers", "www-authenticate:<somevalue>");
        TEST_PROPS.setProperty("status-code", "401");
        this.invoke();
        this.dumpResponse();
        SecBasicClient.logMessage("Authentication requested");
    }

    public void test2() throws Exception {
        SecBasicClient.logMessage("Sending request with Authroization header...");
        StringBuffer sb = new StringBuffer(100);
        sb.append(USER_PRINCIPAL_SEARCH).append(this.username).append("|");
        sb.append(REMOTE_USER_SEARCH).append(this.username).append("|");
        sb.append("isUserInRole(\"ADM\"): !true!").append("|");
        sb.append("isUserInRole(\"MGR\"): !false!").append("|");
        sb.append("isUserInRole(\"VP\"): !false!").append("|");
        sb.append("isUserInRole(\"EMP\"): !true!").append("|");
        TEST_PROPS.setProperty("testname", "SecBasic/Test2");
        TEST_PROPS.setProperty("request", SecBasicClient.getRequestLine("GET", this.pageSec));
        TEST_PROPS.setProperty("basic_auth_user", this.username);
        TEST_PROPS.setProperty("basic_auth_passwd", this.password);
        TEST_PROPS.setProperty("search_string", sb.toString());
        this.invoke();
        this.dumpResponse();
        SecBasicClient.logMessage("isUserInRole() and getRemoteUser() returned expected results");
    }

    public void test3() throws Exception {
        SecBasicClient.logMessage("Sending an request for a protected resource with invalid username/password...");
        TEST_PROPS.setProperty("testname", "SecBasic/Test3");
        TEST_PROPS.setProperty("request", SecBasicClient.getRequestLine("GET", this.pageSec));
        TEST_PROPS.setProperty("basic_auth_user", "invalid");
        TEST_PROPS.setProperty("basic_auth_passwd", this.password);
        TEST_PROPS.setProperty("status-code", "401");
        this.invoke();
        this.dumpResponse();
        SecBasicClient.logMessage("Access Denied");
    }

    public void test4() throws Exception {
        StringBuffer sb = new StringBuffer(100);
        sb.append(USER_PRINCIPAL_SEARCH).append(this.unauthUsername);
        SecBasicClient.logMessage("Sending request to resource the user has access to...");
        TEST_PROPS.setProperty("testname", "SecBasic/Test4");
        TEST_PROPS.setProperty("request", SecBasicClient.getRequestLine("GET", this.pageGuest));
        TEST_PROPS.setProperty("basic_auth_user", this.unauthUsername);
        TEST_PROPS.setProperty("basic_auth_passwd", this.unauthPassword);
        TEST_PROPS.setProperty("search_string", sb.toString());
        this.invoke();
        this.dumpResponse();
        SecBasicClient.logMessage("User successfully accessed the resource");
        SecBasicClient.logMessage("Sending request to resource with valid username/password, but not the right roles...");
        TEST_PROPS.setProperty("testname", "SecBasic/Test4");
        TEST_PROPS.setProperty("request", SecBasicClient.getRequestLine("GET", this.pageSec));
        TEST_PROPS.setProperty("basic_auth_user", this.unauthUsername);
        TEST_PROPS.setProperty("basic_auth_passwd", this.unauthPassword);
        TEST_PROPS.setProperty("status-code", "403");
        this.invoke();
        this.dumpResponse();
        SecBasicClient.logMessage("Access Forbidden");
    }

    public void test5() throws Exception {
        StringBuffer sb = new StringBuffer(100);
        sb.append(USER_PRINCIPAL_SEARCH).append("|");
        sb.append(REMOTE_USER_SEARCH).append("null");
        SecBasicClient.logMessage("Sending request to unprotected resource....");
        TEST_PROPS.setProperty("testname", "BasicSec/Test5");
        TEST_PROPS.setProperty("request", SecBasicClient.getRequestLine("GET", this.pageUnprotected));
        TEST_PROPS.setProperty("search_string", sb.toString());
        TEST_PROPS.setProperty("unexpected_response_match", "!true!");
        this.invoke();
        this.dumpResponse();
        SecBasicClient.logMessage("isUserInRole() and getRemoteUser() returned expected results");
    }

    public void test6() throws Exception {
        StringBuffer sb = new StringBuffer(100);
        sb.append(USER_PRINCIPAL_SEARCH).append(this.username).append("|");
        sb.append("isUserInRole(\"ADM\"): !false!").append("|");
        sb.append("isUserInRole(\"MGR\"): !true!").append("|");
        sb.append("isUserInRole(\"VP\"): !false!").append("|");
        sb.append("isUserInRole(\"EMP\"): !true!").append("|");
        SecBasicClient.logMessage("Sending request to validate isUserInRole with roles reversed...");
        TEST_PROPS.setProperty("testname", "SecBasic/Test6");
        TEST_PROPS.setProperty("request", SecBasicClient.getRequestLine("GET", this.pageRoleReverse));
        TEST_PROPS.setProperty("basic_auth_user", this.username);
        TEST_PROPS.setProperty("basic_auth_passwd", this.password);
        TEST_PROPS.setProperty("search_string", sb.toString());
        this.invoke();
        this.dumpResponse();
        SecBasicClient.logMessage("isUserInRole() and getRemoteUser() returned expected results");
    }

    public void test7() throws Exception {
        SecBasicClient.logMessage("Sending an request for a protected resource with invalid username/password...");
        TEST_PROPS.setProperty("testname", "SecBasic/Test7");
        TEST_PROPS.setProperty("request", SecBasicClient.getRequestLine("GET", this.pageSec + "/j_security_check"));
        TEST_PROPS.setProperty("basic_auth_user", "invalid");
        TEST_PROPS.setProperty("basic_auth_passwd", this.password);
        TEST_PROPS.setProperty("status-code", "401,404");
        this.invoke();
        this.dumpResponse();
        if (this._testCase != null && this._testCase.getResponse() != null) {
            String searchString = "Inside  ServletSecTestServlet";
            try {
                if (this._testCase.getResponse().getResponseBodyAsString().indexOf(searchString) != -1) {
                    TestUtil.logErr((String)("(Should say: \"" + searchString + "\")"));
                    throw new Exception("test7 failed.");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        SecBasicClient.logMessage("Access properly Denied");
    }

    private static String getRequestLine(String method, String path) {
        return method + " " + path + " HTTP/1.1";
    }

    private static void logMessage(String message) {
        TestUtil.logMsg((String)(CLASS_TRACE_HEADER + message));
    }

    private static void trace(String message) {
        TestUtil.logTrace((String)(CLASS_TRACE_HEADER + message));
    }

    private void dumpResponse() {
        try {
            if (this._testCase != null && this._testCase.getResponse() != null) {
                SecBasicClient.trace(this._testCase.getResponse().getResponseBodyAsString());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

