/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.vehicle.ejb;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.RemoteStatus;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import jakarta.ejb.EJBException;
import java.util.Properties;

public class EJBVehicle {
    private EETest testObj;
    private Properties properties;
    private String[] arguments;

    public void initialize(String[] args, Properties p) {
        try {
            TestUtil.init((Properties)p);
        }
        catch (Exception e) {
            TestUtil.logErr((String)"initLogging failed in ejb vehicle.", (Throwable)e);
            throw new EJBException();
        }
        this.arguments = args;
        this.properties = p;
        try {
            String testClassName = TestUtil.getProperty((Properties)this.properties, (String)"test_classname");
            Class<?> c = Class.forName(testClassName);
            this.testObj = (EETest)c.newInstance();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Failed to create the EETest instance in the vehicle", (Throwable)e);
            throw new EJBException();
        }
        TestUtil.logTrace((String)"initialize");
    }

    public RemoteStatus runTest() {
        RemoteStatus sTestStatus = new RemoteStatus(Status.passed(""));
        TestUtil.logTrace((String)"in runTest()");
        try {
            sTestStatus = new RemoteStatus(this.testObj.run(this.arguments, this.properties));
            if (sTestStatus.getType() == 0) {
                TestUtil.logMsg((String)"Test running in ejb vehicle passed");
            } else {
                TestUtil.logMsg((String)"Test running in ejb vehicle failed");
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            TestUtil.logErr((String)"Test running in ejb vehicle failed", (Throwable)e);
            sTestStatus = new RemoteStatus(Status.failed("Test running in ejb vehicle failed"));
        }
        return sTestStatus;
    }
}

