/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.vehicle.ejb3share;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.RemoteStatus;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.vehicle.ejb3share.EJB3ShareIF;
import com.sun.ts.tests.common.vehicle.ejb3share.UseEntityManager;
import com.sun.ts.tests.common.vehicle.ejb3share.UseEntityManagerFactory;
import jakarta.ejb.SessionContext;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityTransaction;
import java.util.Properties;

public abstract class EJB3ShareBaseBean
implements EJB3ShareIF {
    public static final String FINDER_TEST_NAME_KEY = "testName";
    public static final String STATELESS3 = "stateless3";
    public static final String STATEFUL3 = "stateful3";
    public static final String APPMANAGED = "appmanaged";
    public static final String APPMANAGEDNOTX = "appmanagedNoTx";
    protected EntityManager entityManager;
    protected EntityManagerFactory entityManagerFactory;
    protected SessionContext sessionContext;

    protected abstract String getVehicleType();

    protected EJB3ShareBaseBean() {
    }

    @Override
    public RemoteStatus runTest(String[] args, Properties props) {
        try {
            TestUtil.init((Properties)props);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("initLogging failed in " + this.getVehicleType() + " vehicle."), (Throwable)e);
        }
        String testName = this.getTestName(props);
        System.out.println("===== Starting " + testName + " in " + this.getVehicleType() + " =====");
        RemoteStatus sTestStatus = null;
        try {
            String testClassName = TestUtil.getProperty((Properties)props, (String)"test_classname");
            Class<?> c = Class.forName(testClassName);
            EETest testClient = (EETest)c.newInstance();
            this.initClient(testClient);
            sTestStatus = new RemoteStatus(testClient.run(args, props));
            if (sTestStatus.getType() == 0) {
                TestUtil.logMsg((String)(testName + " in vehicle passed"));
            }
        }
        catch (Throwable e) {
            String fail = testName + " in vehicle failed";
            TestUtil.logErr((String)fail, (Throwable)e);
            sTestStatus = new RemoteStatus(Status.failed(fail));
        }
        return sTestStatus;
    }

    protected String getTestName(Properties props) {
        String testName = TestUtil.getProperty((Properties)props, (String)FINDER_TEST_NAME_KEY);
        if (testName == null) {
            testName = "test";
        }
        return testName;
    }

    private void initClient(EETest testClient) {
        EntityManagerFactory emf;
        Object client2;
        if (testClient instanceof UseEntityManager) {
            EntityManager em = this.getEntityManager();
            if (em == null) {
                throw new IllegalStateException("EntityManager is null");
            }
            client2 = (UseEntityManager)((Object)testClient);
            EntityTransaction et = this.getEntityTransaction();
            client2.setEntityManager(em);
            client2.setEntityTransaction(et);
            client2.setInContainer(true);
        }
        if (testClient instanceof UseEntityManagerFactory && (emf = this.getEntityManagerFactory()) != null) {
            client2 = (UseEntityManagerFactory)((Object)testClient);
            client2.setEntityManagerFactory(emf);
        }
    }

    public SessionContext getSessionContext() {
        return this.sessionContext;
    }

    public abstract void setSessionContext(SessionContext var1);

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public void setEntityManagerFactory(EntityManagerFactory emf) {
    }

    protected abstract EntityTransaction getEntityTransaction();

    public abstract void setEntityManager(EntityManager var1);
}

