/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.common;

import com.sun.ts.lib.util.TestUtil;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.TextMessage;
import java.util.Enumeration;
import java.util.Properties;

public final class JmsUtil {
    public static boolean test1SecondTime = false;
    public static boolean test2SecondTime = false;
    public static boolean test2Results = false;
    public static boolean test7SecondTime = false;
    private static String cHost = null;
    private static String cTrace = null;
    private static String cPort = null;
    private static String hHost = null;
    private static String hTrace = null;
    private static String hPort = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void addPropsToMessage(Message msg, Properties p) {
        String hostname = null;
        String traceFlag = null;
        String logPort = null;
        Enumeration<?> e = null;
        String key = null;
        String notValid = ".";
        try {
            hostname = TestUtil.getProperty((Properties)p, (String)"harness.host");
            TestUtil.logTrace((String)("Hostname " + hostname));
            if (hostname == null) {
                if (hHost == null) {
                    TestUtil.logTrace((String)"addPropsToMsg: Hostname is null");
                    throw new Exception("Error getting hostname");
                }
                msg.setStringProperty("harnesshost", hHost);
            } else {
                msg.setStringProperty("harnesshost", hostname);
                hHost = hostname;
            }
            traceFlag = TestUtil.getProperty((Properties)p, (String)"harness.log.traceflag");
            TestUtil.logTrace((String)("testFlag  " + traceFlag));
            if (traceFlag == null) {
                if (hTrace == null) {
                    TestUtil.logTrace((String)"addProps:traceflag is null");
                    throw new Exception("Error getting traceflag");
                }
                msg.setStringProperty("harnesslogtraceflag", hTrace);
            } else {
                msg.setStringProperty("harnesslogtraceflag", traceFlag);
                hTrace = traceFlag;
            }
            logPort = TestUtil.getProperty((Properties)p, (String)"harness.log.port");
            TestUtil.logTrace((String)("logPort  " + logPort));
            if (logPort == null) {
                if (hPort == null) {
                    TestUtil.logTrace((String)"addProps: logport is null");
                    throw new Exception("Error getting port");
                }
                msg.setStringProperty("harnesslogport", hPort);
            } else {
                msg.setStringProperty("harnesslogport", logPort);
                hPort = logPort;
            }
            e = p.propertyNames();
            key = null;
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                TestUtil.logTrace((String)("addProps: " + key));
                if (key.indexOf(notValid) != -1 || key.indexOf("***") != -1 || key.startsWith("JMS")) continue;
                TestUtil.logTrace((String)("addProps: add property " + key));
                msg.setStringProperty(key, TestUtil.getProperty((Properties)p, (String)key));
            }
            return;
        }
        catch (Exception ex) {
            TestUtil.printStackTrace((Throwable)ex);
            TestUtil.logMsg((String)"Error setting harness Properties in jms msg");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initHarnessProps(Message msg, Properties p) {
        String hostname = null;
        String traceflag = null;
        String logport = null;
        try {
            hostname = msg.getStringProperty("harnesshost");
            TestUtil.logTrace((String)("initHarn: Hostname " + hostname));
            if (hostname == null) {
                TestUtil.logTrace((String)"intiHarn:Hostname is null");
                if (cHost == null) throw new Exception("Error getting hostname");
                p.put("harness.host", cHost);
            } else {
                p.put("harness.host", hostname);
                cHost = hostname;
            }
            traceflag = msg.getStringProperty("harnesslogtraceflag");
            TestUtil.logTrace((String)("initHarn:traceflag " + traceflag));
            if (traceflag == null) {
                TestUtil.logTrace((String)"initHarn: is null");
                if (cTrace == null) throw new Exception("Error getting traceflag");
                p.put("harness.log.traceflag", cTrace);
            } else {
                p.put("harness.log.traceflag", traceflag);
                cTrace = traceflag;
            }
            logport = msg.getStringProperty("harnesslogport");
            TestUtil.logTrace((String)("initHarn:logport " + logport));
            if (logport == null) {
                TestUtil.logTrace((String)"initHarn:logport is null");
                if (cPort == null) throw new Exception("Error getting port");
                p.put("harness.log.port", cPort);
            } else {
                p.put("harness.log.port", logport);
                cPort = logport;
            }
            Enumeration e = msg.getPropertyNames();
            String key = null;
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                if (key.startsWith("JMS")) continue;
                p.put(key, msg.getStringProperty(key));
            }
            TestUtil.init((Properties)p);
            return;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public static void sendTestResults(String testCase, boolean results, QueueSession qSession, Queue queueR) {
        TextMessage msg = null;
        QueueSender mSender = null;
        TestUtil.logTrace((String)"*@$#)@(@#$ --- - -   sendTestResults ");
        try {
            mSender = qSession.createSender(queueR);
            msg = qSession.createTextMessage();
            msg.setStringProperty("TestCase", testCase);
            msg.setText(testCase);
            if (results) {
                msg.setStringProperty("Status", "Pass");
            } else {
                msg.setStringProperty("Status", "Fail");
            }
            TestUtil.logTrace((String)"*@$#)@(@$#@($----Sending response message ");
            TestUtil.logTrace((String)("*@$#)@(@ ----- status: " + msg.getStringProperty("Status")));
            TestUtil.logTrace((String)("*@$#)@(@# -----test: " + msg.getStringProperty("TestCase")));
            mSender.send((Message)msg);
        }
        catch (JMSException je) {
            TestUtil.printStackTrace((Throwable)je);
        }
        catch (Exception ee) {
            TestUtil.printStackTrace((Throwable)ee);
        }
    }
}

