/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.commonee;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsUtil;
import com.sun.ts.tests.jms.commonee.MDB_Q_Test;
import jakarta.annotation.Resource;
import jakarta.ejb.EJBException;
import jakarta.ejb.PostActivate;
import jakarta.ejb.PrePassivate;
import jakarta.ejb.Remote;
import jakarta.ejb.Remove;
import jakarta.ejb.SessionContext;
import jakarta.ejb.Stateful;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.TextMessage;
import java.util.Enumeration;
import java.util.Properties;

@Stateful
@Remote(value={MDB_Q_Test.class})
public class MDB_Q_TestEJB
implements MDB_Q_Test {
    @Resource
    private SessionContext sessionContext;
    private Properties p = null;
    @Resource(name="jms/MDB_QUEUE_REPLY")
    private transient Queue rcvrQueue;
    @Resource(name="jms/MDB_QUEUE")
    private transient Queue q;
    @Resource(name="jms/MyQueueConnectionFactory")
    private transient QueueConnectionFactory qFactory;
    private transient QueueConnection qConnect;
    private String jmsUser;
    private String jmsPassword;
    private long timeout;

    @Override
    public void setup(Properties props) {
        TestUtil.logTrace((String)"MDB_Q_TestEJB.setup()");
        this.p = props;
        try {
            TestUtil.init((Properties)props);
            this.timeout = Long.parseLong(TestUtil.getProperty((Properties)props, (String)"jms_timeout"));
            this.jmsUser = TestUtil.getProperty((Properties)props, (String)"user");
            this.jmsPassword = TestUtil.getProperty((Properties)props, (String)"password");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.jmsUser == null) {
                throw new Exception("'user' in ts.jte must be null");
            }
            if (this.jmsPassword == null) {
                throw new Exception("'password' in ts.jte must be null");
            }
            if (this.qFactory == null || this.q == null | this.rcvrQueue == null || this.sessionContext == null) {
                throw new Exception("@Resource injection failed");
            }
        }
        catch (Exception e) {
            throw new EJBException("@setup failed: ", e);
        }
    }

    @Override
    public boolean askMDBToRunATest(String typeOfTest) {
        TestUtil.logTrace((String)"MDB_Q_TestEJB.askMDBToRunATest()");
        boolean ok = true;
        String myMessage = "Sending a message to mdb";
        try {
            this.qConnect = this.qFactory.createQueueConnection(this.jmsUser, this.jmsPassword);
            QueueSession session = this.qConnect.createQueueSession(true, 0);
            this.qConnect.start();
            QueueSender qSender = session.createSender(this.q);
            TextMessage msg = session.createTextMessage();
            JmsUtil.addPropsToMessage((Message)msg, this.p);
            msg.setText(myMessage);
            msg.setStringProperty("TestCase", typeOfTest);
            qSender.send((Message)msg);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("askMDBToRunATest: Error!", e);
        }
        finally {
            try {
                if (this.qConnect != null) {
                    this.qConnect.close();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error closing QueueConnection", (Throwable)e);
            }
        }
        return ok;
    }

    @Override
    public boolean askMDBToSendAMessage(String typeOfMessage) {
        TestUtil.logTrace((String)"MDB_Q_TestEJB.askMDBToSendAMessage()");
        boolean ok = true;
        String myMessage = "I want you to send a message";
        try {
            this.qConnect = this.qFactory.createQueueConnection(this.jmsUser, this.jmsPassword);
            QueueSession session = this.qConnect.createQueueSession(true, 0);
            this.qConnect.start();
            QueueSender qSender = session.createSender(this.q);
            TestUtil.logTrace((String)("got a q sender for: " + qSender.getQueue().getQueueName()));
            TextMessage msg = session.createTextMessage();
            JmsUtil.addPropsToMessage((Message)msg, this.p);
            msg.setText(myMessage);
            msg.setStringProperty("MessageType", typeOfMessage);
            qSender.send((Message)msg);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("@askMDBToSendAMessage: Error!", e);
        }
        finally {
            try {
                if (this.qConnect != null) {
                    this.qConnect.close();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error closing connection in askMDBToSendAMessage", (Throwable)e);
            }
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkOnResponse(String prop) {
        boolean status = false;
        try {
            TestUtil.logTrace((String)"MDB_Q_TestEJB.checkOnResponse()");
            this.qConnect = this.qFactory.createQueueConnection(this.jmsUser, this.jmsPassword);
            QueueSession session = this.qConnect.createQueueSession(true, 0);
            this.qConnect.start();
            status = this.recvMessageInternal(session, prop);
            TestUtil.logTrace((String)"Close the session");
            session.close();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Error in checkOnResponse", (Throwable)e);
        }
        finally {
            try {
                if (this.qConnect != null) {
                    this.qConnect.close();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error closing QueueConnection", (Throwable)e);
            }
        }
        return status;
    }

    private boolean recvMessageInternal(QueueSession session, String prop) throws JMSException {
        boolean retcode = false;
        TestUtil.logTrace((String)"MDB_Q_TestEJB.recvMessageInternal()");
        QueueReceiver rcvr = session.createReceiver(this.rcvrQueue);
        Message msgRec = null;
        for (int i = 0; i < 10; ++i) {
            TestUtil.logTrace((String)("@recvMessageInternal trying to receive the message: " + i));
            msgRec = rcvr.receive(this.timeout);
            if (msgRec != null) break;
        }
        if (msgRec != null) {
            if (msgRec.getStringProperty("TestCase") != null || msgRec.getStringProperty("Status") != null) {
                if (msgRec.getStringProperty("TestCase").equals(prop) && msgRec.getStringProperty("Status").equals("Pass")) {
                    TestUtil.logTrace((String)("TestCase: " + msgRec.getStringProperty("TestCase")));
                    TestUtil.logTrace((String)("Status from msg: " + msgRec.getStringProperty("Status")));
                    TestUtil.logTrace((String)"Pass: we got the expected msg back! ");
                    retcode = true;
                } else if (msgRec.getStringProperty("Status").equals("Fail")) {
                    TestUtil.logTrace((String)("TestCase: " + msgRec.getStringProperty("TestCase")));
                    TestUtil.logTrace((String)("Status from msg: " + msgRec.getStringProperty("Status")));
                    TestUtil.logTrace((String)"Fail: Error(s) occurred! ");
                } else {
                    TestUtil.logTrace((String)"Fail: we didnt get the expected msg back! ");
                    TestUtil.logTrace((String)("TestCase:  " + msgRec.getStringProperty("TestCase")));
                }
            } else if (msgRec.getStringProperty("MessageType") != null) {
                if (msgRec.getStringProperty("MessageType").equals(prop)) {
                    TestUtil.logTrace((String)("Success: received Msg from Q!  " + msgRec.getStringProperty("MessageType")));
                    TestUtil.logTrace((String)"Pass: we got the expected msg back! ");
                    retcode = true;
                } else {
                    TestUtil.logTrace((String)"Fail: we didnt get the expected msg back! ");
                    TestUtil.logTrace((String)("MessageType:  " + msgRec.getStringProperty("MessageType")));
                }
            } else {
                TestUtil.logTrace((String)"Fail: we didnt get the expected msg back! ");
            }
        } else {
            TestUtil.logTrace((String)"Fail: we didnt get any msg back! ");
        }
        return retcode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isThereSomethingInTheQueue() {
        TestUtil.logTrace((String)"MDB_Q_TestEJB.isThereSomethingInTheQueue()");
        QueueBrowser qBrowser = null;
        Enumeration msgs = null;
        boolean ret = false;
        try {
            this.qConnect = this.qFactory.createQueueConnection(this.jmsUser, this.jmsPassword);
            QueueSession session = this.qConnect.createQueueSession(true, 0);
            this.qConnect.start();
            qBrowser = session.createBrowser(this.rcvrQueue);
            msgs = qBrowser.getEnumeration();
            if (msgs.hasMoreElements()) {
                ret = true;
            }
            qBrowser.close();
            session.close();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Error in isThereSomethingInTheQueue", (Throwable)e);
        }
        finally {
            try {
                if (this.qConnect != null) {
                    this.qConnect.close();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error closing QueueConnection", (Throwable)e);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanTheQueue() {
        TestUtil.logTrace((String)"MDB_Q_TestEJB.cleanTheQueue()");
        QueueBrowser qBrowser = null;
        Enumeration msgs = null;
        int numMsgs = 0;
        try {
            this.qConnect = this.qFactory.createQueueConnection(this.jmsUser, this.jmsPassword);
            QueueSession session = this.qConnect.createQueueSession(true, 0);
            this.qConnect.start();
            TextMessage msgRec = null;
            qBrowser = session.createBrowser(this.rcvrQueue);
            msgs = qBrowser.getEnumeration();
            while (msgs.hasMoreElements()) {
                msgs.nextElement();
                ++numMsgs;
            }
            qBrowser.close();
            QueueReceiver rcvr = session.createReceiver(this.rcvrQueue);
            TestUtil.logTrace((String)("Cleaning " + numMsgs + " messages from the Q: " + this.rcvrQueue.getQueueName()));
            block12: for (int n = 0; n < numMsgs; ++n) {
                TestUtil.logTrace((String)("dequeuing msg: " + n + " from the Q: " + this.rcvrQueue.getQueueName()));
                for (int i = 0; i < 10; ++i) {
                    msgRec = (TextMessage)rcvr.receive(this.timeout);
                    if (msgRec != null) {
                        TestUtil.logTrace((String)("dequeued message: " + n));
                        continue block12;
                    }
                    TestUtil.logTrace((String)("Attempt no: " + i + " Trying to dequeue message: " + n));
                }
            }
            session.close();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Error in cleanTheQueue", (Throwable)e);
        }
        finally {
            try {
                if (this.qConnect != null) {
                    this.qConnect.close();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error closing QueueConnection", (Throwable)e);
            }
        }
    }

    @Override
    @Remove
    public void remove() {
        TestUtil.logTrace((String)"MDB_Q_TestEJB.remove()");
    }

    @PostActivate
    public void activate() {
        TestUtil.logTrace((String)"MDB_Q_TestEJB.activate()");
        try {
            TSNamingContext context = new TSNamingContext();
            TestUtil.logTrace((String)"got the context");
            this.rcvrQueue = (Queue)context.lookup("java:comp/env/jms/MDB_QUEUE_REPLY");
            this.q = (Queue)context.lookup("java:comp/env/jms/MDB_QUEUE");
            this.qFactory = (QueueConnectionFactory)context.lookup("java:comp/env/jms/MyQueueConnectionFactory");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Error looking up Queue, QueueConnectionFactory objects", (Throwable)e);
            throw new EJBException("@activate: Error!", e);
        }
    }

    @PrePassivate
    public void passivate() {
        TestUtil.logTrace((String)"MDB_Q_TestEJB.passivate()");
        if (this.qConnect != null) {
            try {
                this.qConnect.close();
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error closing QueueConnection", (Throwable)e);
            }
            this.qConnect = null;
        }
        this.rcvrQueue = null;
        this.q = null;
        this.qFactory = null;
    }
}

